/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.concurrent;

import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutorGroup;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.NonStickyEventExecutorGroup$1;
import io.grpc.netty.shaded.io.netty.util.concurrent.NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.OrderedEventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.ScheduledFuture;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class NonStickyEventExecutorGroup
implements EventExecutorGroup {
    private final EventExecutorGroup group;
    private final int maxTaskExecutePerRun;

    public NonStickyEventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
        this(eventExecutorGroup, 1024);
    }

    public NonStickyEventExecutorGroup(EventExecutorGroup eventExecutorGroup, int n4) {
        this.group = NonStickyEventExecutorGroup.verify(eventExecutorGroup);
        this.maxTaskExecutePerRun = ObjectUtil.checkPositive(n4, "maxTaskExecutePerRun");
    }

    private static EventExecutorGroup verify(EventExecutorGroup eventExecutorGroup) {
        for (EventExecutor eventExecutor : ObjectUtil.checkNotNull(eventExecutorGroup, "group")) {
            if (!(eventExecutor instanceof OrderedEventExecutor)) continue;
            throw new IllegalArgumentException("EventExecutorGroup " + eventExecutorGroup + " contains OrderedEventExecutors: " + eventExecutor);
        }
        return eventExecutorGroup;
    }

    private NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor newExecutor(EventExecutor eventExecutor) {
        return new NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor(eventExecutor, this.maxTaskExecutePerRun);
    }

    @Override
    public boolean isShuttingDown() {
        return this.group.isShuttingDown();
    }

    @Override
    public Future<?> shutdownGracefully() {
        return this.group.shutdownGracefully();
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l10, TimeUnit timeUnit) {
        return this.group.shutdownGracefully(l2, l10, timeUnit);
    }

    @Override
    public Future<?> terminationFuture() {
        return this.group.terminationFuture();
    }

    @Override
    public void shutdown() {
        this.group.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.group.shutdownNow();
    }

    @Override
    public EventExecutor next() {
        return this.newExecutor(this.group.next());
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        Iterator<EventExecutor> iterator = this.group.iterator();
        return new NonStickyEventExecutorGroup$1(this, iterator);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.group.submit(runnable);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t3) {
        return this.group.submit(runnable, t3);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.group.submit(callable);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.group.schedule(runnable, l2, timeUnit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        return this.group.schedule(callable, l2, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l10, TimeUnit timeUnit) {
        return this.group.scheduleAtFixedRate(runnable, l2, l10, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l10, TimeUnit timeUnit) {
        return this.group.scheduleWithFixedDelay(runnable, l2, l10, timeUnit);
    }

    @Override
    public boolean isShutdown() {
        return this.group.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.group.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        return this.group.awaitTermination(l2, timeUnit);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        return this.group.invokeAll(collection);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) {
        return this.group.invokeAll(collection, l2, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) {
        return this.group.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) {
        return this.group.invokeAny(collection, l2, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.group.execute(runnable);
    }

    static /* synthetic */ NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor access$000(NonStickyEventExecutorGroup nonStickyEventExecutorGroup, EventExecutor eventExecutor) {
        return nonStickyEventExecutorGroup.newExecutor(eventExecutor);
    }
}

