/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.concurrent;

import io.grpc.netty.shaded.io.netty.util.concurrent.AbstractEventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.OrderedEventExecutor;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor
extends AbstractEventExecutor
implements OrderedEventExecutor,
Runnable {
    private final EventExecutor executor;
    private final Queue<Runnable> tasks = PlatformDependent.newMpscQueue();
    private static final int NONE = 0;
    private static final int SUBMITTED = 1;
    private static final int RUNNING = 2;
    private final AtomicInteger state = new AtomicInteger();
    private final int maxTaskExecutePerRun;

    NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor(EventExecutor eventExecutor, int n4) {
        super(eventExecutor);
        this.executor = eventExecutor;
        this.maxTaskExecutePerRun = n4;
    }

    @Override
    public void run() {
        if (!this.state.compareAndSet(1, 2)) {
            return;
        }
        block7: while (true) {
            int n4 = 0;
            try {
                while (true) {
                    Runnable runnable;
                    if (n4 >= this.maxTaskExecutePerRun || (runnable = this.tasks.poll()) == null) continue block7;
                    NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor.safeExecute(runnable);
                    ++n4;
                }
            }
            finally {
                if (n4 == this.maxTaskExecutePerRun) {
                    try {
                        this.state.set(1);
                        this.executor.execute(this);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.state.set(2);
                    }
                } else {
                    this.state.set(0);
                    if (this.tasks.peek() != null && this.state.compareAndSet(0, 2)) continue;
                    return;
                }
                continue;
            }
            break;
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return false;
    }

    @Override
    public boolean inEventLoop() {
        return false;
    }

    @Override
    public boolean isShuttingDown() {
        return this.executor.isShutdown();
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l10, TimeUnit timeUnit) {
        return this.executor.shutdownGracefully(l2, l10, timeUnit);
    }

    @Override
    public Future<?> terminationFuture() {
        return this.executor.terminationFuture();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        return this.executor.awaitTermination(l2, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        if (!this.tasks.offer(runnable)) {
            throw new RejectedExecutionException();
        }
        if (this.state.compareAndSet(0, 1)) {
            try {
                this.executor.execute(this);
            }
            catch (Throwable throwable) {
                this.tasks.remove(runnable);
                PlatformDependent.throwException(throwable);
            }
        }
    }
}

