/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.concurrent;

import io.grpc.netty.shaded.io.netty.util.concurrent.AbstractEventExecutorGroup;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultPromise;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutorChooserFactory;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutorChooserFactory$EventExecutorChooser;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.GlobalEventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.MultithreadEventExecutorGroup$1;
import io.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import io.grpc.netty.shaded.io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultithreadEventExecutorGroup
extends AbstractEventExecutorGroup {
    private final EventExecutor[] children;
    private final Set<EventExecutor> readonlyChildren;
    private final AtomicInteger terminatedChildren = new AtomicInteger();
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private final EventExecutorChooserFactory$EventExecutorChooser chooser;

    protected MultithreadEventExecutorGroup(int n4, ThreadFactory threadFactory, Object ... objectArray) {
        this(n4, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor(threadFactory)), objectArray);
    }

    protected MultithreadEventExecutorGroup(int n4, Executor executor, Object ... objectArray) {
        this(n4, executor, DefaultEventExecutorChooserFactory.INSTANCE, objectArray);
    }

    protected MultithreadEventExecutorGroup(int n4, Executor executor, EventExecutorChooserFactory eventExecutorChooserFactory, Object ... objectArray) {
        if (n4 <= 0) {
            throw new IllegalArgumentException(String.format("nThreads: %d (expected: > 0)", n4));
        }
        if (executor == null) {
            executor = new ThreadPerTaskExecutor(this.newDefaultThreadFactory());
        }
        this.children = new EventExecutor[n4];
        for (int i3 = 0; i3 < n4; ++i3) {
            boolean bl3 = false;
            try {
                this.children[i3] = this.newChild(executor, objectArray);
                bl3 = true;
                continue;
            }
            catch (Exception exception) {
                throw new IllegalStateException("failed to create a child event loop", exception);
            }
            finally {
                if (!bl3) {
                    int n7;
                    for (n7 = 0; n7 < i3; ++n7) {
                        this.children[n7].shutdownGracefully();
                    }
                    for (n7 = 0; n7 < i3; ++n7) {
                        EventExecutor eventExecutor = this.children[n7];
                        try {
                            while (!eventExecutor.isTerminated()) {
                                eventExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                            }
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
            }
        }
        this.chooser = eventExecutorChooserFactory.newChooser(this.children);
        MultithreadEventExecutorGroup$1 multithreadEventExecutorGroup$1 = new MultithreadEventExecutorGroup$1(this);
        for (EventExecutor eventExecutor : this.children) {
            eventExecutor.terminationFuture().addListener(multithreadEventExecutorGroup$1);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.children.length);
        Collections.addAll(linkedHashSet, this.children);
        this.readonlyChildren = Collections.unmodifiableSet(linkedHashSet);
    }

    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass());
    }

    @Override
    public EventExecutor next() {
        return this.chooser.next();
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.readonlyChildren.iterator();
    }

    public final int executorCount() {
        return this.children.length;
    }

    protected abstract EventExecutor newChild(Executor var1, Object ... var2);

    @Override
    public Future<?> shutdownGracefully(long l2, long l10, TimeUnit timeUnit) {
        for (EventExecutor eventExecutor : this.children) {
            eventExecutor.shutdownGracefully(l2, l10, timeUnit);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        for (EventExecutor eventExecutor : this.children) {
            eventExecutor.shutdown();
        }
    }

    @Override
    public boolean isShuttingDown() {
        for (EventExecutor eventExecutor : this.children) {
            if (eventExecutor.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        for (EventExecutor eventExecutor : this.children) {
            if (eventExecutor.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (EventExecutor eventExecutor : this.children) {
            if (eventExecutor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        long l10 = System.nanoTime() + timeUnit.toNanos(l2);
        block0: for (EventExecutor eventExecutor : this.children) {
            long l11;
            while ((l11 = l10 - System.nanoTime()) > 0L) {
                if (!eventExecutor.awaitTermination(l11, TimeUnit.NANOSECONDS)) continue;
                continue block0;
            }
            break block0;
        }
        return this.isTerminated();
    }

    static /* synthetic */ AtomicInteger access$000(MultithreadEventExecutorGroup multithreadEventExecutorGroup) {
        return multithreadEventExecutorGroup.terminatedChildren;
    }

    static /* synthetic */ EventExecutor[] access$100(MultithreadEventExecutorGroup multithreadEventExecutorGroup) {
        return multithreadEventExecutorGroup.children;
    }

    static /* synthetic */ Promise access$200(MultithreadEventExecutorGroup multithreadEventExecutorGroup) {
        return multithreadEventExecutorGroup.terminationFuture;
    }
}

