/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.concurrent;

import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocalRunnable;
import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocalThread;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolId = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;
    private final int priority;
    protected final ThreadGroup threadGroup;

    public DefaultThreadFactory(Class<?> clazz) {
        this(clazz, false, 5);
    }

    public DefaultThreadFactory(String string) {
        this(string, false, 5);
    }

    public DefaultThreadFactory(Class<?> clazz, boolean bl3) {
        this(clazz, bl3, 5);
    }

    public DefaultThreadFactory(String string, boolean bl3) {
        this(string, bl3, 5);
    }

    public DefaultThreadFactory(Class<?> clazz, int n4) {
        this(clazz, false, n4);
    }

    public DefaultThreadFactory(String string, int n4) {
        this(string, false, n4);
    }

    public DefaultThreadFactory(Class<?> clazz, boolean bl3, int n4) {
        this(DefaultThreadFactory.toPoolName(clazz), bl3, n4);
    }

    public static String toPoolName(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("poolType");
        }
        String string = StringUtil.simpleClassName(clazz);
        switch (string.length()) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return string.toLowerCase(Locale.US);
            }
        }
        if (Character.isUpperCase(string.charAt(0)) && Character.isLowerCase(string.charAt(1))) {
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public DefaultThreadFactory(String string, boolean bl3, int n4, ThreadGroup threadGroup) {
        if (string == null) {
            throw new NullPointerException("poolName");
        }
        if (n4 < 1 || n4 > 10) {
            throw new IllegalArgumentException("priority: " + n4 + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
        }
        this.prefix = string + '-' + poolId.incrementAndGet() + '-';
        this.daemon = bl3;
        this.priority = n4;
        this.threadGroup = threadGroup;
    }

    public DefaultThreadFactory(String string, boolean bl3, int n4) {
        this(string, bl3, n4, System.getSecurityManager() == null ? Thread.currentThread().getThreadGroup() : System.getSecurityManager().getThreadGroup());
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.newThread(FastThreadLocalRunnable.wrap(runnable), this.prefix + this.nextId.incrementAndGet());
        try {
            if (thread.isDaemon() != this.daemon) {
                thread.setDaemon(this.daemon);
            }
            if (thread.getPriority() != this.priority) {
                thread.setPriority(this.priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return thread;
    }

    protected Thread newThread(Runnable runnable, String string) {
        return new FastThreadLocalThread(this.threadGroup, runnable, string);
    }
}

