/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.concurrent;

import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultPromise;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.grpc.netty.shaded.io.netty.util.concurrent.ProgressivePromise;

public class DefaultProgressivePromise<V>
extends DefaultPromise<V>
implements ProgressivePromise<V> {
    public DefaultProgressivePromise(EventExecutor eventExecutor) {
        super(eventExecutor);
    }

    protected DefaultProgressivePromise() {
    }

    @Override
    public ProgressivePromise<V> setProgress(long l2, long l10) {
        if (l10 < 0L) {
            l10 = -1L;
            if (l2 < 0L) {
                throw new IllegalArgumentException("progress: " + l2 + " (expected: >= 0)");
            }
        } else if (l2 < 0L || l2 > l10) {
            throw new IllegalArgumentException("progress: " + l2 + " (expected: 0 <= progress <= total (" + l10 + "))");
        }
        if (this.isDone()) {
            throw new IllegalStateException("complete already");
        }
        this.notifyProgressiveListeners(l2, l10);
        return this;
    }

    @Override
    public boolean tryProgress(long l2, long l10) {
        if (l10 < 0L) {
            l10 = -1L;
            if (l2 < 0L || this.isDone()) {
                return false;
            }
        } else if (l2 < 0L || l2 > l10 || this.isDone()) {
            return false;
        }
        this.notifyProgressiveListeners(l2, l10);
        return true;
    }

    @Override
    public ProgressivePromise<V> addListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        super.addListener((GenericFutureListener)genericFutureListener);
        return this;
    }

    @Override
    public ProgressivePromise<V> addListeners(GenericFutureListener<? extends Future<? super V>> ... genericFutureListenerArray) {
        super.addListeners((GenericFutureListener[])genericFutureListenerArray);
        return this;
    }

    @Override
    public ProgressivePromise<V> removeListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        super.removeListener((GenericFutureListener)genericFutureListener);
        return this;
    }

    @Override
    public ProgressivePromise<V> removeListeners(GenericFutureListener<? extends Future<? super V>> ... genericFutureListenerArray) {
        super.removeListeners((GenericFutureListener[])genericFutureListenerArray);
        return this;
    }

    @Override
    public ProgressivePromise<V> sync() {
        super.sync();
        return this;
    }

    @Override
    public ProgressivePromise<V> syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public ProgressivePromise<V> await() {
        super.await();
        return this;
    }

    @Override
    public ProgressivePromise<V> awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    public ProgressivePromise<V> setSuccess(V v3) {
        super.setSuccess(v3);
        return this;
    }

    @Override
    public ProgressivePromise<V> setFailure(Throwable throwable) {
        super.setFailure(throwable);
        return this;
    }
}

