/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.concurrent;

import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericProgressiveFutureListener;
import java.util.Arrays;

final class DefaultFutureListeners {
    private GenericFutureListener<? extends Future<?>>[] listeners = new GenericFutureListener[2];
    private int size;
    private int progressiveSize;

    DefaultFutureListeners(GenericFutureListener<? extends Future<?>> genericFutureListener, GenericFutureListener<? extends Future<?>> genericFutureListener2) {
        this.listeners[0] = genericFutureListener;
        this.listeners[1] = genericFutureListener2;
        this.size = 2;
        if (genericFutureListener instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
        if (genericFutureListener2 instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public void add(GenericFutureListener<? extends Future<?>> genericFutureListener) {
        int n4 = this.size;
        GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = this.listeners;
        if (n4 == genericFutureListenerArray.length) {
            this.listeners = genericFutureListenerArray = Arrays.copyOf(genericFutureListenerArray, n4 << 1);
        }
        genericFutureListenerArray[n4] = genericFutureListener;
        this.size = n4 + 1;
        if (genericFutureListener instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public void remove(GenericFutureListener<? extends Future<?>> genericFutureListener) {
        GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = this.listeners;
        int n4 = this.size;
        for (int i3 = 0; i3 < n4; ++i3) {
            if (genericFutureListenerArray[i3] != genericFutureListener) continue;
            int n7 = n4 - i3 - 1;
            if (n7 > 0) {
                System.arraycopy(genericFutureListenerArray, i3 + 1, genericFutureListenerArray, i3, n7);
            }
            genericFutureListenerArray[--n4] = null;
            this.size = n4;
            if (genericFutureListener instanceof GenericProgressiveFutureListener) {
                --this.progressiveSize;
            }
            return;
        }
    }

    public GenericFutureListener<? extends Future<?>>[] listeners() {
        return this.listeners;
    }

    public int size() {
        return this.size;
    }

    public int progressiveSize() {
        return this.progressiveSize;
    }
}

