/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.collection;

import io.grpc.netty.shaded.io.netty.util.collection.ShortObjectHashMap$1;
import io.grpc.netty.shaded.io.netty.util.collection.ShortObjectHashMap$2;
import io.grpc.netty.shaded.io.netty.util.collection.ShortObjectHashMap$EntrySet;
import io.grpc.netty.shaded.io.netty.util.collection.ShortObjectHashMap$KeySet;
import io.grpc.netty.shaded.io.netty.util.collection.ShortObjectMap;
import io.grpc.netty.shaded.io.netty.util.collection.ShortObjectMap$PrimitiveEntry;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ShortObjectHashMap<V>
implements ShortObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private short[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Short> keySet = new ShortObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Short, V>> entrySet = new ShortObjectHashMap$EntrySet(this, null);
    private final Iterable<ShortObjectMap$PrimitiveEntry<V>> entries = new ShortObjectHashMap$1(this);

    public ShortObjectHashMap() {
        this(8, 0.5f);
    }

    public ShortObjectHashMap(int n4) {
        this(n4, 0.5f);
    }

    public ShortObjectHashMap(int n4, float f8) {
        if (f8 <= 0.0f || f8 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f8;
        int n7 = MathUtil.safeFindNextPositivePowerOfTwo(n4);
        this.mask = n7 - 1;
        this.keys = new short[n7];
        Object[] objectArray = new Object[n7];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n7);
    }

    private static <T> T toExternal(T t3) {
        assert (t3 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t3 == NULL_VALUE ? null : (T)t3;
    }

    private static <T> T toInternal(T t3) {
        return (T)(t3 == null ? NULL_VALUE : t3);
    }

    @Override
    public V get(short s11) {
        int n4 = this.indexOf(s11);
        return n4 == -1 ? null : (V)ShortObjectHashMap.toExternal(this.values[n4]);
    }

    @Override
    public V put(short s11, V v3) {
        int n4;
        int n7 = n4 = this.hashIndex(s11);
        do {
            if (this.values[n7] == null) {
                this.keys[n7] = s11;
                this.values[n7] = ShortObjectHashMap.toInternal(v3);
                this.growSize();
                return null;
            }
            if (this.keys[n7] != s11) continue;
            V v4 = this.values[n7];
            this.values[n7] = ShortObjectHashMap.toInternal(v3);
            return ShortObjectHashMap.toExternal(v4);
        } while ((n7 = this.probeNext(n7)) != n4);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Short, ? extends V> map) {
        if (map instanceof ShortObjectHashMap) {
            ShortObjectHashMap shortObjectHashMap = (ShortObjectHashMap)map;
            for (int i3 = 0; i3 < shortObjectHashMap.values.length; ++i3) {
                V v3 = shortObjectHashMap.values[i3];
                if (v3 == null) continue;
                this.put(shortObjectHashMap.keys[i3], v3);
            }
            return;
        }
        for (Map.Entry<Short, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(short s11) {
        int n4 = this.indexOf(s11);
        if (n4 == -1) {
            return null;
        }
        V v3 = this.values[n4];
        this.removeAt(n4);
        return ShortObjectHashMap.toExternal(v3);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(short s11) {
        return this.indexOf(s11) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = ShortObjectHashMap.toInternal(object);
        for (V v3 : this.values) {
            if (v3 == null || !v3.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ShortObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new ShortObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n4 = this.size;
        for (short s11 : this.keys) {
            n4 ^= ShortObjectHashMap.hashCode(s11);
        }
        return n4;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ShortObjectMap)) {
            return false;
        }
        ShortObjectMap shortObjectMap = (ShortObjectMap)object;
        if (this.size != shortObjectMap.size()) {
            return false;
        }
        for (int i3 = 0; i3 < this.values.length; ++i3) {
            V v3 = this.values[i3];
            if (v3 == null) continue;
            short s11 = this.keys[i3];
            Object v4 = shortObjectMap.get(s11);
            if (!(v3 == NULL_VALUE ? v4 != null : !v3.equals(v4))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Short s11, V v3) {
        return this.put(this.objectToKey(s11), v3);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Short> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Short, V>> entrySet() {
        return this.entrySet;
    }

    private short objectToKey(Object object) {
        return (Short)object;
    }

    private int indexOf(short s11) {
        int n4;
        int n7 = n4 = this.hashIndex(s11);
        do {
            if (this.values[n7] == null) {
                return -1;
            }
            if (s11 != this.keys[n7]) continue;
            return n7;
        } while ((n7 = this.probeNext(n7)) != n4);
        return -1;
    }

    private int hashIndex(short s11) {
        return ShortObjectHashMap.hashCode(s11) & this.mask;
    }

    private static int hashCode(short s11) {
        return s11;
    }

    private int probeNext(int n4) {
        return n4 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n4) {
        --this.size;
        this.keys[n4] = 0;
        this.values[n4] = null;
        int n7 = n4;
        int n8 = this.probeNext(n4);
        V v3 = this.values[n8];
        while (v3 != null) {
            short s11 = this.keys[n8];
            int n10 = this.hashIndex(s11);
            if (n8 < n10 && (n10 <= n7 || n7 <= n8) || n10 <= n7 && n7 <= n8) {
                this.keys[n7] = s11;
                this.values[n7] = v3;
                this.keys[n8] = 0;
                this.values[n8] = null;
                n7 = n8;
            }
            n8 = this.probeNext(n8);
            v3 = this.values[n8];
        }
        return n7 != n4;
    }

    private int calcMaxSize(int n4) {
        int n7 = n4 - 1;
        return Math.min(n7, (int)((float)n4 * this.loadFactor));
    }

    private void rehash(int n4) {
        short[] sArray = this.keys;
        V[] VArray = this.values;
        this.keys = new short[n4];
        Object[] objectArray = new Object[n4];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n4);
        this.mask = n4 - 1;
        block0: for (int i3 = 0; i3 < VArray.length; ++i3) {
            V v3 = VArray[i3];
            if (v3 == null) continue;
            short s11 = sArray[i3];
            int n7 = this.hashIndex(s11);
            while (true) {
                if (this.values[n7] == null) {
                    this.keys[n7] = s11;
                    this.values[n7] = v3;
                    continue block0;
                }
                n7 = this.probeNext(n7);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl3 = true;
        for (int i3 = 0; i3 < this.values.length; ++i3) {
            V v3 = this.values[i3];
            if (v3 == null) continue;
            if (!bl3) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i3])).append('=').append((Object)(v3 == this ? "(this Map)" : ShortObjectHashMap.toExternal(v3)));
            bl3 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(short s11) {
        return Short.toString(s11);
    }

    static /* synthetic */ int access$300(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(ShortObjectHashMap shortObjectHashMap, int n4) {
        return shortObjectHashMap.removeAt(n4);
    }

    static /* synthetic */ short[] access$800(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return ShortObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return ShortObjectHashMap.toInternal(object);
    }
}

