/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.collection;

import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap$1;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap$2;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap$EntrySet;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap$KeySet;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectMap;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectMap$PrimitiveEntry;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class IntObjectHashMap<V>
implements IntObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private int[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Integer> keySet = new IntObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Integer, V>> entrySet = new IntObjectHashMap$EntrySet(this, null);
    private final Iterable<IntObjectMap$PrimitiveEntry<V>> entries = new IntObjectHashMap$1(this);

    public IntObjectHashMap() {
        this(8, 0.5f);
    }

    public IntObjectHashMap(int n4) {
        this(n4, 0.5f);
    }

    public IntObjectHashMap(int n4, float f8) {
        if (f8 <= 0.0f || f8 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f8;
        int n7 = MathUtil.safeFindNextPositivePowerOfTwo(n4);
        this.mask = n7 - 1;
        this.keys = new int[n7];
        Object[] objectArray = new Object[n7];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n7);
    }

    private static <T> T toExternal(T t3) {
        assert (t3 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t3 == NULL_VALUE ? null : (T)t3;
    }

    private static <T> T toInternal(T t3) {
        return (T)(t3 == null ? NULL_VALUE : t3);
    }

    @Override
    public V get(int n4) {
        int n7 = this.indexOf(n4);
        return n7 == -1 ? null : (V)IntObjectHashMap.toExternal(this.values[n7]);
    }

    @Override
    public V put(int n4, V v3) {
        int n7;
        int n8 = n7 = this.hashIndex(n4);
        do {
            if (this.values[n8] == null) {
                this.keys[n8] = n4;
                this.values[n8] = IntObjectHashMap.toInternal(v3);
                this.growSize();
                return null;
            }
            if (this.keys[n8] != n4) continue;
            V v4 = this.values[n8];
            this.values[n8] = IntObjectHashMap.toInternal(v3);
            return IntObjectHashMap.toExternal(v4);
        } while ((n8 = this.probeNext(n8)) != n7);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        if (map instanceof IntObjectHashMap) {
            IntObjectHashMap intObjectHashMap = (IntObjectHashMap)map;
            for (int i3 = 0; i3 < intObjectHashMap.values.length; ++i3) {
                V v3 = intObjectHashMap.values[i3];
                if (v3 == null) continue;
                this.put(intObjectHashMap.keys[i3], v3);
            }
            return;
        }
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(int n4) {
        int n7 = this.indexOf(n4);
        if (n7 == -1) {
            return null;
        }
        V v3 = this.values[n7];
        this.removeAt(n7);
        return IntObjectHashMap.toExternal(v3);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(int n4) {
        return this.indexOf(n4) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = IntObjectHashMap.toInternal(object);
        for (V v3 : this.values) {
            if (v3 == null || !v3.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IntObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new IntObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n4 = this.size;
        for (int n7 : this.keys) {
            n4 ^= IntObjectHashMap.hashCode(n7);
        }
        return n4;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntObjectMap)) {
            return false;
        }
        IntObjectMap intObjectMap = (IntObjectMap)object;
        if (this.size != intObjectMap.size()) {
            return false;
        }
        for (int i3 = 0; i3 < this.values.length; ++i3) {
            V v3 = this.values[i3];
            if (v3 == null) continue;
            int n4 = this.keys[i3];
            Object v4 = intObjectMap.get(n4);
            if (!(v3 == NULL_VALUE ? v4 != null : !v3.equals(v4))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Integer n4, V v3) {
        return this.put(this.objectToKey(n4), v3);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Integer> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return this.entrySet;
    }

    private int objectToKey(Object object) {
        return (Integer)object;
    }

    private int indexOf(int n4) {
        int n7;
        int n8 = n7 = this.hashIndex(n4);
        do {
            if (this.values[n8] == null) {
                return -1;
            }
            if (n4 != this.keys[n8]) continue;
            return n8;
        } while ((n8 = this.probeNext(n8)) != n7);
        return -1;
    }

    private int hashIndex(int n4) {
        return IntObjectHashMap.hashCode(n4) & this.mask;
    }

    private static int hashCode(int n4) {
        return n4;
    }

    private int probeNext(int n4) {
        return n4 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n4) {
        --this.size;
        this.keys[n4] = 0;
        this.values[n4] = null;
        int n7 = n4;
        int n8 = this.probeNext(n4);
        V v3 = this.values[n8];
        while (v3 != null) {
            int n10 = this.keys[n8];
            int n11 = this.hashIndex(n10);
            if (n8 < n11 && (n11 <= n7 || n7 <= n8) || n11 <= n7 && n7 <= n8) {
                this.keys[n7] = n10;
                this.values[n7] = v3;
                this.keys[n8] = 0;
                this.values[n8] = null;
                n7 = n8;
            }
            n8 = this.probeNext(n8);
            v3 = this.values[n8];
        }
        return n7 != n4;
    }

    private int calcMaxSize(int n4) {
        int n7 = n4 - 1;
        return Math.min(n7, (int)((float)n4 * this.loadFactor));
    }

    private void rehash(int n4) {
        int[] nArray = this.keys;
        V[] VArray = this.values;
        this.keys = new int[n4];
        Object[] objectArray = new Object[n4];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n4);
        this.mask = n4 - 1;
        block0: for (int i3 = 0; i3 < VArray.length; ++i3) {
            V v3 = VArray[i3];
            if (v3 == null) continue;
            int n7 = nArray[i3];
            int n8 = this.hashIndex(n7);
            while (true) {
                if (this.values[n8] == null) {
                    this.keys[n8] = n7;
                    this.values[n8] = v3;
                    continue block0;
                }
                n8 = this.probeNext(n8);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl3 = true;
        for (int i3 = 0; i3 < this.values.length; ++i3) {
            V v3 = this.values[i3];
            if (v3 == null) continue;
            if (!bl3) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i3])).append('=').append((Object)(v3 == this ? "(this Map)" : IntObjectHashMap.toExternal(v3)));
            bl3 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(int n4) {
        return Integer.toString(n4);
    }

    static /* synthetic */ int access$300(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(IntObjectHashMap intObjectHashMap, int n4) {
        return intObjectHashMap.removeAt(n4);
    }

    static /* synthetic */ int[] access$800(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return IntObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return IntObjectHashMap.toInternal(object);
    }
}

