/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.collection;

import io.grpc.netty.shaded.io.netty.util.collection.CharObjectHashMap$1;
import io.grpc.netty.shaded.io.netty.util.collection.CharObjectHashMap$2;
import io.grpc.netty.shaded.io.netty.util.collection.CharObjectHashMap$EntrySet;
import io.grpc.netty.shaded.io.netty.util.collection.CharObjectHashMap$KeySet;
import io.grpc.netty.shaded.io.netty.util.collection.CharObjectMap;
import io.grpc.netty.shaded.io.netty.util.collection.CharObjectMap$PrimitiveEntry;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class CharObjectHashMap<V>
implements CharObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private char[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Character> keySet = new CharObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Character, V>> entrySet = new CharObjectHashMap$EntrySet(this, null);
    private final Iterable<CharObjectMap$PrimitiveEntry<V>> entries = new CharObjectHashMap$1(this);

    public CharObjectHashMap() {
        this(8, 0.5f);
    }

    public CharObjectHashMap(int n4) {
        this(n4, 0.5f);
    }

    public CharObjectHashMap(int n4, float f8) {
        if (f8 <= 0.0f || f8 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f8;
        int n7 = MathUtil.safeFindNextPositivePowerOfTwo(n4);
        this.mask = n7 - 1;
        this.keys = new char[n7];
        Object[] objectArray = new Object[n7];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n7);
    }

    private static <T> T toExternal(T t3) {
        assert (t3 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t3 == NULL_VALUE ? null : (T)t3;
    }

    private static <T> T toInternal(T t3) {
        return (T)(t3 == null ? NULL_VALUE : t3);
    }

    @Override
    public V get(char c10) {
        int n4 = this.indexOf(c10);
        return n4 == -1 ? null : (V)CharObjectHashMap.toExternal(this.values[n4]);
    }

    @Override
    public V put(char c10, V v3) {
        int n4;
        int n7 = n4 = this.hashIndex(c10);
        do {
            if (this.values[n7] == null) {
                this.keys[n7] = c10;
                this.values[n7] = CharObjectHashMap.toInternal(v3);
                this.growSize();
                return null;
            }
            if (this.keys[n7] != c10) continue;
            V v4 = this.values[n7];
            this.values[n7] = CharObjectHashMap.toInternal(v3);
            return CharObjectHashMap.toExternal(v4);
        } while ((n7 = this.probeNext(n7)) != n4);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Character, ? extends V> map) {
        if (map instanceof CharObjectHashMap) {
            CharObjectHashMap charObjectHashMap = (CharObjectHashMap)map;
            for (int i3 = 0; i3 < charObjectHashMap.values.length; ++i3) {
                V v3 = charObjectHashMap.values[i3];
                if (v3 == null) continue;
                this.put(charObjectHashMap.keys[i3], v3);
            }
            return;
        }
        for (Map.Entry<Character, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(char c10) {
        int n4 = this.indexOf(c10);
        if (n4 == -1) {
            return null;
        }
        V v3 = this.values[n4];
        this.removeAt(n4);
        return CharObjectHashMap.toExternal(v3);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(char c10) {
        return this.indexOf(c10) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = CharObjectHashMap.toInternal(object);
        for (V v3 : this.values) {
            if (v3 == null || !v3.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<CharObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new CharObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n4 = this.size;
        for (char c10 : this.keys) {
            n4 ^= CharObjectHashMap.hashCode(c10);
        }
        return n4;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharObjectMap)) {
            return false;
        }
        CharObjectMap charObjectMap = (CharObjectMap)object;
        if (this.size != charObjectMap.size()) {
            return false;
        }
        for (int i3 = 0; i3 < this.values.length; ++i3) {
            V v3 = this.values[i3];
            if (v3 == null) continue;
            char c10 = this.keys[i3];
            Object v4 = charObjectMap.get(c10);
            if (!(v3 == NULL_VALUE ? v4 != null : !v3.equals(v4))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Character c10, V v3) {
        return this.put(this.objectToKey(c10), v3);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Character> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Character, V>> entrySet() {
        return this.entrySet;
    }

    private char objectToKey(Object object) {
        return ((Character)object).charValue();
    }

    private int indexOf(char c10) {
        int n4;
        int n7 = n4 = this.hashIndex(c10);
        do {
            if (this.values[n7] == null) {
                return -1;
            }
            if (c10 != this.keys[n7]) continue;
            return n7;
        } while ((n7 = this.probeNext(n7)) != n4);
        return -1;
    }

    private int hashIndex(char c10) {
        return CharObjectHashMap.hashCode(c10) & this.mask;
    }

    private static int hashCode(char c10) {
        return c10;
    }

    private int probeNext(int n4) {
        return n4 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n4) {
        --this.size;
        this.keys[n4] = '\u0000';
        this.values[n4] = null;
        int n7 = n4;
        int n8 = this.probeNext(n4);
        V v3 = this.values[n8];
        while (v3 != null) {
            char c10 = this.keys[n8];
            int n10 = this.hashIndex(c10);
            if (n8 < n10 && (n10 <= n7 || n7 <= n8) || n10 <= n7 && n7 <= n8) {
                this.keys[n7] = c10;
                this.values[n7] = v3;
                this.keys[n8] = '\u0000';
                this.values[n8] = null;
                n7 = n8;
            }
            n8 = this.probeNext(n8);
            v3 = this.values[n8];
        }
        return n7 != n4;
    }

    private int calcMaxSize(int n4) {
        int n7 = n4 - 1;
        return Math.min(n7, (int)((float)n4 * this.loadFactor));
    }

    private void rehash(int n4) {
        char[] cArray = this.keys;
        V[] VArray = this.values;
        this.keys = new char[n4];
        Object[] objectArray = new Object[n4];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n4);
        this.mask = n4 - 1;
        block0: for (int i3 = 0; i3 < VArray.length; ++i3) {
            V v3 = VArray[i3];
            if (v3 == null) continue;
            char c10 = cArray[i3];
            int n7 = this.hashIndex(c10);
            while (true) {
                if (this.values[n7] == null) {
                    this.keys[n7] = c10;
                    this.values[n7] = v3;
                    continue block0;
                }
                n7 = this.probeNext(n7);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl3 = true;
        for (int i3 = 0; i3 < this.values.length; ++i3) {
            V v3 = this.values[i3];
            if (v3 == null) continue;
            if (!bl3) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i3])).append('=').append((Object)(v3 == this ? "(this Map)" : CharObjectHashMap.toExternal(v3)));
            bl3 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(char c10) {
        return Character.toString(c10);
    }

    static /* synthetic */ int access$300(CharObjectHashMap charObjectHashMap) {
        return charObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(CharObjectHashMap charObjectHashMap) {
        return charObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(CharObjectHashMap charObjectHashMap) {
        return charObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(CharObjectHashMap charObjectHashMap, int n4) {
        return charObjectHashMap.removeAt(n4);
    }

    static /* synthetic */ char[] access$800(CharObjectHashMap charObjectHashMap) {
        return charObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return CharObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return CharObjectHashMap.toInternal(object);
    }
}

