/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.collection;

import io.grpc.netty.shaded.io.netty.util.collection.ByteObjectHashMap$1;
import io.grpc.netty.shaded.io.netty.util.collection.ByteObjectHashMap$2;
import io.grpc.netty.shaded.io.netty.util.collection.ByteObjectHashMap$EntrySet;
import io.grpc.netty.shaded.io.netty.util.collection.ByteObjectHashMap$KeySet;
import io.grpc.netty.shaded.io.netty.util.collection.ByteObjectMap;
import io.grpc.netty.shaded.io.netty.util.collection.ByteObjectMap$PrimitiveEntry;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ByteObjectHashMap<V>
implements ByteObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private byte[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Byte> keySet = new ByteObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Byte, V>> entrySet = new ByteObjectHashMap$EntrySet(this, null);
    private final Iterable<ByteObjectMap$PrimitiveEntry<V>> entries = new ByteObjectHashMap$1(this);

    public ByteObjectHashMap() {
        this(8, 0.5f);
    }

    public ByteObjectHashMap(int n4) {
        this(n4, 0.5f);
    }

    public ByteObjectHashMap(int n4, float f8) {
        if (f8 <= 0.0f || f8 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f8;
        int n7 = MathUtil.safeFindNextPositivePowerOfTwo(n4);
        this.mask = n7 - 1;
        this.keys = new byte[n7];
        Object[] objectArray = new Object[n7];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n7);
    }

    private static <T> T toExternal(T t3) {
        assert (t3 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t3 == NULL_VALUE ? null : (T)t3;
    }

    private static <T> T toInternal(T t3) {
        return (T)(t3 == null ? NULL_VALUE : t3);
    }

    @Override
    public V get(byte by2) {
        int n4 = this.indexOf(by2);
        return n4 == -1 ? null : (V)ByteObjectHashMap.toExternal(this.values[n4]);
    }

    @Override
    public V put(byte by2, V v3) {
        int n4;
        int n7 = n4 = this.hashIndex(by2);
        do {
            if (this.values[n7] == null) {
                this.keys[n7] = by2;
                this.values[n7] = ByteObjectHashMap.toInternal(v3);
                this.growSize();
                return null;
            }
            if (this.keys[n7] != by2) continue;
            V v4 = this.values[n7];
            this.values[n7] = ByteObjectHashMap.toInternal(v3);
            return ByteObjectHashMap.toExternal(v4);
        } while ((n7 = this.probeNext(n7)) != n4);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends V> map) {
        if (map instanceof ByteObjectHashMap) {
            ByteObjectHashMap byteObjectHashMap = (ByteObjectHashMap)map;
            for (int i3 = 0; i3 < byteObjectHashMap.values.length; ++i3) {
                V v3 = byteObjectHashMap.values[i3];
                if (v3 == null) continue;
                this.put(byteObjectHashMap.keys[i3], v3);
            }
            return;
        }
        for (Map.Entry<Byte, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(byte by2) {
        int n4 = this.indexOf(by2);
        if (n4 == -1) {
            return null;
        }
        V v3 = this.values[n4];
        this.removeAt(n4);
        return ByteObjectHashMap.toExternal(v3);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(byte by2) {
        return this.indexOf(by2) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = ByteObjectHashMap.toInternal(object);
        for (V v3 : this.values) {
            if (v3 == null || !v3.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ByteObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new ByteObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n4 = this.size;
        for (byte by2 : this.keys) {
            n4 ^= ByteObjectHashMap.hashCode(by2);
        }
        return n4;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteObjectMap)) {
            return false;
        }
        ByteObjectMap byteObjectMap = (ByteObjectMap)object;
        if (this.size != byteObjectMap.size()) {
            return false;
        }
        for (int i3 = 0; i3 < this.values.length; ++i3) {
            V v3 = this.values[i3];
            if (v3 == null) continue;
            byte by2 = this.keys[i3];
            Object v4 = byteObjectMap.get(by2);
            if (!(v3 == NULL_VALUE ? v4 != null : !v3.equals(v4))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Byte by2, V v3) {
        return this.put(this.objectToKey(by2), v3);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Byte> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Byte, V>> entrySet() {
        return this.entrySet;
    }

    private byte objectToKey(Object object) {
        return (Byte)object;
    }

    private int indexOf(byte by2) {
        int n4;
        int n7 = n4 = this.hashIndex(by2);
        do {
            if (this.values[n7] == null) {
                return -1;
            }
            if (by2 != this.keys[n7]) continue;
            return n7;
        } while ((n7 = this.probeNext(n7)) != n4);
        return -1;
    }

    private int hashIndex(byte by2) {
        return ByteObjectHashMap.hashCode(by2) & this.mask;
    }

    private static int hashCode(byte by2) {
        return by2;
    }

    private int probeNext(int n4) {
        return n4 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n4) {
        --this.size;
        this.keys[n4] = 0;
        this.values[n4] = null;
        int n7 = n4;
        int n8 = this.probeNext(n4);
        V v3 = this.values[n8];
        while (v3 != null) {
            byte by2 = this.keys[n8];
            int n10 = this.hashIndex(by2);
            if (n8 < n10 && (n10 <= n7 || n7 <= n8) || n10 <= n7 && n7 <= n8) {
                this.keys[n7] = by2;
                this.values[n7] = v3;
                this.keys[n8] = 0;
                this.values[n8] = null;
                n7 = n8;
            }
            n8 = this.probeNext(n8);
            v3 = this.values[n8];
        }
        return n7 != n4;
    }

    private int calcMaxSize(int n4) {
        int n7 = n4 - 1;
        return Math.min(n7, (int)((float)n4 * this.loadFactor));
    }

    private void rehash(int n4) {
        byte[] byArray = this.keys;
        V[] VArray = this.values;
        this.keys = new byte[n4];
        Object[] objectArray = new Object[n4];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n4);
        this.mask = n4 - 1;
        block0: for (int i3 = 0; i3 < VArray.length; ++i3) {
            V v3 = VArray[i3];
            if (v3 == null) continue;
            byte by2 = byArray[i3];
            int n7 = this.hashIndex(by2);
            while (true) {
                if (this.values[n7] == null) {
                    this.keys[n7] = by2;
                    this.values[n7] = v3;
                    continue block0;
                }
                n7 = this.probeNext(n7);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl3 = true;
        for (int i3 = 0; i3 < this.values.length; ++i3) {
            V v3 = this.values[i3];
            if (v3 == null) continue;
            if (!bl3) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i3])).append('=').append((Object)(v3 == this ? "(this Map)" : ByteObjectHashMap.toExternal(v3)));
            bl3 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(byte by2) {
        return Byte.toString(by2);
    }

    static /* synthetic */ int access$300(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(ByteObjectHashMap byteObjectHashMap, int n4) {
        return byteObjectHashMap.removeAt(n4);
    }

    static /* synthetic */ byte[] access$800(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return ByteObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return ByteObjectHashMap.toInternal(object);
    }
}

