/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.ResourceLeak;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetector;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetector$Record;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakTracker;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class ResourceLeakDetector$DefaultResourceLeak<T>
extends WeakReference<Object>
implements ResourceLeak,
ResourceLeakTracker<T> {
    private static final AtomicReferenceFieldUpdater<ResourceLeakDetector$DefaultResourceLeak<?>, ResourceLeakDetector$Record> headUpdater;
    private static final AtomicIntegerFieldUpdater<ResourceLeakDetector$DefaultResourceLeak<?>> droppedRecordsUpdater;
    private volatile ResourceLeakDetector$Record head;
    private volatile int droppedRecords;
    private final Set<ResourceLeakDetector$DefaultResourceLeak<?>> allLeaks;
    private final int trackedHash;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResourceLeakDetector$DefaultResourceLeak(Object object, ReferenceQueue<Object> referenceQueue, Set<ResourceLeakDetector$DefaultResourceLeak<?>> set) {
        super(object, referenceQueue);
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        this.trackedHash = System.identityHashCode(object);
        set.add(this);
        headUpdater.set(this, new ResourceLeakDetector$Record(ResourceLeakDetector$Record.access$100()));
        this.allLeaks = set;
    }

    @Override
    public void record() {
        this.record0(null);
    }

    @Override
    public void record(Object object) {
        this.record0(object);
    }

    private void record0(Object object) {
        if (ResourceLeakDetector.access$200() > 0) {
            boolean bl3;
            ResourceLeakDetector$Record resourceLeakDetector$Record;
            ResourceLeakDetector$Record resourceLeakDetector$Record2;
            ResourceLeakDetector$Record resourceLeakDetector$Record3;
            do {
                resourceLeakDetector$Record = resourceLeakDetector$Record3 = headUpdater.get(this);
                if (resourceLeakDetector$Record3 == null) {
                    return;
                }
                int n4 = ResourceLeakDetector$Record.access$300(resourceLeakDetector$Record3) + 1;
                if (n4 >= ResourceLeakDetector.access$200()) {
                    int n7 = Math.min(n4 - ResourceLeakDetector.access$200(), 30);
                    bl3 = PlatformDependent.threadLocalRandom().nextInt(1 << n7) != 0;
                    if (!bl3) continue;
                    resourceLeakDetector$Record = ResourceLeakDetector$Record.access$400(resourceLeakDetector$Record3);
                    continue;
                }
                bl3 = false;
            } while (!headUpdater.compareAndSet(this, resourceLeakDetector$Record3, resourceLeakDetector$Record2 = object != null ? new ResourceLeakDetector$Record(resourceLeakDetector$Record, object) : new ResourceLeakDetector$Record(resourceLeakDetector$Record)));
            if (bl3) {
                droppedRecordsUpdater.incrementAndGet(this);
            }
        }
    }

    boolean dispose() {
        this.clear();
        return this.allLeaks.remove(this);
    }

    @Override
    public boolean close() {
        if (this.allLeaks.remove(this)) {
            this.clear();
            headUpdater.set(this, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean close(T t3) {
        if (!$assertionsDisabled && this.trackedHash != System.identityHashCode(t3)) {
            throw new AssertionError();
        }
        try {
            boolean bl3 = this.close();
            return bl3;
        }
        finally {
            ResourceLeakDetector$DefaultResourceLeak.reachabilityFence0(t3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reachabilityFence0(Object object) {
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
            }
        }
    }

    public String toString() {
        ResourceLeakDetector$Record resourceLeakDetector$Record = headUpdater.getAndSet(this, null);
        if (resourceLeakDetector$Record == null) {
            return "";
        }
        int n4 = droppedRecordsUpdater.get(this);
        int n7 = 0;
        int n8 = ResourceLeakDetector$Record.access$300(resourceLeakDetector$Record) + 1;
        StringBuilder stringBuilder = new StringBuilder(n8 * 2048).append(StringUtil.NEWLINE);
        stringBuilder.append("Recent access records: ").append(StringUtil.NEWLINE);
        int n10 = 1;
        HashSet<String> hashSet = new HashSet<String>(n8);
        while (resourceLeakDetector$Record != ResourceLeakDetector$Record.access$100()) {
            String string = resourceLeakDetector$Record.toString();
            if (hashSet.add(string)) {
                if (ResourceLeakDetector$Record.access$400(resourceLeakDetector$Record) == ResourceLeakDetector$Record.access$100()) {
                    stringBuilder.append("Created at:").append(StringUtil.NEWLINE).append(string);
                } else {
                    stringBuilder.append('#').append(n10++).append(':').append(StringUtil.NEWLINE).append(string);
                }
            } else {
                ++n7;
            }
            resourceLeakDetector$Record = ResourceLeakDetector$Record.access$400(resourceLeakDetector$Record);
        }
        if (n7 > 0) {
            stringBuilder.append(": ").append(n7).append(" leak records were discarded because they were duplicates").append(StringUtil.NEWLINE);
        }
        if (n4 > 0) {
            stringBuilder.append(": ").append(n4).append(" leak records were discarded because the leak record count is targeted to ").append(ResourceLeakDetector.access$200()).append(". Use system property ").append("io.grpc.netty.shaded.io.netty.leakDetection.targetRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
        }
        stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
        return stringBuilder.toString();
    }

    static {
        $assertionsDisabled = !ResourceLeakDetector.class.desiredAssertionStatus();
        headUpdater = AtomicReferenceFieldUpdater.newUpdater(ResourceLeakDetector$DefaultResourceLeak.class, ResourceLeakDetector$Record.class, "head");
        droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(ResourceLeakDetector$DefaultResourceLeak.class, "droppedRecords");
    }
}

