/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil$ReleasingTask;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetector;
import io.grpc.netty.shaded.io.netty.util.ThreadDeathWatcher;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static <T> T retain(T t3) {
        if (t3 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t3).retain();
        }
        return t3;
    }

    public static <T> T retain(T t3, int n4) {
        if (t3 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t3).retain(n4);
        }
        return t3;
    }

    public static <T> T touch(T t3) {
        if (t3 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t3).touch();
        }
        return t3;
    }

    public static <T> T touch(T t3, Object object) {
        if (t3 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t3).touch(object);
        }
        return t3;
    }

    public static boolean release(Object object) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release();
        }
        return false;
    }

    public static boolean release(Object object, int n4) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release(n4);
        }
        return false;
    }

    public static void safeRelease(Object object) {
        try {
            ReferenceCountUtil.release(object);
        }
        catch (Throwable throwable) {
            logger.warn("Failed to release a message: {}", object, (Object)throwable);
        }
    }

    public static void safeRelease(Object object, int n4) {
        block2: {
            try {
                ReferenceCountUtil.release(object, n4);
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to release a message: {} (decrement: {})", object, n4, throwable);
            }
        }
    }

    @Deprecated
    public static <T> T releaseLater(T t3) {
        return ReferenceCountUtil.releaseLater(t3, 1);
    }

    @Deprecated
    public static <T> T releaseLater(T t3, int n4) {
        if (t3 instanceof ReferenceCounted) {
            ThreadDeathWatcher.watch(Thread.currentThread(), new ReferenceCountUtil$ReleasingTask((ReferenceCounted)t3, n4));
        }
        return t3;
    }

    public static int refCnt(Object object) {
        return object instanceof ReferenceCounted ? ((ReferenceCounted)object).refCnt() : -1;
    }

    private ReferenceCountUtil() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static {
        ResourceLeakDetector.addExclusions(ReferenceCountUtil.class, "touch");
    }
}

