/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.NettyRuntime;
import io.grpc.netty.shaded.io.netty.util.Recycler$1;
import io.grpc.netty.shaded.io.netty.util.Recycler$2;
import io.grpc.netty.shaded.io.netty.util.Recycler$3;
import io.grpc.netty.shaded.io.netty.util.Recycler$DefaultHandle;
import io.grpc.netty.shaded.io.netty.util.Recycler$Handle;
import io.grpc.netty.shaded.io.netty.util.Recycler$Stack;
import io.grpc.netty.shaded.io.netty.util.Recycler$WeakOrderQueue;
import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocal;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final Recycler$Handle NOOP_HANDLE = new Recycler$1();
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(Integer.MIN_VALUE);
    private static final int OWN_THREAD_ID = ID_GENERATOR.getAndIncrement();
    private static final int DEFAULT_INITIAL_MAX_CAPACITY_PER_THREAD = 4096;
    private static final int DEFAULT_MAX_CAPACITY_PER_THREAD;
    private static final int INITIAL_CAPACITY;
    private static final int MAX_SHARED_CAPACITY_FACTOR;
    private static final int MAX_DELAYED_QUEUES_PER_THREAD;
    private static final int LINK_CAPACITY;
    private static final int RATIO;
    private final int maxCapacityPerThread;
    private final int maxSharedCapacityFactor;
    private final int ratioMask;
    private final int maxDelayedQueuesPerThread;
    private final FastThreadLocal<Recycler$Stack<T>> threadLocal = new Recycler$2(this);
    private static final FastThreadLocal<Map<Recycler$Stack<?>, Recycler$WeakOrderQueue>> DELAYED_RECYCLED;

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY_PER_THREAD);
    }

    protected Recycler(int n4) {
        this(n4, MAX_SHARED_CAPACITY_FACTOR);
    }

    protected Recycler(int n4, int n7) {
        this(n4, n7, RATIO, MAX_DELAYED_QUEUES_PER_THREAD);
    }

    protected Recycler(int n4, int n7, int n8, int n10) {
        this.ratioMask = MathUtil.safeFindNextPositivePowerOfTwo(n8) - 1;
        if (n4 <= 0) {
            this.maxCapacityPerThread = 0;
            this.maxSharedCapacityFactor = 1;
            this.maxDelayedQueuesPerThread = 0;
        } else {
            this.maxCapacityPerThread = n4;
            this.maxSharedCapacityFactor = Math.max(1, n7);
            this.maxDelayedQueuesPerThread = Math.max(0, n10);
        }
    }

    public final T get() {
        if (this.maxCapacityPerThread == 0) {
            return this.newObject(NOOP_HANDLE);
        }
        Recycler$Stack<T> recycler$Stack = this.threadLocal.get();
        Recycler$DefaultHandle<T> recycler$DefaultHandle = recycler$Stack.pop();
        if (recycler$DefaultHandle == null) {
            recycler$DefaultHandle = recycler$Stack.newHandle();
            Recycler$DefaultHandle.access$502(recycler$DefaultHandle, this.newObject(recycler$DefaultHandle));
        }
        return (T)Recycler$DefaultHandle.access$500(recycler$DefaultHandle);
    }

    @Deprecated
    public final boolean recycle(T t3, Recycler$Handle<T> recycler$Handle) {
        if (recycler$Handle == NOOP_HANDLE) {
            return false;
        }
        Recycler$DefaultHandle recycler$DefaultHandle = (Recycler$DefaultHandle)recycler$Handle;
        if (Recycler$DefaultHandle.access$600((Recycler$DefaultHandle)recycler$DefaultHandle).parent != this) {
            return false;
        }
        recycler$DefaultHandle.recycle((Object)t3);
        return true;
    }

    final int threadLocalCapacity() {
        return Recycler$Stack.access$700(this.threadLocal.get()).length;
    }

    final int threadLocalSize() {
        return Recycler$Stack.access$800(this.threadLocal.get());
    }

    protected abstract T newObject(Recycler$Handle<T> var1);

    static /* synthetic */ int access$000(Recycler recycler) {
        return recycler.maxCapacityPerThread;
    }

    static /* synthetic */ int access$100(Recycler recycler) {
        return recycler.maxSharedCapacityFactor;
    }

    static /* synthetic */ int access$200(Recycler recycler) {
        return recycler.ratioMask;
    }

    static /* synthetic */ int access$300(Recycler recycler) {
        return recycler.maxDelayedQueuesPerThread;
    }

    static /* synthetic */ FastThreadLocal access$400() {
        return DELAYED_RECYCLED;
    }

    static /* synthetic */ int access$900() {
        return LINK_CAPACITY;
    }

    static /* synthetic */ AtomicInteger access$1000() {
        return ID_GENERATOR;
    }

    static /* synthetic */ int access$1500() {
        return INITIAL_CAPACITY;
    }

    static /* synthetic */ int access$1900() {
        return OWN_THREAD_ID;
    }

    static {
        int n4 = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.recycler.maxCapacityPerThread", SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.recycler.maxCapacity", 4096));
        if (n4 < 0) {
            n4 = 4096;
        }
        DEFAULT_MAX_CAPACITY_PER_THREAD = n4;
        MAX_SHARED_CAPACITY_FACTOR = Math.max(2, SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.recycler.maxSharedCapacityFactor", 2));
        MAX_DELAYED_QUEUES_PER_THREAD = Math.max(0, SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.recycler.maxDelayedQueuesPerThread", NettyRuntime.availableProcessors() * 2));
        LINK_CAPACITY = MathUtil.safeFindNextPositivePowerOfTwo(Math.max(SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.recycler.linkCapacity", 16), 16));
        RATIO = MathUtil.safeFindNextPositivePowerOfTwo(SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.recycler.ratio", 8));
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY_PER_THREAD == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: disabled");
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: disabled");
                logger.debug("-Dio.netty.recycler.linkCapacity: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: {}", (Object)DEFAULT_MAX_CAPACITY_PER_THREAD);
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: {}", (Object)MAX_SHARED_CAPACITY_FACTOR);
                logger.debug("-Dio.netty.recycler.linkCapacity: {}", (Object)LINK_CAPACITY);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
            }
        }
        INITIAL_CAPACITY = Math.min(DEFAULT_MAX_CAPACITY_PER_THREAD, 256);
        DELAYED_RECYCLED = new Recycler$3();
    }
}

