/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.Recycler;
import io.grpc.netty.shaded.io.netty.util.Recycler$DefaultHandle;
import io.grpc.netty.shaded.io.netty.util.Recycler$WeakOrderQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class Recycler$Stack<T> {
    final Recycler<T> parent;
    final WeakReference<Thread> threadRef;
    final AtomicInteger availableSharedCapacity;
    final int maxDelayedQueues;
    private final int maxCapacity;
    private final int ratioMask;
    private Recycler$DefaultHandle<?>[] elements;
    private int size;
    private int handleRecycleCount = -1;
    private Recycler$WeakOrderQueue cursor;
    private Recycler$WeakOrderQueue prev;
    private volatile Recycler$WeakOrderQueue head;

    Recycler$Stack(Recycler<T> recycler, Thread thread, int n4, int n7, int n8, int n10) {
        this.parent = recycler;
        this.threadRef = new WeakReference<Thread>(thread);
        this.maxCapacity = n4;
        this.availableSharedCapacity = new AtomicInteger(Math.max(n4 / n7, Recycler.access$900()));
        this.elements = new Recycler$DefaultHandle[Math.min(Recycler.access$1500(), n4)];
        this.ratioMask = n8;
        this.maxDelayedQueues = n10;
    }

    synchronized void setHead(Recycler$WeakOrderQueue recycler$WeakOrderQueue) {
        Recycler$WeakOrderQueue.access$1600(recycler$WeakOrderQueue, this.head);
        this.head = recycler$WeakOrderQueue;
    }

    int increaseCapacity(int n4) {
        int n7 = this.elements.length;
        int n8 = this.maxCapacity;
        while ((n7 <<= 1) < n4 && n7 < n8) {
        }
        if ((n7 = Math.min(n7, n8)) != this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, n7);
        }
        return n7;
    }

    Recycler$DefaultHandle<T> pop() {
        int n4 = this.size;
        if (n4 == 0) {
            if (!this.scavenge()) {
                return null;
            }
            n4 = this.size;
        }
        Recycler$DefaultHandle<?> recycler$DefaultHandle = this.elements[--n4];
        this.elements[n4] = null;
        if (Recycler$DefaultHandle.access$1100(recycler$DefaultHandle) != Recycler$DefaultHandle.access$1400(recycler$DefaultHandle)) {
            throw new IllegalStateException("recycled multiple times");
        }
        Recycler$DefaultHandle.access$1402(recycler$DefaultHandle, 0);
        Recycler$DefaultHandle.access$1102(recycler$DefaultHandle, 0);
        this.size = n4;
        return recycler$DefaultHandle;
    }

    boolean scavenge() {
        if (this.scavengeSome()) {
            return true;
        }
        this.prev = null;
        this.cursor = this.head;
        return false;
    }

    boolean scavengeSome() {
        Recycler$WeakOrderQueue recycler$WeakOrderQueue;
        Recycler$WeakOrderQueue recycler$WeakOrderQueue2;
        Recycler$WeakOrderQueue recycler$WeakOrderQueue3 = this.cursor;
        if (recycler$WeakOrderQueue3 == null) {
            recycler$WeakOrderQueue2 = null;
            recycler$WeakOrderQueue3 = this.head;
            if (recycler$WeakOrderQueue3 == null) {
                return false;
            }
        } else {
            recycler$WeakOrderQueue2 = this.prev;
        }
        boolean bl3 = false;
        do {
            if (recycler$WeakOrderQueue3.transfer(this)) {
                bl3 = true;
                break;
            }
            recycler$WeakOrderQueue = Recycler$WeakOrderQueue.access$1700(recycler$WeakOrderQueue3);
            if (Recycler$WeakOrderQueue.access$1800(recycler$WeakOrderQueue3).get() == null) {
                if (recycler$WeakOrderQueue3.hasFinalData()) {
                    while (recycler$WeakOrderQueue3.transfer(this)) {
                        bl3 = true;
                    }
                }
                if (recycler$WeakOrderQueue2 == null) continue;
                Recycler$WeakOrderQueue.access$1600(recycler$WeakOrderQueue2, recycler$WeakOrderQueue);
                continue;
            }
            recycler$WeakOrderQueue2 = recycler$WeakOrderQueue3;
        } while ((recycler$WeakOrderQueue3 = recycler$WeakOrderQueue) != null && !bl3);
        this.prev = recycler$WeakOrderQueue2;
        this.cursor = recycler$WeakOrderQueue3;
        return bl3;
    }

    void push(Recycler$DefaultHandle<?> recycler$DefaultHandle) {
        Thread thread = Thread.currentThread();
        if (this.threadRef.get() == thread) {
            this.pushNow(recycler$DefaultHandle);
        } else {
            this.pushLater(recycler$DefaultHandle, thread);
        }
    }

    private void pushNow(Recycler$DefaultHandle<?> recycler$DefaultHandle) {
        if ((Recycler$DefaultHandle.access$1400(recycler$DefaultHandle) | Recycler$DefaultHandle.access$1100(recycler$DefaultHandle)) != 0) {
            throw new IllegalStateException("recycled already");
        }
        Recycler$DefaultHandle.access$1402(recycler$DefaultHandle, Recycler$DefaultHandle.access$1102(recycler$DefaultHandle, Recycler.access$1900()));
        int n4 = this.size;
        if (n4 >= this.maxCapacity || this.dropHandle(recycler$DefaultHandle)) {
            return;
        }
        if (n4 == this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, Math.min(n4 << 1, this.maxCapacity));
        }
        this.elements[n4] = recycler$DefaultHandle;
        this.size = n4 + 1;
    }

    private void pushLater(Recycler$DefaultHandle<?> recycler$DefaultHandle, Thread thread) {
        Map map = (Map)Recycler.access$400().get();
        Recycler$WeakOrderQueue recycler$WeakOrderQueue = (Recycler$WeakOrderQueue)map.get(this);
        if (recycler$WeakOrderQueue == null) {
            if (map.size() >= this.maxDelayedQueues) {
                map.put(this, Recycler$WeakOrderQueue.DUMMY);
                return;
            }
            recycler$WeakOrderQueue = Recycler$WeakOrderQueue.allocate(this, thread);
            if (recycler$WeakOrderQueue == null) {
                return;
            }
            map.put(this, recycler$WeakOrderQueue);
        } else if (recycler$WeakOrderQueue == Recycler$WeakOrderQueue.DUMMY) {
            return;
        }
        recycler$WeakOrderQueue.add(recycler$DefaultHandle);
    }

    boolean dropHandle(Recycler$DefaultHandle<?> recycler$DefaultHandle) {
        if (!recycler$DefaultHandle.hasBeenRecycled) {
            if ((++this.handleRecycleCount & this.ratioMask) != 0) {
                return true;
            }
            recycler$DefaultHandle.hasBeenRecycled = true;
        }
        return false;
    }

    Recycler$DefaultHandle<T> newHandle() {
        return new Recycler$DefaultHandle(this);
    }

    static /* synthetic */ Recycler$DefaultHandle[] access$700(Recycler$Stack recycler$Stack) {
        return recycler$Stack.elements;
    }

    static /* synthetic */ int access$800(Recycler$Stack recycler$Stack) {
        return recycler$Stack.size;
    }

    static /* synthetic */ int access$802(Recycler$Stack recycler$Stack, int n4) {
        recycler$Stack.size = n4;
        return recycler$Stack.size;
    }
}

