/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.NetUtil$1;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final int SOMAXCONN;
    private static final int IPV6_WORD_COUNT = 8;
    private static final int IPV6_MAX_CHAR_COUNT = 39;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int IPV6_MAX_CHAR_BETWEEN_SEPARATOR = 4;
    private static final int IPV6_MIN_SEPARATORS = 2;
    private static final int IPV6_MAX_SEPARATORS = 8;
    private static final int IPV4_MAX_CHAR_BETWEEN_SEPARATOR = 3;
    private static final int IPV4_SEPARATORS = 3;
    private static final boolean IPV4_PREFERRED;
    private static final boolean IPV6_ADDRESSES_PREFERRED;
    private static final InternalLogger logger;

    /*
     * Exception decompiling
     */
    private static Integer sysctlGetInt(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isIpV4StackPreferred() {
        return IPV4_PREFERRED;
    }

    public static boolean isIpV6AddressesPreferred() {
        return IPV6_ADDRESSES_PREFERRED;
    }

    public static byte[] createByteArrayFromIpAddressString(String string) {
        if (NetUtil.isValidIpV4Address(string)) {
            return NetUtil.validIpV4ToBytes(string);
        }
        if (NetUtil.isValidIpV6Address(string)) {
            int n4;
            if (string.charAt(0) == '[') {
                string = string.substring(1, string.length() - 1);
            }
            if ((n4 = string.indexOf(37)) >= 0) {
                string = string.substring(0, n4);
            }
            return NetUtil.getIPv6ByName(string, true);
        }
        return null;
    }

    private static int decimalDigit(String string, int n4) {
        return string.charAt(n4) - 48;
    }

    private static byte ipv4WordToByte(String string, int n4, int n7) {
        int n8 = NetUtil.decimalDigit(string, n4);
        if (++n4 == n7) {
            return (byte)n8;
        }
        n8 = n8 * 10 + NetUtil.decimalDigit(string, n4);
        if (++n4 == n7) {
            return (byte)n8;
        }
        return (byte)(n8 * 10 + NetUtil.decimalDigit(string, n4));
    }

    static byte[] validIpV4ToBytes(String string) {
        byte[] byArray = new byte[4];
        int n4 = string.indexOf(46, 1);
        byArray[0] = NetUtil.ipv4WordToByte(string, 0, n4);
        int n7 = n4 + 1;
        n4 = string.indexOf(46, n4 + 2);
        byArray[1] = NetUtil.ipv4WordToByte(string, n7, n4);
        int n8 = n4 + 1;
        n4 = string.indexOf(46, n4 + 2);
        byArray[2] = NetUtil.ipv4WordToByte(string, n8, n4);
        byArray[3] = NetUtil.ipv4WordToByte(string, n4 + 1, string.length());
        return byArray;
    }

    public static String intToIpAddress(int n4) {
        StringBuilder stringBuilder = new StringBuilder(15);
        stringBuilder.append(n4 >> 24 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n4 >> 16 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n4 >> 8 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n4 & 0xFF);
        return stringBuilder.toString();
    }

    public static String bytesToIpAddress(byte[] byArray) {
        return NetUtil.bytesToIpAddress(byArray, 0, byArray.length);
    }

    public static String bytesToIpAddress(byte[] byArray, int n4, int n7) {
        switch (n7) {
            case 4: {
                return new StringBuilder(15).append(byArray[n4] & 0xFF).append('.').append(byArray[n4 + 1] & 0xFF).append('.').append(byArray[n4 + 2] & 0xFF).append('.').append(byArray[n4 + 3] & 0xFF).toString();
            }
            case 16: {
                return NetUtil.toAddressString(byArray, n4, false);
            }
        }
        throw new IllegalArgumentException("length: " + n7 + " (expected: 4 or 16)");
    }

    public static boolean isValidIpV6Address(String string) {
        return NetUtil.isValidIpV6Address((CharSequence)string);
    }

    public static boolean isValidIpV6Address(CharSequence charSequence) {
        int n4;
        int n7;
        int n8;
        int n10 = charSequence.length();
        if (n10 < 2) {
            return false;
        }
        char c10 = charSequence.charAt(0);
        if (c10 == '[') {
            if (charSequence.charAt(--n10) != ']') {
                return false;
            }
            n8 = 1;
            c10 = charSequence.charAt(1);
        } else {
            n8 = 0;
        }
        if (c10 == ':') {
            if (charSequence.charAt(n8 + 1) != ':') {
                return false;
            }
            n7 = 2;
            n4 = n8;
            n8 += 2;
        } else {
            n7 = 0;
            n4 = -1;
        }
        int n11 = 0;
        block5: for (int i3 = n8; i3 < n10; ++i3) {
            c10 = charSequence.charAt(i3);
            if (NetUtil.isValidHexChar(c10)) {
                if (n11 < 4) {
                    ++n11;
                    continue;
                }
                return false;
            }
            switch (c10) {
                case ':': {
                    if (n7 > 7) {
                        return false;
                    }
                    if (charSequence.charAt(i3 - 1) == ':') {
                        if (n4 >= 0) {
                            return false;
                        }
                        n4 = i3 - 1;
                    } else {
                        n11 = 0;
                    }
                    ++n7;
                    continue block5;
                }
                case '.': {
                    int n12;
                    if (n4 < 0 && n7 != 6 || n7 == 7 && n4 >= n8 || n7 > 7) {
                        return false;
                    }
                    int n13 = i3 - n11;
                    int n14 = n13 - 2;
                    if (NetUtil.isValidIPv4MappedChar(charSequence.charAt(n14))) {
                        if (!(NetUtil.isValidIPv4MappedChar(charSequence.charAt(n14 - 1)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n14 - 2)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n14 - 3)))) {
                            return false;
                        }
                        n14 -= 5;
                    }
                    while (n14 >= n8) {
                        n12 = charSequence.charAt(n14);
                        if (n12 != 48 && n12 != 58) {
                            return false;
                        }
                        --n14;
                    }
                    n12 = AsciiString.indexOf(charSequence, '%', n13 + 7);
                    if (n12 < 0) {
                        n12 = n10;
                    }
                    return NetUtil.isValidIpV4Address(charSequence, n13, n12);
                }
                case '%': {
                    n10 = i3;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (n4 < 0) {
            return n7 == 7 && n11 > 0;
        }
        return n4 + 2 == n10 || n11 > 0 && (n7 < 8 || n4 <= n8);
    }

    private static boolean isValidIpV4Word(CharSequence charSequence, int n4, int n7) {
        char c10;
        int n8 = n7 - n4;
        if (n8 < 1 || n8 > 3 || (c10 = charSequence.charAt(n4)) < '0') {
            return false;
        }
        if (n8 == 3) {
            char c11;
            char c12 = charSequence.charAt(n4 + 1);
            return c12 >= '0' && (c11 = charSequence.charAt(n4 + 2)) >= '0' && (c10 <= '1' && c12 <= '9' && c11 <= '9' || c10 == '2' && c12 <= '5' && (c11 <= '5' || c12 < '5' && c11 <= '9'));
        }
        return c10 <= '9' && (n8 == 1 || NetUtil.isValidNumericChar(charSequence.charAt(n4 + 1)));
    }

    private static boolean isValidHexChar(char c10) {
        return c10 >= '0' && c10 <= '9' || c10 >= 'A' && c10 <= 'F' || c10 >= 'a' && c10 <= 'f';
    }

    private static boolean isValidNumericChar(char c10) {
        return c10 >= '0' && c10 <= '9';
    }

    private static boolean isValidIPv4MappedChar(char c10) {
        return c10 == 'f' || c10 == 'F';
    }

    private static boolean isValidIPv4MappedSeparators(byte by2, byte by3, boolean bl3) {
        return by2 == by3 && (by2 == 0 || !bl3 && by3 == -1);
    }

    private static boolean isValidIPv4Mapped(byte[] byArray, int n4, int n7, int n8) {
        boolean bl3 = n7 + n8 >= 14;
        return n4 <= 12 && n4 >= 2 && (!bl3 || n7 < 12) && NetUtil.isValidIPv4MappedSeparators(byArray[n4 - 1], byArray[n4 - 2], bl3) && PlatformDependent.isZero(byArray, 0, n4 - 3);
    }

    public static boolean isValidIpV4Address(CharSequence charSequence) {
        return NetUtil.isValidIpV4Address(charSequence, 0, charSequence.length());
    }

    public static boolean isValidIpV4Address(String string) {
        return NetUtil.isValidIpV4Address(string, 0, string.length());
    }

    private static boolean isValidIpV4Address(CharSequence charSequence, int n4, int n7) {
        return charSequence instanceof String ? NetUtil.isValidIpV4Address((String)charSequence, n4, n7) : (charSequence instanceof AsciiString ? NetUtil.isValidIpV4Address((AsciiString)charSequence, n4, n7) : NetUtil.isValidIpV4Address0(charSequence, n4, n7));
    }

    private static boolean isValidIpV4Address(String string, int n4, int n7) {
        int n8;
        int n10 = n7 - n4;
        return n10 <= 15 && n10 >= 7 && (n8 = string.indexOf(46, n4 + 1)) > 0 && NetUtil.isValidIpV4Word(string, n4, n8) && (n8 = string.indexOf(46, n4 = n8 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n4 - 1, n8) && (n8 = string.indexOf(46, n4 = n8 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n4 - 1, n8) && NetUtil.isValidIpV4Word(string, n8 + 1, n7);
    }

    private static boolean isValidIpV4Address(AsciiString asciiString, int n4, int n7) {
        int n8;
        int n10 = n7 - n4;
        return n10 <= 15 && n10 >= 7 && (n8 = asciiString.indexOf('.', n4 + 1)) > 0 && NetUtil.isValidIpV4Word(asciiString, n4, n8) && (n8 = asciiString.indexOf('.', n4 = n8 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n4 - 1, n8) && (n8 = asciiString.indexOf('.', n4 = n8 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n4 - 1, n8) && NetUtil.isValidIpV4Word(asciiString, n8 + 1, n7);
    }

    private static boolean isValidIpV4Address0(CharSequence charSequence, int n4, int n7) {
        int n8;
        int n10 = n7 - n4;
        return n10 <= 15 && n10 >= 7 && (n8 = AsciiString.indexOf(charSequence, '.', n4 + 1)) > 0 && NetUtil.isValidIpV4Word(charSequence, n4, n8) && (n8 = AsciiString.indexOf(charSequence, '.', n4 = n8 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n4 - 1, n8) && (n8 = AsciiString.indexOf(charSequence, '.', n4 = n8 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n4 - 1, n8) && NetUtil.isValidIpV4Word(charSequence, n8 + 1, n7);
    }

    public static Inet6Address getByName(CharSequence charSequence) {
        return NetUtil.getByName(charSequence, true);
    }

    public static Inet6Address getByName(CharSequence charSequence, boolean bl3) {
        byte[] byArray = NetUtil.getIPv6ByName(charSequence, bl3);
        if (byArray == null) {
            return null;
        }
        try {
            return Inet6Address.getByAddress(null, byArray, -1);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    private static byte[] getIPv6ByName(CharSequence charSequence, boolean bl3) {
        int n4;
        char c10;
        int n7;
        byte[] byArray = new byte[16];
        int n8 = charSequence.length();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = -1;
        int n15 = 0;
        int n16 = 0;
        boolean bl4 = false;
        block4: for (n7 = 0; n7 < n8; ++n7) {
            c10 = charSequence.charAt(n7);
            switch (c10) {
                case ':': {
                    if (n7 - n14 > 4 || n16 > 0 || ++n15 > 8 || n12 + 1 >= byArray.length) {
                        return null;
                    }
                    n13 <<= 4 - (n7 - n14) << 2;
                    if (n11 > 0) {
                        n11 -= 2;
                    }
                    byArray[n12++] = (byte)((n13 & 0xF) << 4 | n13 >> 4 & 0xF);
                    byArray[n12++] = (byte)((n13 >> 8 & 0xF) << 4 | n13 >> 12 & 0xF);
                    n4 = n7 + 1;
                    if (n4 < n8 && charSequence.charAt(n4) == ':') {
                        if (n10 != 0 || ++n4 < n8 && charSequence.charAt(n4) == ':') {
                            return null;
                        }
                        bl4 = ++n15 == 2 && n13 == 0;
                        n10 = n12;
                        n11 = byArray.length - n10 - 2;
                        ++n7;
                    }
                    n13 = 0;
                    n14 = -1;
                    continue block4;
                }
                case '.': {
                    n4 = n7 - n14;
                    if (n4 > 3 || n14 < 0 || ++n16 > 3 || n15 > 0 && n12 + n11 < 12 || n7 + 1 >= n8 || n12 >= byArray.length || n16 == 1 && (!bl3 || n12 != 0 && !NetUtil.isValidIPv4Mapped(byArray, n12, n10, n11) || n4 == 3 && (!NetUtil.isValidNumericChar(charSequence.charAt(n7 - 1)) || !NetUtil.isValidNumericChar(charSequence.charAt(n7 - 2)) || !NetUtil.isValidNumericChar(charSequence.charAt(n7 - 3))) || n4 == 2 && (!NetUtil.isValidNumericChar(charSequence.charAt(n7 - 1)) || !NetUtil.isValidNumericChar(charSequence.charAt(n7 - 2))) || n4 == 1 && !NetUtil.isValidNumericChar(charSequence.charAt(n7 - 1)))) {
                        return null;
                    }
                    if ((n14 = ((n13 <<= 3 - n4 << 2) & 0xF) * 100 + (n13 >> 4 & 0xF) * 10 + (n13 >> 8 & 0xF)) < 0 || n14 > 255) {
                        return null;
                    }
                    byArray[n12++] = (byte)n14;
                    n13 = 0;
                    n14 = -1;
                    continue block4;
                }
                default: {
                    if (!NetUtil.isValidHexChar(c10) || n16 > 0 && !NetUtil.isValidNumericChar(c10)) {
                        return null;
                    }
                    if (n14 < 0) {
                        n14 = n7;
                    } else if (n7 - n14 > 4) {
                        return null;
                    }
                    n13 += StringUtil.decodeHexNibble(c10) << (n7 - n14 << 2);
                }
            }
        }
        char c11 = c10 = n10 > 0 ? (char)'\u0001' : '\u0000';
        if (n16 > 0) {
            if (n14 > 0 && n7 - n14 > 3 || n16 != 3 || n12 >= byArray.length) {
                return null;
            }
            if (n15 == 0) {
                n11 = 12;
            } else if (n15 >= 2 && (c10 == '\u0000' && n15 == 6 && charSequence.charAt(0) != ':' || c10 != '\u0000' && n15 < 8 && (charSequence.charAt(0) != ':' || n10 <= 2))) {
                n11 -= 2;
            } else {
                return null;
            }
            n13 <<= 3 - (n7 - n14) << 2;
            n14 = (n13 & 0xF) * 100 + (n13 >> 4 & 0xF) * 10 + (n13 >> 8 & 0xF);
            if (n14 < 0 || n14 > 255) {
                return null;
            }
            byArray[n12++] = (byte)n14;
        } else {
            n4 = n8 - 1;
            if (n14 > 0 && n7 - n14 > 4 || n15 < 2 || c10 == '\u0000' && (n15 + 1 != 8 || charSequence.charAt(0) == ':' || charSequence.charAt(n4) == ':') || c10 != '\u0000' && (n15 > 8 || n15 == 8 && (n10 <= 2 && charSequence.charAt(0) != ':' || n10 >= 14 && charSequence.charAt(n4) != ':')) || n12 + 1 >= byArray.length || n14 < 0 && charSequence.charAt(n4 - 1) != ':' || n10 > 2 && charSequence.charAt(0) == ':') {
                return null;
            }
            if (n14 >= 0 && n7 - n14 <= 4) {
                n13 <<= 4 - (n7 - n14) << 2;
            }
            byArray[n12++] = (byte)((n13 & 0xF) << 4 | n13 >> 4 & 0xF);
            byArray[n12++] = (byte)((n13 >> 8 & 0xF) << 4 | n13 >> 12 & 0xF);
        }
        n7 = n12 + n11;
        if (bl4 || n7 >= byArray.length) {
            if (n7 >= byArray.length) {
                ++n10;
            }
            for (n7 = n12; n7 < byArray.length; ++n7) {
                for (n14 = byArray.length - 1; n14 >= n10; --n14) {
                    byArray[n14] = byArray[n14 - 1];
                }
                byArray[n14] = 0;
                ++n10;
            }
        } else {
            for (n7 = 0; n7 < n11 && (n12 = (n14 = n7 + n10) + n11) < byArray.length; ++n7) {
                byArray[n12] = byArray[n14];
                byArray[n14] = 0;
            }
        }
        if (n16 > 0) {
            byArray[11] = -1;
            byArray[10] = -1;
        }
        return byArray;
    }

    public static String toSocketAddressString(InetSocketAddress inetSocketAddress) {
        StringBuilder stringBuilder;
        String string = String.valueOf(inetSocketAddress.getPort());
        if (inetSocketAddress.isUnresolved()) {
            String string2;
            stringBuilder = NetUtil.newSocketAddressStringBuilder(string2, string, !NetUtil.isValidIpV6Address(string2 = NetUtil.getHostname(inetSocketAddress)));
        } else {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            String string3 = NetUtil.toAddressString(inetAddress);
            stringBuilder = NetUtil.newSocketAddressStringBuilder(string3, string, inetAddress instanceof Inet4Address);
        }
        return stringBuilder.append(':').append(string).toString();
    }

    public static String toSocketAddressString(String string, int n4) {
        String string2 = String.valueOf(n4);
        return NetUtil.newSocketAddressStringBuilder(string, string2, !NetUtil.isValidIpV6Address(string)).append(':').append(string2).toString();
    }

    private static StringBuilder newSocketAddressStringBuilder(String string, String string2, boolean bl3) {
        int n4 = string.length();
        if (bl3) {
            return new StringBuilder(n4 + 1 + string2.length()).append(string);
        }
        StringBuilder stringBuilder = new StringBuilder(n4 + 3 + string2.length());
        if (n4 > 1 && string.charAt(0) == '[' && string.charAt(n4 - 1) == ']') {
            return stringBuilder.append(string);
        }
        return stringBuilder.append('[').append(string).append(']');
    }

    public static String toAddressString(InetAddress inetAddress) {
        return NetUtil.toAddressString(inetAddress, false);
    }

    public static String toAddressString(InetAddress inetAddress, boolean bl3) {
        if (inetAddress instanceof Inet4Address) {
            return inetAddress.getHostAddress();
        }
        if (!(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + inetAddress);
        }
        return NetUtil.toAddressString(inetAddress.getAddress(), 0, bl3);
    }

    private static String toAddressString(byte[] byArray, int n4, boolean bl3) {
        int n7;
        int n8;
        int[] nArray = new int[8];
        int n10 = n4 + nArray.length;
        for (n8 = n4; n8 < n10; ++n8) {
            nArray[n8] = (byArray[n8 << 1] & 0xFF) << 8 | byArray[(n8 << 1) + 1] & 0xFF;
        }
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        for (n8 = 0; n8 < nArray.length; ++n8) {
            if (nArray[n8] == 0) {
                if (n11 >= 0) continue;
                n11 = n8;
                continue;
            }
            if (n11 < 0) continue;
            n7 = n8 - n11;
            if (n7 > n13) {
                n12 = n11;
                n13 = n7;
            }
            n11 = -1;
        }
        if (n11 >= 0 && (n7 = n8 - n11) > n13) {
            n12 = n11;
            n13 = n7;
        }
        if (n13 == 1) {
            n13 = 0;
            n12 = -1;
        }
        int n14 = n12 + n13;
        StringBuilder stringBuilder = new StringBuilder(39);
        if (n14 < 0) {
            stringBuilder.append(Integer.toHexString(nArray[0]));
            for (n8 = 1; n8 < nArray.length; ++n8) {
                stringBuilder.append(':');
                stringBuilder.append(Integer.toHexString(nArray[n8]));
            }
        } else {
            boolean bl4;
            if (NetUtil.inRangeEndExclusive(0, n12, n14)) {
                stringBuilder.append("::");
                bl4 = bl3 && n14 == 5 && nArray[5] == 65535;
            } else {
                stringBuilder.append(Integer.toHexString(nArray[0]));
                bl4 = false;
            }
            for (n8 = 1; n8 < nArray.length; ++n8) {
                if (!NetUtil.inRangeEndExclusive(n8, n12, n14)) {
                    if (!NetUtil.inRangeEndExclusive(n8 - 1, n12, n14)) {
                        if (!bl4 || n8 == 6) {
                            stringBuilder.append(':');
                        } else {
                            stringBuilder.append('.');
                        }
                    }
                    if (bl4 && n8 > 5) {
                        stringBuilder.append(nArray[n8] >> 8);
                        stringBuilder.append('.');
                        stringBuilder.append(nArray[n8] & 0xFF);
                        continue;
                    }
                    stringBuilder.append(Integer.toHexString(nArray[n8]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(n8 - 1, n12, n14)) continue;
                stringBuilder.append("::");
            }
        }
        return stringBuilder.toString();
    }

    public static String getHostname(InetSocketAddress inetSocketAddress) {
        return PlatformDependent.javaVersion() >= 7 ? inetSocketAddress.getHostString() : inetSocketAddress.getHostName();
    }

    private static boolean inRangeEndExclusive(int n4, int n7, int n8) {
        return n4 >= n7 && n4 < n8;
    }

    private NetUtil() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static /* synthetic */ Integer access$100(String string) {
        return NetUtil.sysctlGetInt(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Enumeration<InetAddress> enumeration;
        Object object;
        Object object2;
        IPV4_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv4Stack", false);
        IPV6_ADDRESSES_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv6Addresses", false);
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        logger.debug("-Djava.net.preferIPv4Stack: {}", (Object)IPV4_PREFERRED);
        logger.debug("-Djava.net.preferIPv6Addresses: {}", (Object)IPV6_ADDRESSES_PREFERRED);
        byte[] byArray = new byte[]{127, 0, 0, 1};
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)InetAddress.getByAddress("localhost", byArray);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        LOCALHOST4 = inet4Address;
        Inet6Address inet6Address = null;
        try {
            inet6Address = (Inet6Address)InetAddress.getByAddress("localhost", byArray2);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        LOCALHOST6 = inet6Address;
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        try {
            object2 = NetworkInterface.getNetworkInterfaces();
            if (object2 != null) {
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    if (!SocketUtils.addressesFromNetworkInterface((NetworkInterface)object).hasMoreElements()) continue;
                    arrayList.add((NetworkInterface)object);
                }
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        object2 = null;
        object = null;
        block14: for (NetworkInterface networkInterface : arrayList) {
            enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface);
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!inetAddress.isLoopbackAddress()) continue;
                object2 = networkInterface;
                object = inetAddress;
                break block14;
            }
        }
        if (object2 == null) {
            try {
                for (NetworkInterface networkInterface : arrayList) {
                    if (!networkInterface.isLoopback() || !(enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface)).hasMoreElements()) continue;
                    object2 = networkInterface;
                    object = enumeration.nextElement();
                    break;
                }
                if (object2 == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to find the loopback interface", socketException);
            }
        }
        if (object2 != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)object2).getName(), ((NetworkInterface)object2).getDisplayName(), ((InetAddress)object).getHostAddress());
        } else if (object == null) {
            try {
                if (NetworkInterface.getByInetAddress(LOCALHOST6) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)inet6Address);
                    object = inet6Address;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object = inet4Address;
                }
            }
        }
        LOOPBACK_IF = object2;
        LOCALHOST = object;
        SOMAXCONN = AccessController.doPrivileged(new NetUtil$1());
    }
}

