/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.NetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.PrivilegedAction;

final class NetUtil$1
implements PrivilegedAction<Integer> {
    NetUtil$1() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer run() {
        int n4 = PlatformDependent.isWindows() ? 200 : 128;
        File file = new File("/proc/sys/net/core/somaxconn");
        BufferedReader bufferedReader = null;
        try {
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                n4 = Integer.parseInt(bufferedReader.readLine());
                if (NetUtil.access$000().isDebugEnabled()) {
                    NetUtil.access$000().debug("{}: {}", (Object)file, (Object)n4);
                }
            } else {
                Integer n7 = null;
                if (SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.net.somaxconn.trySysctl", false)) {
                    n7 = NetUtil.access$100("kern.ipc.somaxconn");
                    if (n7 == null) {
                        n7 = NetUtil.access$100("kern.ipc.soacceptqueue");
                        if (n7 != null) {
                            n4 = n7;
                        }
                    } else {
                        n4 = n7;
                    }
                }
                if (n7 == null) {
                    NetUtil.access$000().debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", (Object)file, (Object)n4);
                }
            }
        }
        catch (Exception exception) {
            NetUtil.access$000().debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", file, n4, exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return n4;
    }
}

