/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.HashedWheelTimer$HashedWheelBucket;
import io.grpc.netty.shaded.io.netty.util.HashedWheelTimer$HashedWheelTimeout;
import io.grpc.netty.shaded.io.netty.util.HashedWheelTimer$Worker;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetector;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetectorFactory;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakTracker;
import io.grpc.netty.shaded.io.netty.util.Timeout;
import io.grpc.netty.shaded.io.netty.util.Timer;
import io.grpc.netty.shaded.io.netty.util.TimerTask;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;

public class HashedWheelTimer
implements Timer {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HashedWheelTimer.class);
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private static final AtomicBoolean WARNED_TOO_MANY_INSTANCES = new AtomicBoolean();
    private static final int INSTANCE_COUNT_LIMIT = 64;
    private static final long MILLISECOND_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ResourceLeakDetector<HashedWheelTimer> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(HashedWheelTimer.class, 1);
    private static final AtomicIntegerFieldUpdater<HashedWheelTimer> WORKER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimer.class, "workerState");
    private final ResourceLeakTracker<HashedWheelTimer> leak;
    private final HashedWheelTimer$Worker worker = new HashedWheelTimer$Worker(this, null);
    private final Thread workerThread;
    public static final int WORKER_STATE_INIT = 0;
    public static final int WORKER_STATE_STARTED = 1;
    public static final int WORKER_STATE_SHUTDOWN = 2;
    private volatile int workerState;
    private final long tickDuration;
    private final HashedWheelTimer$HashedWheelBucket[] wheel;
    private final int mask;
    private final CountDownLatch startTimeInitialized = new CountDownLatch(1);
    private final Queue<HashedWheelTimer$HashedWheelTimeout> timeouts = PlatformDependent.newMpscQueue();
    private final Queue<HashedWheelTimer$HashedWheelTimeout> cancelledTimeouts = PlatformDependent.newMpscQueue();
    private final AtomicLong pendingTimeouts = new AtomicLong(0L);
    private final long maxPendingTimeouts;
    private volatile long startTime;

    public HashedWheelTimer() {
        this(Executors.defaultThreadFactory());
    }

    public HashedWheelTimer(long l2, TimeUnit timeUnit) {
        this(Executors.defaultThreadFactory(), l2, timeUnit);
    }

    public HashedWheelTimer(long l2, TimeUnit timeUnit, int n4) {
        this(Executors.defaultThreadFactory(), l2, timeUnit, n4);
    }

    public HashedWheelTimer(ThreadFactory threadFactory) {
        this(threadFactory, 100L, TimeUnit.MILLISECONDS);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l2, TimeUnit timeUnit) {
        this(threadFactory, l2, timeUnit, 512);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l2, TimeUnit timeUnit, int n4) {
        this(threadFactory, l2, timeUnit, n4, true);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l2, TimeUnit timeUnit, int n4, boolean bl3) {
        this(threadFactory, l2, timeUnit, n4, bl3, -1L);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l2, TimeUnit timeUnit, int n4, boolean bl3, long l10) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("tickDuration must be greater than 0: " + l2);
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + n4);
        }
        this.wheel = HashedWheelTimer.createWheel(n4);
        this.mask = this.wheel.length - 1;
        long l11 = timeUnit.toNanos(l2);
        if (l11 >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDuration in nanos < %d", l2, Long.MAX_VALUE / (long)this.wheel.length));
        }
        if (l11 < MILLISECOND_NANOS) {
            if (logger.isWarnEnabled()) {
                logger.warn("Configured tickDuration %d smaller then %d, using 1ms.", (Object)l2, (Object)MILLISECOND_NANOS);
            }
            this.tickDuration = MILLISECOND_NANOS;
        } else {
            this.tickDuration = l11;
        }
        this.workerThread = threadFactory.newThread(this.worker);
        this.leak = bl3 || !this.workerThread.isDaemon() ? leakDetector.track(this) : null;
        this.maxPendingTimeouts = l10;
        if (INSTANCE_COUNTER.incrementAndGet() > 64 && WARNED_TOO_MANY_INSTANCES.compareAndSet(false, true)) {
            HashedWheelTimer.reportTooManyInstances();
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        finally {
            if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                INSTANCE_COUNTER.decrementAndGet();
            }
        }
    }

    private static HashedWheelTimer$HashedWheelBucket[] createWheel(int n4) {
        if (n4 <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + n4);
        }
        if (n4 > 0x40000000) {
            throw new IllegalArgumentException("ticksPerWheel may not be greater than 2^30: " + n4);
        }
        n4 = HashedWheelTimer.normalizeTicksPerWheel(n4);
        HashedWheelTimer$HashedWheelBucket[] hashedWheelTimer$HashedWheelBucketArray = new HashedWheelTimer$HashedWheelBucket[n4];
        for (int i3 = 0; i3 < hashedWheelTimer$HashedWheelBucketArray.length; ++i3) {
            hashedWheelTimer$HashedWheelBucketArray[i3] = new HashedWheelTimer$HashedWheelBucket(null);
        }
        return hashedWheelTimer$HashedWheelBucketArray;
    }

    private static int normalizeTicksPerWheel(int n4) {
        int n7;
        for (n7 = 1; n7 < n4; n7 <<= 1) {
        }
        return n7;
    }

    public void start() {
        switch (WORKER_STATE_UPDATER.get(this)) {
            case 0: {
                if (!WORKER_STATE_UPDATER.compareAndSet(this, 0, 1)) break;
                this.workerThread.start();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("cannot be started once stopped");
            }
            default: {
                throw new Error("Invalid WorkerState");
            }
        }
        while (this.startTime == 0L) {
            try {
                this.startTimeInitialized.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Set<Timeout> stop() {
        boolean bl3;
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        if (!WORKER_STATE_UPDATER.compareAndSet(this, 1, 2)) {
            if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                INSTANCE_COUNTER.decrementAndGet();
                if (this.leak != null) {
                    boolean bl4 = this.leak.close(this);
                    assert (bl4);
                }
            }
            return Collections.emptySet();
        }
        try {
            bl3 = false;
            while (this.workerThread.isAlive()) {
                this.workerThread.interrupt();
                try {
                    this.workerThread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    bl3 = true;
                }
            }
            if (bl3) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            INSTANCE_COUNTER.decrementAndGet();
            if (this.leak != null) {
                bl3 = this.leak.close(this);
                assert (bl3);
            }
        }
        return this.worker.unprocessedTimeouts();
    }

    @Override
    public Timeout newTimeout(TimerTask timerTask, long l2, TimeUnit timeUnit) {
        if (timerTask == null) {
            throw new NullPointerException("task");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        long l10 = this.pendingTimeouts.incrementAndGet();
        if (this.maxPendingTimeouts > 0L && l10 > this.maxPendingTimeouts) {
            this.pendingTimeouts.decrementAndGet();
            throw new RejectedExecutionException("Number of pending timeouts (" + l10 + ") is greater than or equal to maximum allowed pending timeouts (" + this.maxPendingTimeouts + ")");
        }
        this.start();
        long l11 = System.nanoTime() + timeUnit.toNanos(l2) - this.startTime;
        if (l2 > 0L && l11 < 0L) {
            l11 = Long.MAX_VALUE;
        }
        HashedWheelTimer$HashedWheelTimeout hashedWheelTimer$HashedWheelTimeout = new HashedWheelTimer$HashedWheelTimeout(this, timerTask, l11);
        this.timeouts.add(hashedWheelTimer$HashedWheelTimeout);
        return hashedWheelTimer$HashedWheelTimeout;
    }

    public long pendingTimeouts() {
        return this.pendingTimeouts.get();
    }

    private static void reportTooManyInstances() {
        if (logger.isErrorEnabled()) {
            String string = StringUtil.simpleClassName(HashedWheelTimer.class);
            logger.error("You are creating too many " + string + " instances. " + string + " is a shared resource that must be reused across the JVM,so that only a few instances are created.");
        }
    }

    static /* synthetic */ long access$202(HashedWheelTimer hashedWheelTimer, long l2) {
        hashedWheelTimer.startTime = l2;
        return hashedWheelTimer.startTime;
    }

    static /* synthetic */ long access$200(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.startTime;
    }

    static /* synthetic */ CountDownLatch access$300(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.startTimeInitialized;
    }

    static /* synthetic */ int access$400(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.mask;
    }

    static /* synthetic */ HashedWheelTimer$HashedWheelBucket[] access$500(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.wheel;
    }

    static /* synthetic */ AtomicIntegerFieldUpdater access$600() {
        return WORKER_STATE_UPDATER;
    }

    static /* synthetic */ Queue access$700(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.timeouts;
    }

    static /* synthetic */ long access$900(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.tickDuration;
    }

    static /* synthetic */ Queue access$1000(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.cancelledTimeouts;
    }

    static /* synthetic */ AtomicLong access$1100(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.pendingTimeouts;
    }
}

