/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.DomainNameMapping;
import io.grpc.netty.shaded.io.netty.util.DomainNameMappingBuilder$1;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class DomainNameMappingBuilder$ImmutableDomainNameMapping<V>
extends DomainNameMapping<V> {
    private static final String REPR_HEADER = "ImmutableDomainNameMapping(default: ";
    private static final String REPR_MAP_OPENING = ", map: {";
    private static final String REPR_MAP_CLOSING = "})";
    private static final int REPR_CONST_PART_LENGTH = "ImmutableDomainNameMapping(default: ".length() + ", map: {".length() + "})".length();
    private final String[] domainNamePatterns;
    private final V[] values;
    private final Map<String, V> map;

    private DomainNameMappingBuilder$ImmutableDomainNameMapping(V v3, Map<String, V> map) {
        super(null, v3);
        Set<Map.Entry<String, V>> set = map.entrySet();
        int n4 = set.size();
        this.domainNamePatterns = new String[n4];
        this.values = new Object[n4];
        LinkedHashMap<String, V> linkedHashMap = new LinkedHashMap<String, V>(map.size());
        int n7 = 0;
        for (Map.Entry<String, V> entry : set) {
            String string = DomainNameMappingBuilder$ImmutableDomainNameMapping.normalizeHostname(entry.getKey());
            V v4 = entry.getValue();
            this.domainNamePatterns[n7] = string;
            this.values[n7] = v4;
            linkedHashMap.put(string, v4);
            ++n7;
        }
        this.map = Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    @Deprecated
    public DomainNameMapping<V> add(String string, V v3) {
        throw new UnsupportedOperationException("Immutable DomainNameMapping does not support modification after initial creation");
    }

    @Override
    public V map(String string) {
        if (string != null) {
            string = DomainNameMappingBuilder$ImmutableDomainNameMapping.normalizeHostname(string);
            int n4 = this.domainNamePatterns.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                if (!DomainNameMappingBuilder$ImmutableDomainNameMapping.matches(this.domainNamePatterns[i3], string)) continue;
                return this.values[i3];
            }
        }
        return (V)this.defaultValue;
    }

    @Override
    public Map<String, V> asMap() {
        return this.map;
    }

    @Override
    public String toString() {
        String string = this.defaultValue.toString();
        int n4 = this.domainNamePatterns.length;
        if (n4 == 0) {
            return REPR_HEADER + string + REPR_MAP_OPENING + REPR_MAP_CLOSING;
        }
        String string2 = this.domainNamePatterns[0];
        String string3 = this.values[0].toString();
        int n7 = string2.length() + string3.length() + 3;
        int n8 = DomainNameMappingBuilder$ImmutableDomainNameMapping.estimateBufferSize(string.length(), n4, n7);
        StringBuilder stringBuilder = new StringBuilder(n8).append(REPR_HEADER).append(string).append(REPR_MAP_OPENING);
        DomainNameMappingBuilder$ImmutableDomainNameMapping.appendMapping(stringBuilder, string2, string3);
        for (int i3 = 1; i3 < n4; ++i3) {
            stringBuilder.append(", ");
            this.appendMapping(stringBuilder, i3);
        }
        return stringBuilder.append(REPR_MAP_CLOSING).toString();
    }

    private static int estimateBufferSize(int n4, int n7, int n8) {
        return REPR_CONST_PART_LENGTH + n4 + (int)((double)(n8 * n7) * 1.1);
    }

    private StringBuilder appendMapping(StringBuilder stringBuilder, int n4) {
        return DomainNameMappingBuilder$ImmutableDomainNameMapping.appendMapping(stringBuilder, this.domainNamePatterns[n4], this.values[n4].toString());
    }

    private static StringBuilder appendMapping(StringBuilder stringBuilder, String string, String string2) {
        return stringBuilder.append(string).append('=').append(string2);
    }

    /* synthetic */ DomainNameMappingBuilder$ImmutableDomainNameMapping(Object object, Map map, DomainNameMappingBuilder$1 domainNameMappingBuilder$1) {
        this(object, map);
    }
}

