/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.Mapping;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.net.IDN;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class DomainNameMapping<V>
implements Mapping<String, V> {
    final V defaultValue;
    private final Map<String, V> map;
    private final Map<String, V> unmodifiableMap;

    @Deprecated
    public DomainNameMapping(V v3) {
        this(4, v3);
    }

    @Deprecated
    public DomainNameMapping(int n4, V v3) {
        this(new LinkedHashMap(n4), v3);
    }

    DomainNameMapping(Map<String, V> map, V v3) {
        this.defaultValue = ObjectUtil.checkNotNull(v3, "defaultValue");
        this.map = map;
        this.unmodifiableMap = map != null ? Collections.unmodifiableMap(map) : null;
    }

    @Deprecated
    public DomainNameMapping<V> add(String string, V v3) {
        this.map.put(DomainNameMapping.normalizeHostname(ObjectUtil.checkNotNull(string, "hostname")), ObjectUtil.checkNotNull(v3, "output"));
        return this;
    }

    static boolean matches(String string, String string2) {
        if (string.startsWith("*.")) {
            return string.regionMatches(2, string2, 0, string2.length()) || StringUtil.commonSuffixOfLength(string2, string, string.length() - 1);
        }
        return string.equals(string2);
    }

    static String normalizeHostname(String string) {
        if (DomainNameMapping.needsNormalization(string)) {
            string = IDN.toASCII(string, 1);
        }
        return string.toLowerCase(Locale.US);
    }

    private static boolean needsNormalization(String string) {
        int n4 = string.length();
        for (int i3 = 0; i3 < n4; ++i3) {
            char c10 = string.charAt(i3);
            if (c10 <= '\u007f') continue;
            return true;
        }
        return false;
    }

    @Override
    public V map(String string) {
        if (string != null) {
            string = DomainNameMapping.normalizeHostname(string);
            for (Map.Entry<String, V> entry : this.map.entrySet()) {
                if (!DomainNameMapping.matches(entry.getKey(), string)) continue;
                return entry.getValue();
            }
        }
        return this.defaultValue;
    }

    public Map<String, V> asMap() {
        return this.unmodifiableMap;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(default: " + this.defaultValue + ", map: " + this.map + ')';
    }
}

