/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util;

import io.grpc.netty.shaded.io.netty.util.AsciiString$1;
import io.grpc.netty.shaded.io.netty.util.AsciiString$2;
import io.grpc.netty.shaded.io.netty.util.AsciiString$AsciiCaseInsensitiveCharEqualityComparator;
import io.grpc.netty.shaded.io.netty.util.AsciiString$CharEqualityComparator;
import io.grpc.netty.shaded.io.netty.util.AsciiString$DefaultCharEqualityComparator;
import io.grpc.netty.shaded.io.netty.util.AsciiString$GeneralCaseInsensitiveCharEqualityComparator;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.HashingStrategy;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private static final char MAX_CHAR_VALUE = '\u00ff';
    public static final int INDEX_NOT_FOUND = -1;
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new AsciiString$1();
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new AsciiString$2();

    public AsciiString(byte[] byArray) {
        this(byArray, true);
    }

    public AsciiString(byte[] byArray, boolean bl3) {
        this(byArray, 0, byArray.length, bl3);
    }

    public AsciiString(byte[] byArray, int n4, int n7, boolean bl3) {
        if (bl3) {
            this.value = Arrays.copyOfRange(byArray, n4, n4 + n7);
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(n4, n7, byArray.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= start + length(" + n7 + ") <= value.length(" + byArray.length + ')');
            }
            this.value = byArray;
            this.offset = n4;
        }
        this.length = n7;
    }

    public AsciiString(ByteBuffer byteBuffer) {
        this(byteBuffer, true);
    }

    public AsciiString(ByteBuffer byteBuffer, boolean bl3) {
        this(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), bl3);
    }

    public AsciiString(ByteBuffer byteBuffer, int n4, int n7, boolean bl3) {
        if (MathUtil.isOutOfBounds(n4, n7, byteBuffer.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= start + length(" + n7 + ") <= value.capacity(" + byteBuffer.capacity() + ')');
        }
        if (byteBuffer.hasArray()) {
            if (bl3) {
                int n8 = byteBuffer.arrayOffset() + n4;
                this.value = Arrays.copyOfRange(byteBuffer.array(), n8, n8 + n7);
                this.offset = 0;
            } else {
                this.value = byteBuffer.array();
                this.offset = n4;
            }
        } else {
            this.value = PlatformDependent.allocateUninitializedArray(n7);
            int n10 = byteBuffer.position();
            byteBuffer.get(this.value, 0, n7);
            byteBuffer.position(n10);
            this.offset = 0;
        }
        this.length = n7;
    }

    public AsciiString(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public AsciiString(char[] cArray, int n4, int n7) {
        if (MathUtil.isOutOfBounds(n4, n7, cArray.length)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= start + length(" + n7 + ") <= value.length(" + cArray.length + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(n7);
        int n8 = 0;
        int n10 = n4;
        while (n8 < n7) {
            this.value[n8] = AsciiString.c2b(cArray[n10]);
            ++n8;
            ++n10;
        }
        this.offset = 0;
        this.length = n7;
    }

    public AsciiString(char[] cArray, Charset charset) {
        this(cArray, charset, 0, cArray.length);
    }

    public AsciiString(char[] cArray, Charset charset, int n4, int n7) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n4, n7);
        CharsetEncoder charsetEncoder = CharsetUtil.encoder(charset);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(charsetEncoder.maxBytesPerChar() * (float)n7));
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        int n8 = byteBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(byteBuffer.array(), n8, n8 + byteBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public AsciiString(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public AsciiString(CharSequence charSequence, int n4, int n7) {
        if (MathUtil.isOutOfBounds(n4, n7, charSequence.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= start + length(" + n7 + ") <= value.length(" + charSequence.length() + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(n7);
        int n8 = 0;
        int n10 = n4;
        while (n8 < n7) {
            this.value[n8] = AsciiString.c2b(charSequence.charAt(n10));
            ++n8;
            ++n10;
        }
        this.offset = 0;
        this.length = n7;
    }

    public AsciiString(CharSequence charSequence, Charset charset) {
        this(charSequence, charset, 0, charSequence.length());
    }

    public AsciiString(CharSequence charSequence, Charset charset, int n4, int n7) {
        CharBuffer charBuffer = CharBuffer.wrap(charSequence, n4, n4 + n7);
        CharsetEncoder charsetEncoder = CharsetUtil.encoder(charset);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(charsetEncoder.maxBytesPerChar() * (float)n7));
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        int n8 = byteBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(byteBuffer.array(), n8, n8 + byteBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public int forEachByte(ByteProcessor byteProcessor) {
        return this.forEachByte0(0, this.length(), byteProcessor);
    }

    public int forEachByte(int n4, int n7, ByteProcessor byteProcessor) {
        if (MathUtil.isOutOfBounds(n4, n7, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + n4 + ") <= start + length(" + n7 + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0(n4, n7, byteProcessor);
    }

    private int forEachByte0(int n4, int n7, ByteProcessor byteProcessor) {
        int n8 = this.offset + n4 + n7;
        for (int i3 = this.offset + n4; i3 < n8; ++i3) {
            if (byteProcessor.process(this.value[i3])) continue;
            return i3 - this.offset;
        }
        return -1;
    }

    public int forEachByteDesc(ByteProcessor byteProcessor) {
        return this.forEachByteDesc0(0, this.length(), byteProcessor);
    }

    public int forEachByteDesc(int n4, int n7, ByteProcessor byteProcessor) {
        if (MathUtil.isOutOfBounds(n4, n7, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + n4 + ") <= start + length(" + n7 + ") <= length(" + this.length() + ')');
        }
        return this.forEachByteDesc0(n4, n7, byteProcessor);
    }

    private int forEachByteDesc0(int n4, int n7, ByteProcessor byteProcessor) {
        int n8 = this.offset + n4;
        for (int i3 = this.offset + n4 + n7 - 1; i3 >= n8; --i3) {
            if (byteProcessor.process(this.value[i3])) continue;
            return i3 - this.offset;
        }
        return -1;
    }

    public byte byteAt(int n4) {
        if (n4 < 0 || n4 >= this.length) {
            throw new IndexOutOfBoundsException("index: " + n4 + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, n4 + this.offset);
        }
        return this.value[n4 + this.offset];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public void arrayChanged() {
        this.string = null;
        this.hash = 0;
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return this.offset;
    }

    public boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public byte[] toByteArray(int n4, int n7) {
        return Arrays.copyOfRange(this.value, n4 + this.offset, n7 + this.offset);
    }

    public void copy(int n4, byte[] byArray, int n7, int n8) {
        if (MathUtil.isOutOfBounds(n4, n8, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n4 + ") <= srcIdx + length(" + n8 + ") <= srcLen(" + this.length() + ')');
        }
        System.arraycopy(this.value, n4 + this.offset, ObjectUtil.checkNotNull(byArray, "dst"), n7, n8);
    }

    @Override
    public char charAt(int n4) {
        return AsciiString.b2c(this.byteAt(n4));
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(charSequence) >= 0;
    }

    @Override
    public int compareTo(CharSequence charSequence) {
        if (this == charSequence) {
            return 0;
        }
        int n4 = this.length();
        int n7 = charSequence.length();
        int n8 = Math.min(n4, n7);
        int n10 = 0;
        int n11 = this.arrayOffset();
        while (n10 < n8) {
            int n12 = AsciiString.b2c(this.value[n11]) - charSequence.charAt(n10);
            if (n12 != 0) {
                return n12;
            }
            ++n10;
            ++n11;
        }
        return n4 - n7;
    }

    public AsciiString concat(CharSequence charSequence) {
        int n4 = this.length();
        int n7 = charSequence.length();
        if (n7 == 0) {
            return this;
        }
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            if (this.isEmpty()) {
                return asciiString;
            }
            byte[] byArray = PlatformDependent.allocateUninitializedArray(n4 + n7);
            System.arraycopy(this.value, this.arrayOffset(), byArray, 0, n4);
            System.arraycopy(asciiString.value, asciiString.arrayOffset(), byArray, n4, n7);
            return new AsciiString(byArray, false);
        }
        if (this.isEmpty()) {
            return new AsciiString(charSequence);
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n4 + n7);
        System.arraycopy(this.value, this.arrayOffset(), byArray, 0, n4);
        int n8 = n4;
        int n10 = 0;
        while (n8 < byArray.length) {
            byArray[n8] = AsciiString.c2b(charSequence.charAt(n10));
            ++n8;
            ++n10;
        }
        return new AsciiString(byArray, false);
    }

    public boolean endsWith(CharSequence charSequence) {
        int n4 = charSequence.length();
        return this.regionMatches(this.length() - n4, charSequence, 0, n4);
    }

    public boolean contentEqualsIgnoreCase(CharSequence charSequence) {
        if (this == charSequence) {
            return true;
        }
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            int n4 = this.arrayOffset();
            int n7 = asciiString.arrayOffset();
            while (n4 < this.length()) {
                if (!AsciiString.equalsIgnoreCase(this.value[n4], asciiString.value[n7])) {
                    return false;
                }
                ++n4;
                ++n7;
            }
            return true;
        }
        int n8 = this.arrayOffset();
        int n10 = 0;
        while (n8 < this.length()) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[n8]), charSequence.charAt(n10))) {
                return false;
            }
            ++n8;
            ++n10;
        }
        return true;
    }

    public char[] toCharArray() {
        return this.toCharArray(0, this.length());
    }

    public char[] toCharArray(int n4, int n7) {
        int n8 = n7 - n4;
        if (n8 == 0) {
            return EmptyArrays.EMPTY_CHARS;
        }
        if (MathUtil.isOutOfBounds(n4, n8, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= srcIdx + length(" + n8 + ") <= srcLen(" + this.length() + ')');
        }
        char[] cArray = new char[n8];
        int n10 = 0;
        int n11 = n4 + this.arrayOffset();
        while (n10 < n8) {
            cArray[n10] = AsciiString.b2c(this.value[n11]);
            ++n10;
            ++n11;
        }
        return cArray;
    }

    public void copy(int n4, char[] cArray, int n7, int n8) {
        if (cArray == null) {
            throw new NullPointerException("dst");
        }
        if (MathUtil.isOutOfBounds(n4, n8, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n4 + ") <= srcIdx + length(" + n8 + ") <= srcLen(" + this.length() + ')');
        }
        int n10 = n7 + n8;
        int n11 = n7;
        int n12 = n4 + this.arrayOffset();
        while (n11 < n10) {
            cArray[n11] = AsciiString.b2c(this.value[n12]);
            ++n11;
            ++n12;
        }
    }

    public AsciiString subSequence(int n4) {
        return this.subSequence(n4, this.length());
    }

    @Override
    public AsciiString subSequence(int n4, int n7) {
        return this.subSequence(n4, n7, true);
    }

    public AsciiString subSequence(int n4, int n7, boolean bl3) {
        if (MathUtil.isOutOfBounds(n4, n7 - n4, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= end (" + n7 + ") <= length(" + this.length() + ')');
        }
        if (n4 == 0 && n7 == this.length()) {
            return this;
        }
        if (n7 == n4) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, n4 + this.offset, n7 - n4, bl3);
    }

    public int indexOf(CharSequence charSequence) {
        return this.indexOf(charSequence, 0);
    }

    public int indexOf(CharSequence charSequence, int n4) {
        int n7 = charSequence.length();
        if (n4 < 0) {
            n4 = 0;
        }
        if (n7 <= 0) {
            return n4 < this.length ? n4 : this.length;
        }
        if (n7 > this.length - n4) {
            return -1;
        }
        char c10 = charSequence.charAt(0);
        if (c10 > '\u00ff') {
            return -1;
        }
        byte by2 = AsciiString.c2b0(c10);
        int n8 = this.offset + this.length - n7;
        for (int i3 = n4 + this.offset; i3 <= n8; ++i3) {
            if (this.value[i3] != by2) continue;
            int n10 = i3;
            int n11 = 0;
            while (++n11 < n7 && AsciiString.b2c(this.value[++n10]) == charSequence.charAt(n11)) {
            }
            if (n11 != n7) continue;
            return i3 - this.offset;
        }
        return -1;
    }

    public int indexOf(char c10, int n4) {
        if (c10 > '\u00ff') {
            return -1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        byte by2 = AsciiString.c2b0(c10);
        int n7 = this.offset + this.length;
        for (int i3 = n4 + this.offset; i3 < n7; ++i3) {
            if (this.value[i3] != by2) continue;
            return i3 - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence charSequence) {
        return this.lastIndexOf(charSequence, this.length);
    }

    public int lastIndexOf(CharSequence charSequence, int n4) {
        int n7 = charSequence.length();
        if ((n4 = Math.min(n4, this.length - n7)) < 0) {
            return -1;
        }
        if (n7 == 0) {
            return n4;
        }
        char c10 = charSequence.charAt(0);
        if (c10 > '\u00ff') {
            return -1;
        }
        byte by2 = AsciiString.c2b0(c10);
        for (int i3 = this.offset + n4; i3 >= 0; --i3) {
            if (this.value[i3] != by2) continue;
            int n8 = i3;
            int n10 = 0;
            while (++n10 < n7 && AsciiString.b2c(this.value[++n8]) == charSequence.charAt(n10)) {
            }
            if (n10 != n7) continue;
            return i3 - this.offset;
        }
        return -1;
    }

    public boolean regionMatches(int n4, CharSequence charSequence, int n7, int n8) {
        if (charSequence == null) {
            throw new NullPointerException("string");
        }
        if (n7 < 0 || charSequence.length() - n7 < n8) {
            return false;
        }
        int n10 = this.length();
        if (n4 < 0 || n10 - n4 < n8) {
            return false;
        }
        if (n8 <= 0) {
            return true;
        }
        int n11 = n7 + n8;
        int n12 = n7;
        int n13 = n4 + this.arrayOffset();
        while (n12 < n11) {
            if (AsciiString.b2c(this.value[n13]) != charSequence.charAt(n12)) {
                return false;
            }
            ++n12;
            ++n13;
        }
        return true;
    }

    public boolean regionMatches(boolean bl3, int n4, CharSequence charSequence, int n7, int n8) {
        if (!bl3) {
            return this.regionMatches(n4, charSequence, n7, n8);
        }
        if (charSequence == null) {
            throw new NullPointerException("string");
        }
        int n10 = this.length();
        if (n4 < 0 || n8 > n10 - n4) {
            return false;
        }
        if (n7 < 0 || n8 > charSequence.length() - n7) {
            return false;
        }
        int n11 = (n4 += this.arrayOffset()) + n8;
        while (n4 < n11) {
            if (AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[n4++]), charSequence.charAt(n7++))) continue;
            return false;
        }
        return true;
    }

    public AsciiString replace(char c10, char c11) {
        if (c10 > '\u00ff') {
            return this;
        }
        byte by2 = AsciiString.c2b0(c10);
        byte by3 = AsciiString.c2b(c11);
        int n4 = this.offset + this.length;
        for (int i3 = this.offset; i3 < n4; ++i3) {
            if (this.value[i3] != by2) continue;
            byte[] byArray = PlatformDependent.allocateUninitializedArray(this.length());
            System.arraycopy(this.value, this.offset, byArray, 0, i3 - this.offset);
            byArray[i3 - this.offset] = by3;
            ++i3;
            while (i3 < n4) {
                byte by4 = this.value[i3];
                byArray[i3 - this.offset] = by4 != by2 ? by4 : by3;
                ++i3;
            }
            return new AsciiString(byArray, false);
        }
        return this;
    }

    public boolean startsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, 0);
    }

    public boolean startsWith(CharSequence charSequence, int n4) {
        return this.regionMatches(n4, charSequence, 0, charSequence.length());
    }

    public AsciiString toLowerCase() {
        int n4;
        boolean bl3 = true;
        int n7 = this.length() + this.arrayOffset();
        for (n4 = this.arrayOffset(); n4 < n7; ++n4) {
            byte by2 = this.value[n4];
            if (by2 < 65 || by2 > 90) continue;
            bl3 = false;
            break;
        }
        if (bl3) {
            return this;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(this.length());
        n4 = 0;
        int n8 = this.arrayOffset();
        while (n4 < byArray.length) {
            byArray[n4] = AsciiString.toLowerCase(this.value[n8]);
            ++n4;
            ++n8;
        }
        return new AsciiString(byArray, false);
    }

    public AsciiString toUpperCase() {
        int n4;
        boolean bl3 = true;
        int n7 = this.length() + this.arrayOffset();
        for (n4 = this.arrayOffset(); n4 < n7; ++n4) {
            byte by2 = this.value[n4];
            if (by2 < 97 || by2 > 122) continue;
            bl3 = false;
            break;
        }
        if (bl3) {
            return this;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(this.length());
        n4 = 0;
        int n8 = this.arrayOffset();
        while (n4 < byArray.length) {
            byArray[n4] = AsciiString.toUpperCase(this.value[n8]);
            ++n4;
            ++n8;
        }
        return new AsciiString(byArray, false);
    }

    public static CharSequence trim(CharSequence charSequence) {
        int n4;
        int n7;
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).trim();
        }
        if (charSequence instanceof String) {
            return ((String)charSequence).trim();
        }
        int n8 = n7 = charSequence.length() - 1;
        for (n4 = 0; n4 <= n8 && charSequence.charAt(n4) <= ' '; ++n4) {
        }
        while (n8 >= n4 && charSequence.charAt(n8) <= ' ') {
            --n8;
        }
        if (n4 == 0 && n8 == n7) {
            return charSequence;
        }
        return charSequence.subSequence(n4, n8);
    }

    public AsciiString trim() {
        int n4;
        int n7;
        int n8 = n7 = this.arrayOffset() + this.length() - 1;
        for (n4 = this.arrayOffset(); n4 <= n8 && this.value[n4] <= 32; ++n4) {
        }
        while (n8 >= n4 && this.value[n8] <= 32) {
            --n8;
        }
        if (n4 == 0 && n8 == n7) {
            return this;
        }
        return new AsciiString(this.value, n4, n8 - n4 + 1, false);
    }

    public boolean contentEquals(CharSequence charSequence) {
        if (this == charSequence) {
            return true;
        }
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        if (charSequence instanceof AsciiString) {
            return this.equals(charSequence);
        }
        int n4 = this.arrayOffset();
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            if (AsciiString.b2c(this.value[n4]) != charSequence.charAt(i3)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public AsciiString[] split(String string, int n4) {
        return AsciiString.toAsciiStringArray(Pattern.compile(string).split(this, n4));
    }

    public AsciiString[] split(char c10) {
        int n4;
        ArrayList<AsciiString> arrayList = InternalThreadLocalMap.get().arrayList();
        int n7 = 0;
        int n8 = this.length();
        for (n4 = n7; n4 < n8; ++n4) {
            if (this.charAt(n4) != c10) continue;
            if (n7 == n4) {
                arrayList.add(EMPTY_STRING);
            } else {
                arrayList.add(new AsciiString(this.value, n7 + this.arrayOffset(), n4 - n7, false));
            }
            n7 = n4 + 1;
        }
        if (n7 == 0) {
            arrayList.add(this);
        } else if (n7 != n8) {
            arrayList.add(new AsciiString(this.value, n7 + this.arrayOffset(), n8 - n7, false));
        } else {
            for (n4 = arrayList.size() - 1; n4 >= 0 && ((AsciiString)arrayList.get(n4)).isEmpty(); --n4) {
                arrayList.remove(n4);
            }
        }
        return arrayList.toArray(new AsciiString[0]);
    }

    public int hashCode() {
        int n4 = this.hash;
        if (n4 == 0) {
            this.hash = n4 = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return n4;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != AsciiString.class) {
            return false;
        }
        if (this == object) {
            return true;
        }
        AsciiString asciiString = (AsciiString)object;
        return this.length() == asciiString.length() && this.hashCode() == asciiString.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), asciiString.array(), asciiString.arrayOffset(), this.length());
    }

    @Override
    public String toString() {
        String string = this.string;
        if (string == null) {
            this.string = string = this.toString(0);
        }
        return string;
    }

    public String toString(int n4) {
        return this.toString(n4, this.length());
    }

    public String toString(int n4, int n7) {
        int n8 = n7 - n4;
        if (n8 == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(n4, n8, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= srcIdx + length(" + n8 + ") <= srcLen(" + this.length() + ')');
        }
        String string = new String(this.value, 0, n4 + this.offset, n8);
        return string;
    }

    public boolean parseBoolean() {
        return this.length >= 1 && this.value[this.offset] != 0;
    }

    public char parseChar() {
        return this.parseChar(0);
    }

    public char parseChar(int n4) {
        if (n4 + 1 >= this.length()) {
            throw new IndexOutOfBoundsException("2 bytes required to convert to character. index " + n4 + " would go out of bounds.");
        }
        int n7 = n4 + this.offset;
        return (char)(AsciiString.b2c(this.value[n7]) << 8 | AsciiString.b2c(this.value[n7 + 1]));
    }

    public short parseShort() {
        return this.parseShort(0, this.length(), 10);
    }

    public short parseShort(int n4) {
        return this.parseShort(0, this.length(), n4);
    }

    public short parseShort(int n4, int n7) {
        return this.parseShort(n4, n7, 10);
    }

    public short parseShort(int n4, int n7, int n8) {
        int n10 = this.parseInt(n4, n7, n8);
        short s11 = (short)n10;
        if (s11 != n10) {
            throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
        }
        return s11;
    }

    public int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    public int parseInt(int n4) {
        return this.parseInt(0, this.length(), n4);
    }

    public int parseInt(int n4, int n7) {
        return this.parseInt(n4, n7, 10);
    }

    public int parseInt(int n4, int n7, int n8) {
        boolean bl3;
        if (n8 < 2 || n8 > 36) {
            throw new NumberFormatException();
        }
        if (n4 == n7) {
            throw new NumberFormatException();
        }
        int n10 = n4;
        boolean bl4 = bl3 = this.byteAt(n10) == 45;
        if (bl3 && ++n10 == n7) {
            throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
        }
        return this.parseInt(n10, n7, n8, bl3);
    }

    private int parseInt(int n4, int n7, int n8, boolean bl3) {
        int n10 = Integer.MIN_VALUE / n8;
        int n11 = 0;
        int n12 = n4;
        while (n12 < n7) {
            int n13;
            if ((n13 = Character.digit((char)(this.value[n12++ + this.offset] & 0xFF), n8)) == -1) {
                throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
            }
            if (n10 > n11) {
                throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
            }
            int n14 = n11 * n8 - n13;
            if (n14 > n11) {
                throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
            }
            n11 = n14;
        }
        if (!bl3 && (n11 = -n11) < 0) {
            throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
        }
        return n11;
    }

    public long parseLong() {
        return this.parseLong(0, this.length(), 10);
    }

    public long parseLong(int n4) {
        return this.parseLong(0, this.length(), n4);
    }

    public long parseLong(int n4, int n7) {
        return this.parseLong(n4, n7, 10);
    }

    public long parseLong(int n4, int n7, int n8) {
        boolean bl3;
        if (n8 < 2 || n8 > 36) {
            throw new NumberFormatException();
        }
        if (n4 == n7) {
            throw new NumberFormatException();
        }
        int n10 = n4;
        boolean bl4 = bl3 = this.byteAt(n10) == 45;
        if (bl3 && ++n10 == n7) {
            throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
        }
        return this.parseLong(n10, n7, n8, bl3);
    }

    private long parseLong(int n4, int n7, int n8, boolean bl3) {
        long l2 = Long.MIN_VALUE / (long)n8;
        long l10 = 0L;
        int n10 = n4;
        while (n10 < n7) {
            int n11;
            if ((n11 = Character.digit((char)(this.value[n10++ + this.offset] & 0xFF), n8)) == -1) {
                throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
            }
            if (l2 > l10) {
                throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
            }
            long l11 = l10 * (long)n8 - (long)n11;
            if (l11 > l10) {
                throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
            }
            l10 = l11;
        }
        if (!bl3 && (l10 = -l10) < 0L) {
            throw new NumberFormatException(this.subSequence(n4, n7, false).toString());
        }
        return l10;
    }

    public float parseFloat() {
        return this.parseFloat(0, this.length());
    }

    public float parseFloat(int n4, int n7) {
        return Float.parseFloat(this.toString(n4, n7));
    }

    public double parseDouble() {
        return this.parseDouble(0, this.length());
    }

    public double parseDouble(int n4, int n7) {
        return Double.parseDouble(this.toString(n4, n7));
    }

    public static AsciiString of(CharSequence charSequence) {
        return charSequence instanceof AsciiString ? (AsciiString)charSequence : new AsciiString(charSequence);
    }

    public static AsciiString cached(String string) {
        AsciiString asciiString = new AsciiString(string);
        asciiString.string = string;
        return asciiString;
    }

    public static int hashCode(CharSequence charSequence) {
        if (charSequence == null) {
            return 0;
        }
        if (charSequence instanceof AsciiString) {
            return charSequence.hashCode();
        }
        return PlatformDependent.hashCodeAscii(charSequence);
    }

    public static boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return AsciiString.contains(charSequence, charSequence2, AsciiString$DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean containsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return AsciiString.contains(charSequence, charSequence2, AsciiString$AsciiCaseInsensitiveCharEqualityComparator.INSTANCE);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).contentEqualsIgnoreCase(charSequence2);
        }
        if (charSequence2 instanceof AsciiString) {
            return ((AsciiString)charSequence2).contentEqualsIgnoreCase(charSequence);
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            if (AsciiString.equalsIgnoreCase(charSequence.charAt(i3), charSequence2.charAt(i3))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> collection, CharSequence charSequence) {
        for (CharSequence charSequence2 : collection) {
            if (!AsciiString.contentEqualsIgnoreCase(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> collection, Collection<CharSequence> collection2) {
        for (CharSequence charSequence : collection2) {
            if (AsciiString.containsContentEqualsIgnoreCase(collection, charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).contentEquals(charSequence2);
        }
        if (charSequence2 instanceof AsciiString) {
            return ((AsciiString)charSequence2).contentEquals(charSequence);
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            if (charSequence.charAt(i3) == charSequence2.charAt(i3)) continue;
            return false;
        }
        return true;
    }

    private static AsciiString[] toAsciiStringArray(String[] stringArray) {
        AsciiString[] asciiStringArray = new AsciiString[stringArray.length];
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            asciiStringArray[i3] = new AsciiString(stringArray[i3]);
        }
        return asciiStringArray;
    }

    private static boolean contains(CharSequence charSequence, CharSequence charSequence2, AsciiString$CharEqualityComparator asciiString$CharEqualityComparator) {
        if (charSequence == null || charSequence2 == null || charSequence.length() < charSequence2.length()) {
            return false;
        }
        if (charSequence2.length() == 0) {
            return true;
        }
        int n4 = 0;
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            if (asciiString$CharEqualityComparator.equals(charSequence2.charAt(n4), charSequence.charAt(i3))) {
                if (++n4 != charSequence2.length()) continue;
                return true;
            }
            if (charSequence.length() - i3 < charSequence2.length()) {
                return false;
            }
            n4 = 0;
        }
        return false;
    }

    private static boolean regionMatchesCharSequences(CharSequence charSequence, int n4, CharSequence charSequence2, int n7, int n8, AsciiString$CharEqualityComparator asciiString$CharEqualityComparator) {
        if (n4 < 0 || n8 > charSequence.length() - n4) {
            return false;
        }
        if (n7 < 0 || n8 > charSequence2.length() - n7) {
            return false;
        }
        int n10 = n4;
        int n11 = n10 + n8;
        int n12 = n7;
        while (n10 < n11) {
            char c10;
            char c11;
            if (asciiString$CharEqualityComparator.equals(c11 = charSequence.charAt(n10++), c10 = charSequence2.charAt(n12++))) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence charSequence, boolean bl3, int n4, CharSequence charSequence2, int n7, int n8) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence instanceof String && charSequence2 instanceof String) {
            return ((String)charSequence).regionMatches(bl3, n4, (String)charSequence2, n7, n8);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).regionMatches(bl3, n4, charSequence2, n7, n8);
        }
        return AsciiString.regionMatchesCharSequences(charSequence, n4, charSequence2, n7, n8, bl3 ? AsciiString$GeneralCaseInsensitiveCharEqualityComparator.INSTANCE : AsciiString$DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean regionMatchesAscii(CharSequence charSequence, boolean bl3, int n4, CharSequence charSequence2, int n7, int n8) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (!bl3 && charSequence instanceof String && charSequence2 instanceof String) {
            return ((String)charSequence).regionMatches(false, n4, (String)charSequence2, n7, n8);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).regionMatches(bl3, n4, charSequence2, n7, n8);
        }
        return AsciiString.regionMatchesCharSequences(charSequence, n4, charSequence2, n7, n8, bl3 ? AsciiString$AsciiCaseInsensitiveCharEqualityComparator.INSTANCE : AsciiString$DefaultCharEqualityComparator.INSTANCE);
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n4) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n7 = charSequence2.length();
        int n8 = charSequence.length() - n7 + 1;
        if (n4 > n8) {
            return -1;
        }
        if (n7 == 0) {
            return n4;
        }
        for (int i3 = n4; i3 < n8; ++i3) {
            if (!AsciiString.regionMatches(charSequence, true, i3, charSequence2, 0, n7)) continue;
            return i3;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseAscii(CharSequence charSequence, CharSequence charSequence2, int n4) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n7 = charSequence2.length();
        int n8 = charSequence.length() - n7 + 1;
        if (n4 > n8) {
            return -1;
        }
        if (n7 == 0) {
            return n4;
        }
        for (int i3 = n4; i3 < n8; ++i3) {
            if (!AsciiString.regionMatchesAscii(charSequence, true, i3, charSequence2, 0, n7)) continue;
            return i3;
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, char c10, int n4) {
        int n7;
        if (charSequence instanceof String) {
            return ((String)charSequence).indexOf(c10, n4);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).indexOf(c10, n4);
        }
        if (charSequence == null) {
            return -1;
        }
        int n8 = charSequence.length();
        int n10 = n7 = n4 < 0 ? 0 : n4;
        while (n7 < n8) {
            if (charSequence.charAt(n7) == c10) {
                return n7;
            }
            ++n7;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte by2, byte by3) {
        return by2 == by3 || AsciiString.toLowerCase(by2) == AsciiString.toLowerCase(by3);
    }

    private static boolean equalsIgnoreCase(char c10, char c11) {
        return c10 == c11 || AsciiString.toLowerCase(c10) == AsciiString.toLowerCase(c11);
    }

    private static byte toLowerCase(byte by2) {
        return AsciiString.isUpperCase(by2) ? (byte)(by2 + 32) : by2;
    }

    public static char toLowerCase(char c10) {
        return AsciiString.isUpperCase(c10) ? (char)(c10 + 32) : c10;
    }

    private static byte toUpperCase(byte by2) {
        return AsciiString.isLowerCase(by2) ? (byte)(by2 - 32) : by2;
    }

    private static boolean isLowerCase(byte by2) {
        return by2 >= 97 && by2 <= 122;
    }

    public static boolean isUpperCase(byte by2) {
        return by2 >= 65 && by2 <= 90;
    }

    public static boolean isUpperCase(char c10) {
        return c10 >= 'A' && c10 <= 'Z';
    }

    public static byte c2b(char c10) {
        return (byte)(c10 > '\u00ff' ? 63 : (int)c10);
    }

    private static byte c2b0(char c10) {
        return (byte)c10;
    }

    public static char b2c(byte by2) {
        return (char)(by2 & 0xFF);
    }

    static /* synthetic */ boolean access$000(char c10, char c11) {
        return AsciiString.equalsIgnoreCase(c10, c11);
    }
}

