/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.resolver;

import io.grpc.netty.shaded.io.netty.resolver.InetNameResolver;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class DefaultNameResolver
extends InetNameResolver {
    public DefaultNameResolver(EventExecutor eventExecutor) {
        super(eventExecutor);
    }

    @Override
    protected void doResolve(String string, Promise<InetAddress> promise) {
        try {
            promise.setSuccess(SocketUtils.addressByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            promise.setFailure(unknownHostException);
        }
    }

    @Override
    protected void doResolveAll(String string, Promise<List<InetAddress>> promise) {
        try {
            promise.setSuccess(Arrays.asList(SocketUtils.allAddressesByName(string)));
        }
        catch (UnknownHostException unknownHostException) {
            promise.setFailure(unknownHostException);
        }
    }
}

