/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.resolver;

import io.grpc.netty.shaded.io.netty.resolver.CompositeNameResolver$1;
import io.grpc.netty.shaded.io.netty.resolver.CompositeNameResolver$2;
import io.grpc.netty.shaded.io.netty.resolver.NameResolver;
import io.grpc.netty.shaded.io.netty.resolver.SimpleNameResolver;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.List;

public final class CompositeNameResolver<T>
extends SimpleNameResolver<T> {
    private final NameResolver<T>[] resolvers;

    public CompositeNameResolver(EventExecutor eventExecutor, NameResolver<T> ... nameResolverArray) {
        super(eventExecutor);
        ObjectUtil.checkNotNull(nameResolverArray, "resolvers");
        for (int i3 = 0; i3 < nameResolverArray.length; ++i3) {
            if (nameResolverArray[i3] != null) continue;
            throw new NullPointerException("resolvers[" + i3 + ']');
        }
        if (nameResolverArray.length < 2) {
            throw new IllegalArgumentException("resolvers: " + Arrays.asList(nameResolverArray) + " (expected: at least 2 resolvers)");
        }
        this.resolvers = (NameResolver[])nameResolverArray.clone();
    }

    @Override
    protected void doResolve(String string, Promise<T> promise) {
        this.doResolveRec(string, promise, 0, null);
    }

    private void doResolveRec(String string, Promise<T> promise, int n4, Throwable throwable) {
        if (n4 >= this.resolvers.length) {
            promise.setFailure(throwable);
        } else {
            NameResolver<T> nameResolver = this.resolvers[n4];
            nameResolver.resolve(string).addListener(new CompositeNameResolver$1(this, promise, string, n4));
        }
    }

    @Override
    protected void doResolveAll(String string, Promise<List<T>> promise) {
        this.doResolveAllRec(string, promise, 0, null);
    }

    private void doResolveAllRec(String string, Promise<List<T>> promise, int n4, Throwable throwable) {
        if (n4 >= this.resolvers.length) {
            promise.setFailure(throwable);
        } else {
            NameResolver<T> nameResolver = this.resolvers[n4];
            nameResolver.resolveAll(string).addListener(new CompositeNameResolver$2(this, promise, string, n4));
        }
    }

    static /* synthetic */ void access$000(CompositeNameResolver compositeNameResolver, String string, Promise promise, int n4, Throwable throwable) {
        compositeNameResolver.doResolveRec(string, promise, n4, throwable);
    }

    static /* synthetic */ void access$100(CompositeNameResolver compositeNameResolver, String string, Promise promise, int n4, Throwable throwable) {
        compositeNameResolver.doResolveAllRec(string, promise, n4, throwable);
    }
}

