/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.internal.tcnative;

import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import java.io.File;

public final class Library {
    private static final String[] NAMES = new String[]{"netty_tcnative", "libnetty_tcnative"};
    private static final String PROVIDED = "provided";
    private static Library _instance = null;

    private Library() {
        boolean bl3 = false;
        String string = System.getProperty("java.library.path");
        String[] stringArray = string.split(File.pathSeparator);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i3 = 0; i3 < NAMES.length; ++i3) {
            try {
                Library.loadLibrary(NAMES[i3]);
                bl3 = true;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (VirtualMachineError virtualMachineError) {
                throw virtualMachineError;
            }
            catch (Throwable throwable) {
                String string2 = System.mapLibraryName(NAMES[i3]);
                for (int i8 = 0; i8 < stringArray.length; ++i8) {
                    File file = new File(stringArray[i8], string2);
                    if (!file.exists()) continue;
                    throw new RuntimeException(throwable);
                }
                if (i3 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(throwable.getMessage());
            }
            if (bl3) break;
        }
        if (!bl3) {
            throw new UnsatisfiedLinkError(stringBuilder.toString());
        }
    }

    private Library(String string) {
        if (!PROVIDED.equals(string)) {
            Library.loadLibrary(string);
        }
    }

    private static void loadLibrary(String string) {
        System.loadLibrary(Library.calculatePackagePrefix().replace('.', '_') + string);
    }

    private static String calculatePackagePrefix() {
        String string;
        String string2 = Library.class.getName();
        if (!string2.endsWith(string = "io!netty!internal!tcnative!Library".replace('!', '.'))) {
            throw new UnsatisfiedLinkError(String.format("Could not find prefix added to %s to get %s. When shading, only adding a package prefix is supported", string, string2));
        }
        return string2.substring(0, string2.length() - string.length());
    }

    private static native boolean initialize0();

    private static native boolean aprHasThreads();

    private static native int aprMajorVersion();

    private static native String aprVersionString();

    public static boolean initialize() {
        return Library.initialize(PROVIDED, null);
    }

    public static boolean initialize(String string, String string2) {
        if (_instance == null) {
            Library library = _instance = string == null ? new Library() : new Library(string);
            if (Library.aprMajorVersion() < 1) {
                throw new UnsatisfiedLinkError("Unsupported APR Version (" + Library.aprVersionString() + ")");
            }
            if (!Library.aprHasThreads()) {
                throw new UnsatisfiedLinkError("Missing APR_HAS_THREADS");
            }
        }
        return Library.initialize0() && SSL.initialize(string2) == 0;
    }
}

