/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.traffic;

import io.grpc.netty.shaded.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.grpc.netty.shaded.io.netty.handler.traffic.TrafficCounter$TrafficMonitoringTask;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TrafficCounter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TrafficCounter.class);
    private final AtomicLong currentWrittenBytes = new AtomicLong();
    private final AtomicLong currentReadBytes = new AtomicLong();
    private long writingTime;
    private long readingTime;
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    private long lastCumulativeTime;
    private long lastWriteThroughput;
    private long lastReadThroughput;
    final AtomicLong lastTime = new AtomicLong();
    private volatile long lastWrittenBytes;
    private volatile long lastReadBytes;
    private volatile long lastWritingTime;
    private volatile long lastReadingTime;
    private final AtomicLong realWrittenBytes = new AtomicLong();
    private long realWriteThroughput;
    final AtomicLong checkInterval = new AtomicLong(1000L);
    final String name;
    final AbstractTrafficShapingHandler trafficShapingHandler;
    final ScheduledExecutorService executor;
    Runnable monitor;
    volatile ScheduledFuture<?> scheduledFuture;
    volatile boolean monitorActive;

    public static long milliSecondFromNano() {
        return System.nanoTime() / 1000000L;
    }

    public synchronized void start() {
        if (this.monitorActive) {
            return;
        }
        this.lastTime.set(TrafficCounter.milliSecondFromNano());
        long l2 = this.checkInterval.get();
        if (l2 > 0L && this.executor != null) {
            this.monitorActive = true;
            this.monitor = new TrafficCounter$TrafficMonitoringTask(this, null);
            this.scheduledFuture = this.executor.scheduleAtFixedRate(this.monitor, 0L, l2, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (!this.monitorActive) {
            return;
        }
        this.monitorActive = false;
        this.resetAccounting(TrafficCounter.milliSecondFromNano());
        if (this.trafficShapingHandler != null) {
            this.trafficShapingHandler.doAccounting(this);
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    synchronized void resetAccounting(long l2) {
        long l10 = l2 - this.lastTime.getAndSet(l2);
        if (l10 == 0L) {
            return;
        }
        if (logger.isDebugEnabled() && l10 > this.checkInterval() << 1) {
            logger.debug("Acct schedule not ok: " + l10 + " > 2*" + this.checkInterval() + " from " + this.name);
        }
        this.lastReadBytes = this.currentReadBytes.getAndSet(0L);
        this.lastWrittenBytes = this.currentWrittenBytes.getAndSet(0L);
        this.lastReadThroughput = this.lastReadBytes * 1000L / l10;
        this.lastWriteThroughput = this.lastWrittenBytes * 1000L / l10;
        this.realWriteThroughput = this.realWrittenBytes.getAndSet(0L) * 1000L / l10;
        this.lastWritingTime = Math.max(this.lastWritingTime, this.writingTime);
        this.lastReadingTime = Math.max(this.lastReadingTime, this.readingTime);
    }

    public TrafficCounter(ScheduledExecutorService scheduledExecutorService, String string, long l2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.trafficShapingHandler = null;
        this.executor = scheduledExecutorService;
        this.name = string;
        this.init(l2);
    }

    public TrafficCounter(AbstractTrafficShapingHandler abstractTrafficShapingHandler, ScheduledExecutorService scheduledExecutorService, String string, long l2) {
        if (abstractTrafficShapingHandler == null) {
            throw new IllegalArgumentException("trafficShapingHandler");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.trafficShapingHandler = abstractTrafficShapingHandler;
        this.executor = scheduledExecutorService;
        this.name = string;
        this.init(l2);
    }

    private void init(long l2) {
        this.lastCumulativeTime = System.currentTimeMillis();
        this.readingTime = this.writingTime = TrafficCounter.milliSecondFromNano();
        this.lastWritingTime = this.writingTime;
        this.lastReadingTime = this.writingTime;
        this.configure(l2);
    }

    public void configure(long l2) {
        long l10 = l2 / 10L * 10L;
        if (this.checkInterval.getAndSet(l10) != l10) {
            if (l10 <= 0L) {
                this.stop();
                this.lastTime.set(TrafficCounter.milliSecondFromNano());
            } else {
                this.stop();
                this.start();
            }
        }
    }

    void bytesRecvFlowControl(long l2) {
        this.currentReadBytes.addAndGet(l2);
        this.cumulativeReadBytes.addAndGet(l2);
    }

    void bytesWriteFlowControl(long l2) {
        this.currentWrittenBytes.addAndGet(l2);
        this.cumulativeWrittenBytes.addAndGet(l2);
    }

    void bytesRealWriteFlowControl(long l2) {
        this.realWrittenBytes.addAndGet(l2);
    }

    public long checkInterval() {
        return this.checkInterval.get();
    }

    public long lastReadThroughput() {
        return this.lastReadThroughput;
    }

    public long lastWriteThroughput() {
        return this.lastWriteThroughput;
    }

    public long lastReadBytes() {
        return this.lastReadBytes;
    }

    public long lastWrittenBytes() {
        return this.lastWrittenBytes;
    }

    public long currentReadBytes() {
        return this.currentReadBytes.get();
    }

    public long currentWrittenBytes() {
        return this.currentWrittenBytes.get();
    }

    public long lastTime() {
        return this.lastTime.get();
    }

    public long cumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    public long cumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public long lastCumulativeTime() {
        return this.lastCumulativeTime;
    }

    public AtomicLong getRealWrittenBytes() {
        return this.realWrittenBytes;
    }

    public long getRealWriteThroughput() {
        return this.realWriteThroughput;
    }

    public void resetCumulativeTime() {
        this.lastCumulativeTime = System.currentTimeMillis();
        this.cumulativeReadBytes.set(0L);
        this.cumulativeWrittenBytes.set(0L);
    }

    public String name() {
        return this.name;
    }

    @Deprecated
    public long readTimeToWait(long l2, long l10, long l11) {
        return this.readTimeToWait(l2, l10, l11, TrafficCounter.milliSecondFromNano());
    }

    public long readTimeToWait(long l2, long l10, long l11, long l12) {
        this.bytesRecvFlowControl(l2);
        if (l2 == 0L || l10 == 0L) {
            return 0L;
        }
        long l13 = this.lastTime.get();
        long l14 = this.currentReadBytes.get();
        long l15 = this.readingTime;
        long l16 = this.lastReadBytes;
        long l17 = l12 - l13;
        long l18 = Math.max(this.lastReadingTime - l13, 0L);
        if (l17 > 10L) {
            long l19 = l14 * 1000L / l10 - l17 + l18;
            if (l19 > 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Time: " + l19 + ':' + l14 + ':' + l17 + ':' + l18);
                }
                if (l19 > l11 && l12 + l19 - l15 > l11) {
                    l19 = l11;
                }
                this.readingTime = Math.max(l15, l12 + l19);
                return l19;
            }
            this.readingTime = Math.max(l15, l12);
            return 0L;
        }
        long l20 = l14 + l16;
        long l21 = l17 + this.checkInterval.get();
        long l22 = l20 * 1000L / l10 - l21 + l18;
        if (l22 > 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Time: " + l22 + ':' + l20 + ':' + l21 + ':' + l18);
            }
            if (l22 > l11 && l12 + l22 - l15 > l11) {
                l22 = l11;
            }
            this.readingTime = Math.max(l15, l12 + l22);
            return l22;
        }
        this.readingTime = Math.max(l15, l12);
        return 0L;
    }

    @Deprecated
    public long writeTimeToWait(long l2, long l10, long l11) {
        return this.writeTimeToWait(l2, l10, l11, TrafficCounter.milliSecondFromNano());
    }

    public long writeTimeToWait(long l2, long l10, long l11, long l12) {
        this.bytesWriteFlowControl(l2);
        if (l2 == 0L || l10 == 0L) {
            return 0L;
        }
        long l13 = this.lastTime.get();
        long l14 = this.currentWrittenBytes.get();
        long l15 = this.lastWrittenBytes;
        long l16 = this.writingTime;
        long l17 = Math.max(this.lastWritingTime - l13, 0L);
        long l18 = l12 - l13;
        if (l18 > 10L) {
            long l19 = l14 * 1000L / l10 - l18 + l17;
            if (l19 > 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Time: " + l19 + ':' + l14 + ':' + l18 + ':' + l17);
                }
                if (l19 > l11 && l12 + l19 - l16 > l11) {
                    l19 = l11;
                }
                this.writingTime = Math.max(l16, l12 + l19);
                return l19;
            }
            this.writingTime = Math.max(l16, l12);
            return 0L;
        }
        long l20 = l14 + l15;
        long l21 = l18 + this.checkInterval.get();
        long l22 = l20 * 1000L / l10 - l21 + l17;
        if (l22 > 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Time: " + l22 + ':' + l20 + ':' + l21 + ':' + l17);
            }
            if (l22 > l11 && l12 + l22 - l16 > l11) {
                l22 = l11;
            }
            this.writingTime = Math.max(l16, l12 + l22);
            return l22;
        }
        this.writingTime = Math.max(l16, l12);
        return 0L;
    }

    public String toString() {
        return new StringBuilder(165).append("Monitor ").append(this.name).append(" Current Speed Read: ").append(this.lastReadThroughput >> 10).append(" KB/s, ").append("Asked Write: ").append(this.lastWriteThroughput >> 10).append(" KB/s, ").append("Real Write: ").append(this.realWriteThroughput >> 10).append(" KB/s, ").append("Current Read: ").append(this.currentReadBytes.get() >> 10).append(" KB, ").append("Current asked Write: ").append(this.currentWrittenBytes.get() >> 10).append(" KB, ").append("Current real Write: ").append(this.realWrittenBytes.get() >> 10).append(" KB").toString();
    }
}

