/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.traffic;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.grpc.netty.shaded.io.netty.handler.traffic.GlobalTrafficShapingHandler$1;
import io.grpc.netty.shaded.io.netty.handler.traffic.GlobalTrafficShapingHandler$PerChannel;
import io.grpc.netty.shaded.io.netty.handler.traffic.GlobalTrafficShapingHandler$ToSend;
import io.grpc.netty.shaded.io.netty.handler.traffic.TrafficCounter;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler$Sharable
public class GlobalTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ConcurrentMap<Integer, GlobalTrafficShapingHandler$PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    long maxGlobalWriteSize = 0x19000000L;

    void createGlobalTrafficCounter(ScheduledExecutorService scheduledExecutorService) {
        if (scheduledExecutorService == null) {
            throw new NullPointerException("executor");
        }
        TrafficCounter trafficCounter = new TrafficCounter(this, scheduledExecutorService, "GlobalTC", this.checkInterval);
        this.setTrafficCounter(trafficCounter);
        trafficCounter.start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 2;
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l10, long l11, long l12) {
        super(l2, l10, l11, l12);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l10, long l11) {
        super(l2, l10, l11);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l10) {
        super(l2, l10);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2) {
        super(l2);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(EventExecutor eventExecutor) {
        this.createGlobalTrafficCounter(eventExecutor);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long l2) {
        this.maxGlobalWriteSize = l2;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private GlobalTrafficShapingHandler$PerChannel getOrSetPerChannel(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Integer n4 = channel.hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
        if (globalTrafficShapingHandler$PerChannel == null) {
            globalTrafficShapingHandler$PerChannel = new GlobalTrafficShapingHandler$PerChannel(null);
            globalTrafficShapingHandler$PerChannel.messagesQueue = new ArrayDeque();
            globalTrafficShapingHandler$PerChannel.queueSize = 0L;
            globalTrafficShapingHandler$PerChannel.lastWriteTimestamp = globalTrafficShapingHandler$PerChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put(n4, globalTrafficShapingHandler$PerChannel);
        }
        return globalTrafficShapingHandler$PerChannel;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.getOrSetPerChannel(channelHandlerContext);
        super.handlerAdded(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Integer n4 = channel.hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.remove(n4);
        if (globalTrafficShapingHandler$PerChannel != null) {
            GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel2 = globalTrafficShapingHandler$PerChannel;
            synchronized (globalTrafficShapingHandler$PerChannel2) {
                if (channel.isActive()) {
                    for (GlobalTrafficShapingHandler$ToSend globalTrafficShapingHandler$ToSend : globalTrafficShapingHandler$PerChannel.messagesQueue) {
                        long l2 = this.calculateSize(globalTrafficShapingHandler$ToSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(l2);
                        globalTrafficShapingHandler$PerChannel.queueSize -= l2;
                        this.queuesSize.addAndGet(-l2);
                        channelHandlerContext.write(globalTrafficShapingHandler$ToSend.toSend, globalTrafficShapingHandler$ToSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-globalTrafficShapingHandler$PerChannel.queueSize);
                    for (GlobalTrafficShapingHandler$ToSend globalTrafficShapingHandler$ToSend : globalTrafficShapingHandler$PerChannel.messagesQueue) {
                        if (!(globalTrafficShapingHandler$ToSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)globalTrafficShapingHandler$ToSend.toSend).release();
                    }
                }
                globalTrafficShapingHandler$PerChannel.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    long checkWaitReadTime(ChannelHandlerContext channelHandlerContext, long l2, long l10) {
        Integer n4 = channelHandlerContext.channel().hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
        if (globalTrafficShapingHandler$PerChannel != null && l2 > this.maxTime && l10 + l2 - globalTrafficShapingHandler$PerChannel.lastReadTimestamp > this.maxTime) {
            l2 = this.maxTime;
        }
        return l2;
    }

    @Override
    void informReadOperation(ChannelHandlerContext channelHandlerContext, long l2) {
        Integer n4 = channelHandlerContext.channel().hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
        if (globalTrafficShapingHandler$PerChannel != null) {
            globalTrafficShapingHandler$PerChannel.lastReadTimestamp = l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l2, long l10, long l11, ChannelPromise channelPromise) {
        GlobalTrafficShapingHandler$ToSend globalTrafficShapingHandler$ToSend;
        Channel channel = channelHandlerContext.channel();
        Integer n4 = channel.hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
        if (globalTrafficShapingHandler$PerChannel == null) {
            globalTrafficShapingHandler$PerChannel = this.getOrSetPerChannel(channelHandlerContext);
        }
        long l12 = l10;
        boolean bl3 = false;
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel2 = globalTrafficShapingHandler$PerChannel;
        synchronized (globalTrafficShapingHandler$PerChannel2) {
            if (l10 == 0L && globalTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l2);
                channelHandlerContext.write(object, channelPromise);
                globalTrafficShapingHandler$PerChannel.lastWriteTimestamp = l11;
                return;
            }
            if (l12 > this.maxTime && l11 + l12 - globalTrafficShapingHandler$PerChannel.lastWriteTimestamp > this.maxTime) {
                l12 = this.maxTime;
            }
            globalTrafficShapingHandler$ToSend = new GlobalTrafficShapingHandler$ToSend(l12 + l11, object, l2, channelPromise, null);
            globalTrafficShapingHandler$PerChannel.messagesQueue.addLast(globalTrafficShapingHandler$ToSend);
            globalTrafficShapingHandler$PerChannel.queueSize += l2;
            this.queuesSize.addAndGet(l2);
            this.checkWriteSuspend(channelHandlerContext, l12, globalTrafficShapingHandler$PerChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                bl3 = true;
            }
        }
        if (bl3) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
        long l13 = globalTrafficShapingHandler$ToSend.relativeTimeAction;
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel3 = globalTrafficShapingHandler$PerChannel;
        channelHandlerContext.executor().schedule(new GlobalTrafficShapingHandler$1(this, channelHandlerContext, globalTrafficShapingHandler$PerChannel3, l13), l12, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext channelHandlerContext, GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel, long l2) {
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel2 = globalTrafficShapingHandler$PerChannel;
        synchronized (globalTrafficShapingHandler$PerChannel2) {
            GlobalTrafficShapingHandler$ToSend globalTrafficShapingHandler$ToSend = globalTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            while (globalTrafficShapingHandler$ToSend != null) {
                long l10;
                if (globalTrafficShapingHandler$ToSend.relativeTimeAction <= l2) {
                    l10 = globalTrafficShapingHandler$ToSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(l10);
                    globalTrafficShapingHandler$PerChannel.queueSize -= l10;
                } else {
                    globalTrafficShapingHandler$PerChannel.messagesQueue.addFirst(globalTrafficShapingHandler$ToSend);
                    break;
                }
                this.queuesSize.addAndGet(-l10);
                channelHandlerContext.write(globalTrafficShapingHandler$ToSend.toSend, globalTrafficShapingHandler$ToSend.promise);
                globalTrafficShapingHandler$PerChannel.lastWriteTimestamp = l2;
                globalTrafficShapingHandler$ToSend = globalTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            }
            if (globalTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    static /* synthetic */ void access$200(GlobalTrafficShapingHandler globalTrafficShapingHandler, ChannelHandlerContext channelHandlerContext, GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel, long l2) {
        globalTrafficShapingHandler.sendAllValid(channelHandlerContext, globalTrafficShapingHandler$PerChannel, l2);
    }
}

