/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.traffic;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.grpc.netty.shaded.io.netty.handler.traffic.AbstractTrafficShapingHandler$ReopenReadTimerTask;
import io.grpc.netty.shaded.io.netty.handler.traffic.GlobalChannelTrafficCounter;
import io.grpc.netty.shaded.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$1;
import io.grpc.netty.shaded.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$2;
import io.grpc.netty.shaded.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$PerChannel;
import io.grpc.netty.shaded.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$ToSend;
import io.grpc.netty.shaded.io.netty.handler.traffic.TrafficCounter;
import io.grpc.netty.shaded.io.netty.util.Attribute;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler$Sharable
public class GlobalChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(GlobalChannelTrafficShapingHandler.class);
    final ConcurrentMap<Integer, GlobalChannelTrafficShapingHandler$PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    volatile long maxGlobalWriteSize = 0x19000000L;
    private volatile long writeChannelLimit;
    private volatile long readChannelLimit;
    private static final float DEFAULT_DEVIATION = 0.1f;
    private static final float MAX_DEVIATION = 0.4f;
    private static final float DEFAULT_SLOWDOWN = 0.4f;
    private static final float DEFAULT_ACCELERATION = -0.1f;
    private volatile float maxDeviation;
    private volatile float accelerationFactor;
    private volatile float slowDownFactor;
    private volatile boolean readDeviationActive;
    private volatile boolean writeDeviationActive;

    void createGlobalTrafficCounter(ScheduledExecutorService scheduledExecutorService) {
        this.setMaxDeviation(0.1f, 0.4f, -0.1f);
        if (scheduledExecutorService == null) {
            throw new IllegalArgumentException("Executor must not be null");
        }
        GlobalChannelTrafficCounter globalChannelTrafficCounter = new GlobalChannelTrafficCounter(this, scheduledExecutorService, "GlobalChannelTC", this.checkInterval);
        this.setTrafficCounter(globalChannelTrafficCounter);
        ((TrafficCounter)globalChannelTrafficCounter).start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 3;
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l10, long l11, long l12, long l13, long l14) {
        super(l2, l10, l13, l14);
        this.createGlobalTrafficCounter(scheduledExecutorService);
        this.writeChannelLimit = l11;
        this.readChannelLimit = l12;
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l10, long l11, long l12, long l13) {
        super(l2, l10, l13);
        this.writeChannelLimit = l11;
        this.readChannelLimit = l12;
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l10, long l11, long l12) {
        super(l2, l10);
        this.writeChannelLimit = l11;
        this.readChannelLimit = l12;
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2) {
        super(l2);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService) {
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public float maxDeviation() {
        return this.maxDeviation;
    }

    public float accelerationFactor() {
        return this.accelerationFactor;
    }

    public float slowDownFactor() {
        return this.slowDownFactor;
    }

    public void setMaxDeviation(float f8, float f9, float f10) {
        if (f8 > 0.4f) {
            throw new IllegalArgumentException("maxDeviation must be <= 0.4");
        }
        if (f9 < 0.0f) {
            throw new IllegalArgumentException("slowDownFactor must be >= 0");
        }
        if (f10 > 0.0f) {
            throw new IllegalArgumentException("accelerationFactor must be <= 0");
        }
        this.maxDeviation = f8;
        this.accelerationFactor = 1.0f + f10;
        this.slowDownFactor = 1.0f + f9;
    }

    private void computeDeviationCumulativeBytes() {
        long l2 = 0L;
        long l10 = 0L;
        long l11 = Long.MAX_VALUE;
        long l12 = Long.MAX_VALUE;
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            long l13 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeWrittenBytes();
            if (l2 < l13) {
                l2 = l13;
            }
            if (l11 > l13) {
                l11 = l13;
            }
            if (l10 < (l13 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeReadBytes())) {
                l10 = l13;
            }
            if (l12 <= l13) continue;
            l12 = l13;
        }
        boolean bl3 = this.channelQueues.size() > 1;
        this.readDeviationActive = bl3 && l12 < l10 / 2L;
        this.writeDeviationActive = bl3 && l11 < l2 / 2L;
        this.cumulativeWrittenBytes.set(l2);
        this.cumulativeReadBytes.set(l10);
    }

    @Override
    protected void doAccounting(TrafficCounter trafficCounter) {
        this.computeDeviationCumulativeBytes();
        super.doAccounting(trafficCounter);
    }

    private long computeBalancedWait(float f8, float f9, long l2) {
        if (f9 == 0.0f) {
            return l2;
        }
        float f10 = f8 / f9;
        if (f10 > this.maxDeviation) {
            if (f10 < 1.0f - this.maxDeviation) {
                return l2;
            }
            f10 = this.slowDownFactor;
            if (l2 < 10L) {
                l2 = 10L;
            }
        } else {
            f10 = this.accelerationFactor;
        }
        return (long)((float)l2 * f10);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxGlobalWriteSize must be positive");
        }
        this.maxGlobalWriteSize = l2;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public void configureChannel(long l2, long l10) {
        this.writeChannelLimit = l2;
        this.readChannelLimit = l10;
        long l11 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l11);
        }
    }

    public long getWriteChannelLimit() {
        return this.writeChannelLimit;
    }

    public void setWriteChannelLimit(long l2) {
        this.writeChannelLimit = l2;
        long l10 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l10);
        }
    }

    public long getReadChannelLimit() {
        return this.readChannelLimit;
    }

    public void setReadChannelLimit(long l2) {
        this.readChannelLimit = l2;
        long l10 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l10);
        }
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private GlobalChannelTrafficShapingHandler$PerChannel getOrSetPerChannel(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Integer n4 = channel.hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
        if (globalChannelTrafficShapingHandler$PerChannel == null) {
            globalChannelTrafficShapingHandler$PerChannel = new GlobalChannelTrafficShapingHandler$PerChannel();
            globalChannelTrafficShapingHandler$PerChannel.messagesQueue = new ArrayDeque();
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter = new TrafficCounter(this, null, "ChannelTC" + channelHandlerContext.channel().hashCode(), this.checkInterval);
            globalChannelTrafficShapingHandler$PerChannel.queueSize = 0L;
            globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp = globalChannelTrafficShapingHandler$PerChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put(n4, globalChannelTrafficShapingHandler$PerChannel);
        }
        return globalChannelTrafficShapingHandler$PerChannel;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.getOrSetPerChannel(channelHandlerContext);
        this.trafficCounter.resetCumulativeTime();
        super.handlerAdded(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.trafficCounter.resetCumulativeTime();
        Channel channel = channelHandlerContext.channel();
        Integer n4 = channel.hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.remove(n4);
        if (globalChannelTrafficShapingHandler$PerChannel != null) {
            GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel2 = globalChannelTrafficShapingHandler$PerChannel;
            synchronized (globalChannelTrafficShapingHandler$PerChannel2) {
                if (channel.isActive()) {
                    for (GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend : globalChannelTrafficShapingHandler$PerChannel.messagesQueue) {
                        long l2 = this.calculateSize(globalChannelTrafficShapingHandler$ToSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(l2);
                        globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.bytesRealWriteFlowControl(l2);
                        globalChannelTrafficShapingHandler$PerChannel.queueSize -= l2;
                        this.queuesSize.addAndGet(-l2);
                        channelHandlerContext.write(globalChannelTrafficShapingHandler$ToSend.toSend, globalChannelTrafficShapingHandler$ToSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-globalChannelTrafficShapingHandler$PerChannel.queueSize);
                    for (GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend : globalChannelTrafficShapingHandler$PerChannel.messagesQueue) {
                        if (!(globalChannelTrafficShapingHandler$ToSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)globalChannelTrafficShapingHandler$ToSend.toSend).release();
                    }
                }
                globalChannelTrafficShapingHandler$PerChannel.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        long l2 = this.calculateSize(object);
        long l10 = TrafficCounter.milliSecondFromNano();
        if (l2 > 0L) {
            long l11 = this.trafficCounter.readTimeToWait(l2, this.getReadLimit(), this.maxTime, l10);
            Integer n4 = channelHandlerContext.channel().hashCode();
            GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
            long l12 = 0L;
            if (globalChannelTrafficShapingHandler$PerChannel != null) {
                l12 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.readTimeToWait(l2, this.readChannelLimit, this.maxTime, l10);
                if (this.readDeviationActive) {
                    long l13 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeReadBytes();
                    long l14 = this.cumulativeReadBytes.get();
                    if (l13 <= 0L) {
                        l13 = 0L;
                    }
                    if (l14 < l13) {
                        l14 = l13;
                    }
                    l12 = this.computeBalancedWait(l13, l14, l12);
                }
            }
            if (l12 < l11) {
                l12 = l11;
            }
            if ((l12 = this.checkWaitReadTime(channelHandlerContext, l12, l10)) >= 10L) {
                Channel channel = channelHandlerContext.channel();
                ChannelConfig channelConfig = channel.config();
                if (logger.isDebugEnabled()) {
                    logger.debug("Read Suspend: " + l12 + ':' + channelConfig.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                if (channelConfig.isAutoRead() && GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext)) {
                    channelConfig.setAutoRead(false);
                    channel.attr(READ_SUSPENDED).set(true);
                    Attribute<Runnable> attribute = channel.attr(REOPEN_TASK);
                    Runnable runnable = (Runnable)attribute.get();
                    if (runnable == null) {
                        runnable = new AbstractTrafficShapingHandler$ReopenReadTimerTask(channelHandlerContext);
                        attribute.set(runnable);
                    }
                    channelHandlerContext.executor().schedule(runnable, l12, TimeUnit.MILLISECONDS);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Suspend final status => " + channelConfig.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext) + " will reopened at: " + l12);
                    }
                }
            }
        }
        this.informReadOperation(channelHandlerContext, l10);
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    protected long checkWaitReadTime(ChannelHandlerContext channelHandlerContext, long l2, long l10) {
        Integer n4 = channelHandlerContext.channel().hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
        if (globalChannelTrafficShapingHandler$PerChannel != null && l2 > this.maxTime && l10 + l2 - globalChannelTrafficShapingHandler$PerChannel.lastReadTimestamp > this.maxTime) {
            l2 = this.maxTime;
        }
        return l2;
    }

    @Override
    protected void informReadOperation(ChannelHandlerContext channelHandlerContext, long l2) {
        Integer n4 = channelHandlerContext.channel().hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
        if (globalChannelTrafficShapingHandler$PerChannel != null) {
            globalChannelTrafficShapingHandler$PerChannel.lastReadTimestamp = l2;
        }
    }

    protected long maximumCumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    protected long maximumCumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public Collection<TrafficCounter> channelTrafficCounters() {
        return new GlobalChannelTrafficShapingHandler$1(this);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        long l2 = this.calculateSize(object);
        long l10 = TrafficCounter.milliSecondFromNano();
        if (l2 > 0L) {
            long l11 = this.trafficCounter.writeTimeToWait(l2, this.getWriteLimit(), this.maxTime, l10);
            Integer n4 = channelHandlerContext.channel().hashCode();
            GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
            long l12 = 0L;
            if (globalChannelTrafficShapingHandler$PerChannel != null) {
                l12 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.writeTimeToWait(l2, this.writeChannelLimit, this.maxTime, l10);
                if (this.writeDeviationActive) {
                    long l13 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeWrittenBytes();
                    long l14 = this.cumulativeWrittenBytes.get();
                    if (l13 <= 0L) {
                        l13 = 0L;
                    }
                    if (l14 < l13) {
                        l14 = l13;
                    }
                    l12 = this.computeBalancedWait(l13, l14, l12);
                }
            }
            if (l12 < l11) {
                l12 = l11;
            }
            if (l12 >= 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Write suspend: " + l12 + ':' + channelHandlerContext.channel().config().isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                this.submitWrite(channelHandlerContext, object, l2, l12, l10, channelPromise);
                return;
            }
        }
        this.submitWrite(channelHandlerContext, object, l2, 0L, l10, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l2, long l10, long l11, ChannelPromise channelPromise) {
        GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend;
        Channel channel = channelHandlerContext.channel();
        Integer n4 = channel.hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n4);
        if (globalChannelTrafficShapingHandler$PerChannel == null) {
            globalChannelTrafficShapingHandler$PerChannel = this.getOrSetPerChannel(channelHandlerContext);
        }
        long l12 = l10;
        boolean bl3 = false;
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel2 = globalChannelTrafficShapingHandler$PerChannel;
        synchronized (globalChannelTrafficShapingHandler$PerChannel2) {
            if (l10 == 0L && globalChannelTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l2);
                globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.bytesRealWriteFlowControl(l2);
                channelHandlerContext.write(object, channelPromise);
                globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp = l11;
                return;
            }
            if (l12 > this.maxTime && l11 + l12 - globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp > this.maxTime) {
                l12 = this.maxTime;
            }
            globalChannelTrafficShapingHandler$ToSend = new GlobalChannelTrafficShapingHandler$ToSend(l12 + l11, object, l2, channelPromise, null);
            globalChannelTrafficShapingHandler$PerChannel.messagesQueue.addLast(globalChannelTrafficShapingHandler$ToSend);
            globalChannelTrafficShapingHandler$PerChannel.queueSize += l2;
            this.queuesSize.addAndGet(l2);
            this.checkWriteSuspend(channelHandlerContext, l12, globalChannelTrafficShapingHandler$PerChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                bl3 = true;
            }
        }
        if (bl3) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
        long l13 = globalChannelTrafficShapingHandler$ToSend.relativeTimeAction;
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel3 = globalChannelTrafficShapingHandler$PerChannel;
        channelHandlerContext.executor().schedule(new GlobalChannelTrafficShapingHandler$2(this, channelHandlerContext, globalChannelTrafficShapingHandler$PerChannel3, l13), l12, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext channelHandlerContext, GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel, long l2) {
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel2 = globalChannelTrafficShapingHandler$PerChannel;
        synchronized (globalChannelTrafficShapingHandler$PerChannel2) {
            GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend = globalChannelTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            while (globalChannelTrafficShapingHandler$ToSend != null) {
                long l10;
                if (globalChannelTrafficShapingHandler$ToSend.relativeTimeAction <= l2) {
                    l10 = globalChannelTrafficShapingHandler$ToSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(l10);
                    globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.bytesRealWriteFlowControl(l10);
                    globalChannelTrafficShapingHandler$PerChannel.queueSize -= l10;
                } else {
                    globalChannelTrafficShapingHandler$PerChannel.messagesQueue.addFirst(globalChannelTrafficShapingHandler$ToSend);
                    break;
                }
                this.queuesSize.addAndGet(-l10);
                channelHandlerContext.write(globalChannelTrafficShapingHandler$ToSend.toSend, globalChannelTrafficShapingHandler$ToSend.promise);
                globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp = l2;
                globalChannelTrafficShapingHandler$ToSend = globalChannelTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            }
            if (globalChannelTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    @Override
    public String toString() {
        return new StringBuilder(340).append(super.toString()).append(" Write Channel Limit: ").append(this.writeChannelLimit).append(" Read Channel Limit: ").append(this.readChannelLimit).toString();
    }

    static /* synthetic */ void access$100(GlobalChannelTrafficShapingHandler globalChannelTrafficShapingHandler, ChannelHandlerContext channelHandlerContext, GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel, long l2) {
        globalChannelTrafficShapingHandler.sendAllValid(channelHandlerContext, globalChannelTrafficShapingHandler$PerChannel, l2);
    }
}

