/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.traffic;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.grpc.netty.shaded.io.netty.handler.traffic.ChannelTrafficShapingHandler$1;
import io.grpc.netty.shaded.io.netty.handler.traffic.ChannelTrafficShapingHandler$ToSend;
import io.grpc.netty.shaded.io.netty.handler.traffic.TrafficCounter;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;

public class ChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ArrayDeque<ChannelTrafficShapingHandler$ToSend> messagesQueue = new ArrayDeque();
    private long queueSize;

    public ChannelTrafficShapingHandler(long l2, long l10, long l11, long l12) {
        super(l2, l10, l11, l12);
    }

    public ChannelTrafficShapingHandler(long l2, long l10, long l11) {
        super(l2, l10, l11);
    }

    public ChannelTrafficShapingHandler(long l2, long l10) {
        super(l2, l10);
    }

    public ChannelTrafficShapingHandler(long l2) {
        super(l2);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        TrafficCounter trafficCounter = new TrafficCounter(this, channelHandlerContext.executor(), "ChannelTC" + channelHandlerContext.channel().hashCode(), this.checkInterval);
        this.setTrafficCounter(trafficCounter);
        trafficCounter.start();
        super.handlerAdded(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.trafficCounter.stop();
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (channelHandlerContext.channel().isActive()) {
                for (ChannelTrafficShapingHandler$ToSend channelTrafficShapingHandler$ToSend : this.messagesQueue) {
                    long l2 = this.calculateSize(channelTrafficShapingHandler$ToSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(l2);
                    this.queueSize -= l2;
                    channelHandlerContext.write(channelTrafficShapingHandler$ToSend.toSend, channelTrafficShapingHandler$ToSend.promise);
                }
            } else {
                for (ChannelTrafficShapingHandler$ToSend channelTrafficShapingHandler$ToSend : this.messagesQueue) {
                    if (!(channelTrafficShapingHandler$ToSend.toSend instanceof ByteBuf)) continue;
                    ((ByteBuf)channelTrafficShapingHandler$ToSend.toSend).release();
                }
            }
            this.messagesQueue.clear();
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l2, long l10, long l11, ChannelPromise channelPromise) {
        ChannelTrafficShapingHandler$ToSend channelTrafficShapingHandler$ToSend;
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (l10 == 0L && this.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l2);
                channelHandlerContext.write(object, channelPromise);
                return;
            }
            channelTrafficShapingHandler$ToSend = new ChannelTrafficShapingHandler$ToSend(l10 + l11, object, channelPromise, null);
            this.messagesQueue.addLast(channelTrafficShapingHandler$ToSend);
            this.queueSize += l2;
            this.checkWriteSuspend(channelHandlerContext, l10, this.queueSize);
        }
        long l12 = channelTrafficShapingHandler$ToSend.relativeTimeAction;
        channelHandlerContext.executor().schedule(new ChannelTrafficShapingHandler$1(this, channelHandlerContext, l12), l10, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext channelHandlerContext, long l2) {
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            ChannelTrafficShapingHandler$ToSend channelTrafficShapingHandler$ToSend = this.messagesQueue.pollFirst();
            while (channelTrafficShapingHandler$ToSend != null) {
                if (channelTrafficShapingHandler$ToSend.relativeTimeAction <= l2) {
                    long l10 = this.calculateSize(channelTrafficShapingHandler$ToSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(l10);
                    this.queueSize -= l10;
                } else {
                    this.messagesQueue.addFirst(channelTrafficShapingHandler$ToSend);
                    break;
                }
                channelHandlerContext.write(channelTrafficShapingHandler$ToSend.toSend, channelTrafficShapingHandler$ToSend.promise);
                channelTrafficShapingHandler$ToSend = this.messagesQueue.pollFirst();
            }
            if (this.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    public long queueSize() {
        return this.queueSize;
    }

    static /* synthetic */ void access$100(ChannelTrafficShapingHandler channelTrafficShapingHandler, ChannelHandlerContext channelHandlerContext, long l2) {
        channelTrafficShapingHandler.sendAllValid(channelHandlerContext, l2);
    }
}

