/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.traffic;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufHolder;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.traffic.AbstractTrafficShapingHandler$ReopenReadTimerTask;
import io.grpc.netty.shaded.io.netty.handler.traffic.TrafficCounter;
import io.grpc.netty.shaded.io.netty.util.Attribute;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTrafficShapingHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    public static final long DEFAULT_MAX_TIME = 15000L;
    static final long DEFAULT_MAX_SIZE = 0x400000L;
    static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter;
    private volatile long writeLimit;
    private volatile long readLimit;
    protected volatile long maxTime = 15000L;
    protected volatile long checkInterval = 1000L;
    static final AttributeKey<Boolean> READ_SUSPENDED = AttributeKey.valueOf(AbstractTrafficShapingHandler.class.getName() + ".READ_SUSPENDED");
    static final AttributeKey<Runnable> REOPEN_TASK = AttributeKey.valueOf(AbstractTrafficShapingHandler.class.getName() + ".REOPEN_TASK");
    volatile long maxWriteDelay = 4000L;
    volatile long maxWriteSize = 0x400000L;
    final int userDefinedWritabilityIndex;
    static final int CHANNEL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 1;
    static final int GLOBAL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 2;
    static final int GLOBALCHANNEL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 3;

    void setTrafficCounter(TrafficCounter trafficCounter) {
        this.trafficCounter = trafficCounter;
    }

    protected int userDefinedWritabilityIndex() {
        return 1;
    }

    protected AbstractTrafficShapingHandler(long l2, long l10, long l11, long l12) {
        if (l12 <= 0L) {
            throw new IllegalArgumentException("maxTime must be positive");
        }
        this.userDefinedWritabilityIndex = this.userDefinedWritabilityIndex();
        this.writeLimit = l2;
        this.readLimit = l10;
        this.checkInterval = l11;
        this.maxTime = l12;
    }

    protected AbstractTrafficShapingHandler(long l2, long l10, long l11) {
        this(l2, l10, l11, 15000L);
    }

    protected AbstractTrafficShapingHandler(long l2, long l10) {
        this(l2, l10, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler() {
        this(0L, 0L, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(long l2) {
        this(0L, 0L, l2, 15000L);
    }

    public void configure(long l2, long l10, long l11) {
        this.configure(l2, l10);
        this.configure(l11);
    }

    public void configure(long l2, long l10) {
        this.writeLimit = l2;
        this.readLimit = l10;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public void configure(long l2) {
        this.checkInterval = l2;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    public long getWriteLimit() {
        return this.writeLimit;
    }

    public void setWriteLimit(long l2) {
        this.writeLimit = l2;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public long getReadLimit() {
        return this.readLimit;
    }

    public void setReadLimit(long l2) {
        this.readLimit = l2;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long l2) {
        this.checkInterval = l2;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(l2);
        }
    }

    public void setMaxTimeWait(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxTime must be positive");
        }
        this.maxTime = l2;
    }

    public long getMaxTimeWait() {
        return this.maxTime;
    }

    public long getMaxWriteDelay() {
        return this.maxWriteDelay;
    }

    public void setMaxWriteDelay(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxWriteDelay must be positive");
        }
        this.maxWriteDelay = l2;
    }

    public long getMaxWriteSize() {
        return this.maxWriteSize;
    }

    public void setMaxWriteSize(long l2) {
        this.maxWriteSize = l2;
    }

    protected void doAccounting(TrafficCounter trafficCounter) {
    }

    void releaseReadSuspended(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        channel.attr(READ_SUSPENDED).set(false);
        channel.config().setAutoRead(true);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        long l2 = this.calculateSize(object);
        long l10 = TrafficCounter.milliSecondFromNano();
        if (l2 > 0L) {
            long l11 = this.trafficCounter.readTimeToWait(l2, this.readLimit, this.maxTime, l10);
            if ((l11 = this.checkWaitReadTime(channelHandlerContext, l11, l10)) >= 10L) {
                Channel channel = channelHandlerContext.channel();
                ChannelConfig channelConfig = channel.config();
                if (logger.isDebugEnabled()) {
                    logger.debug("Read suspend: " + l11 + ':' + channelConfig.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                if (channelConfig.isAutoRead() && AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext)) {
                    channelConfig.setAutoRead(false);
                    channel.attr(READ_SUSPENDED).set(true);
                    Attribute<Runnable> attribute = channel.attr(REOPEN_TASK);
                    Runnable runnable = attribute.get();
                    if (runnable == null) {
                        runnable = new AbstractTrafficShapingHandler$ReopenReadTimerTask(channelHandlerContext);
                        attribute.set(runnable);
                    }
                    channelHandlerContext.executor().schedule(runnable, l11, TimeUnit.MILLISECONDS);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Suspend final status => " + channelConfig.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext) + " will reopened at: " + l11);
                    }
                }
            }
        }
        this.informReadOperation(channelHandlerContext, l10);
        channelHandlerContext.fireChannelRead(object);
    }

    long checkWaitReadTime(ChannelHandlerContext channelHandlerContext, long l2, long l10) {
        return l2;
    }

    void informReadOperation(ChannelHandlerContext channelHandlerContext, long l2) {
    }

    protected static boolean isHandlerActive(ChannelHandlerContext channelHandlerContext) {
        Boolean bl3 = channelHandlerContext.channel().attr(READ_SUSPENDED).get();
        return bl3 == null || Boolean.FALSE.equals(bl3);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        if (AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext)) {
            channelHandlerContext.read();
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        long l2;
        long l10 = this.calculateSize(object);
        long l11 = TrafficCounter.milliSecondFromNano();
        if (l10 > 0L && (l2 = this.trafficCounter.writeTimeToWait(l10, this.writeLimit, this.maxTime, l11)) >= 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Write suspend: " + l2 + ':' + channelHandlerContext.channel().config().isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext));
            }
            this.submitWrite(channelHandlerContext, object, l10, l2, l11, channelPromise);
            return;
        }
        this.submitWrite(channelHandlerContext, object, l10, 0L, l11, channelPromise);
    }

    @Deprecated
    protected void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l2, ChannelPromise channelPromise) {
        this.submitWrite(channelHandlerContext, object, this.calculateSize(object), l2, TrafficCounter.milliSecondFromNano(), channelPromise);
    }

    abstract void submitWrite(ChannelHandlerContext var1, Object var2, long var3, long var5, long var7, ChannelPromise var9);

    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        this.setUserDefinedWritability(channelHandlerContext, true);
        super.channelRegistered(channelHandlerContext);
    }

    void setUserDefinedWritability(ChannelHandlerContext channelHandlerContext, boolean bl3) {
        ChannelOutboundBuffer channelOutboundBuffer = channelHandlerContext.channel().unsafe().outboundBuffer();
        if (channelOutboundBuffer != null) {
            channelOutboundBuffer.setUserDefinedWritability(this.userDefinedWritabilityIndex, bl3);
        }
    }

    void checkWriteSuspend(ChannelHandlerContext channelHandlerContext, long l2, long l10) {
        if (l10 > this.maxWriteSize || l2 > this.maxWriteDelay) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
    }

    void releaseWriteSuspended(ChannelHandlerContext channelHandlerContext) {
        this.setUserDefinedWritability(channelHandlerContext, true);
    }

    public TrafficCounter trafficCounter() {
        return this.trafficCounter;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(290).append("TrafficShaping with Write Limit: ").append(this.writeLimit).append(" Read Limit: ").append(this.readLimit).append(" CheckInterval: ").append(this.checkInterval).append(" maxDelay: ").append(this.maxWriteDelay).append(" maxSize: ").append(this.maxWriteSize).append(" and Counter: ");
        if (this.trafficCounter != null) {
            stringBuilder.append(this.trafficCounter);
        } else {
            stringBuilder.append("none");
        }
        return stringBuilder.toString();
    }

    protected long calculateSize(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }
}

