/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.timeout;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.timeout.WriteTimeoutException;
import io.grpc.netty.shaded.io.netty.handler.timeout.WriteTimeoutHandler$WriteTimeoutTask;
import java.util.concurrent.TimeUnit;

public class WriteTimeoutHandler
extends ChannelOutboundHandlerAdapter {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long timeoutNanos;
    private WriteTimeoutHandler$WriteTimeoutTask lastTask;
    private boolean closed;

    public WriteTimeoutHandler(int n4) {
        this(n4, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(long l2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.timeoutNanos = l2 <= 0L ? 0L : Math.max(timeUnit.toNanos(l2), MIN_TIMEOUT_NANOS);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.timeoutNanos > 0L) {
            channelPromise = channelPromise.unvoid();
            this.scheduleTimeout(channelHandlerContext, channelPromise);
        }
        channelHandlerContext.write(object, channelPromise);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask = this.lastTask;
        this.lastTask = null;
        while (writeTimeoutHandler$WriteTimeoutTask != null) {
            writeTimeoutHandler$WriteTimeoutTask.scheduledFuture.cancel(false);
            WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask2 = writeTimeoutHandler$WriteTimeoutTask.prev;
            writeTimeoutHandler$WriteTimeoutTask.prev = null;
            writeTimeoutHandler$WriteTimeoutTask.next = null;
            writeTimeoutHandler$WriteTimeoutTask = writeTimeoutHandler$WriteTimeoutTask2;
        }
    }

    private void scheduleTimeout(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask = new WriteTimeoutHandler$WriteTimeoutTask(this, channelHandlerContext, channelPromise);
        writeTimeoutHandler$WriteTimeoutTask.scheduledFuture = channelHandlerContext.executor().schedule(writeTimeoutHandler$WriteTimeoutTask, this.timeoutNanos, TimeUnit.NANOSECONDS);
        if (!writeTimeoutHandler$WriteTimeoutTask.scheduledFuture.isDone()) {
            this.addWriteTimeoutTask(writeTimeoutHandler$WriteTimeoutTask);
            channelPromise.addListener(writeTimeoutHandler$WriteTimeoutTask);
        }
    }

    private void addWriteTimeoutTask(WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask) {
        if (this.lastTask != null) {
            this.lastTask.next = writeTimeoutHandler$WriteTimeoutTask;
            writeTimeoutHandler$WriteTimeoutTask.prev = this.lastTask;
        }
        this.lastTask = writeTimeoutHandler$WriteTimeoutTask;
    }

    private void removeWriteTimeoutTask(WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask) {
        if (writeTimeoutHandler$WriteTimeoutTask == this.lastTask) {
            assert (writeTimeoutHandler$WriteTimeoutTask.next == null);
            this.lastTask = this.lastTask.prev;
            if (this.lastTask != null) {
                this.lastTask.next = null;
            }
        } else {
            if (writeTimeoutHandler$WriteTimeoutTask.prev == null && writeTimeoutHandler$WriteTimeoutTask.next == null) {
                return;
            }
            if (writeTimeoutHandler$WriteTimeoutTask.prev == null) {
                writeTimeoutHandler$WriteTimeoutTask.next.prev = null;
            } else {
                writeTimeoutHandler$WriteTimeoutTask.prev.next = writeTimeoutHandler$WriteTimeoutTask.next;
                writeTimeoutHandler$WriteTimeoutTask.next.prev = writeTimeoutHandler$WriteTimeoutTask.prev;
            }
        }
        writeTimeoutHandler$WriteTimeoutTask.prev = null;
        writeTimeoutHandler$WriteTimeoutTask.next = null;
    }

    protected void writeTimedOut(ChannelHandlerContext channelHandlerContext) {
        if (!this.closed) {
            channelHandlerContext.fireExceptionCaught(WriteTimeoutException.INSTANCE);
            channelHandlerContext.close();
            this.closed = true;
        }
    }

    static /* synthetic */ void access$000(WriteTimeoutHandler writeTimeoutHandler, WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask) {
        writeTimeoutHandler.removeWriteTimeoutTask(writeTimeoutHandler$WriteTimeoutTask);
    }
}

