/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.timeout;

import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.Channel$Unsafe;
import io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.timeout.IdleState;
import io.grpc.netty.shaded.io.netty.handler.timeout.IdleStateEvent;
import io.grpc.netty.shaded.io.netty.handler.timeout.IdleStateHandler$1;
import io.grpc.netty.shaded.io.netty.handler.timeout.IdleStateHandler$AllIdleTimeoutTask;
import io.grpc.netty.shaded.io.netty.handler.timeout.IdleStateHandler$ReaderIdleTimeoutTask;
import io.grpc.netty.shaded.io.netty.handler.timeout.IdleStateHandler$WriterIdleTimeoutTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class IdleStateHandler
extends ChannelDuplexHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final ChannelFutureListener writeListener = new IdleStateHandler$1(this);
    private final boolean observeOutput;
    private final long readerIdleTimeNanos;
    private final long writerIdleTimeNanos;
    private final long allIdleTimeNanos;
    private ScheduledFuture<?> readerIdleTimeout;
    private long lastReadTime;
    private boolean firstReaderIdleEvent = true;
    private ScheduledFuture<?> writerIdleTimeout;
    private long lastWriteTime;
    private boolean firstWriterIdleEvent = true;
    private ScheduledFuture<?> allIdleTimeout;
    private boolean firstAllIdleEvent = true;
    private byte state;
    private boolean reading;
    private long lastChangeCheckTimeStamp;
    private int lastMessageHashCode;
    private long lastPendingWriteBytes;
    private long lastFlushProgress;

    public IdleStateHandler(int n4, int n7, int n8) {
        this(n4, n7, n8, TimeUnit.SECONDS);
    }

    public IdleStateHandler(long l2, long l10, long l11, TimeUnit timeUnit) {
        this(false, l2, l10, l11, timeUnit);
    }

    public IdleStateHandler(boolean bl3, long l2, long l10, long l11, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.observeOutput = bl3;
        this.readerIdleTimeNanos = l2 <= 0L ? 0L : Math.max(timeUnit.toNanos(l2), MIN_TIMEOUT_NANOS);
        this.writerIdleTimeNanos = l10 <= 0L ? 0L : Math.max(timeUnit.toNanos(l10), MIN_TIMEOUT_NANOS);
        this.allIdleTimeNanos = l11 <= 0L ? 0L : Math.max(timeUnit.toNanos(l11), MIN_TIMEOUT_NANOS);
    }

    public long getReaderIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.readerIdleTimeNanos);
    }

    public long getWriterIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.writerIdleTimeNanos);
    }

    public long getAllIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.allIdleTimeNanos);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isActive() && channelHandlerContext.channel().isRegistered()) {
            this.initialize(channelHandlerContext);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isActive()) {
            this.initialize(channelHandlerContext);
        }
        super.channelRegistered(channelHandlerContext);
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        this.initialize(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.reading = true;
            this.firstAllIdleEvent = true;
            this.firstReaderIdleEvent = true;
        }
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if ((this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) && this.reading) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            channelHandlerContext.write(object, channelPromise.unvoid()).addListener(this.writeListener);
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    private void initialize(ChannelHandlerContext channelHandlerContext) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        this.initOutputChanged(channelHandlerContext);
        this.lastReadTime = this.lastWriteTime = this.ticksInNanos();
        if (this.readerIdleTimeNanos > 0L) {
            this.readerIdleTimeout = this.schedule(channelHandlerContext, new IdleStateHandler$ReaderIdleTimeoutTask(this, channelHandlerContext), this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.writerIdleTimeNanos > 0L) {
            this.writerIdleTimeout = this.schedule(channelHandlerContext, new IdleStateHandler$WriterIdleTimeoutTask(this, channelHandlerContext), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.allIdleTimeNanos > 0L) {
            this.allIdleTimeout = this.schedule(channelHandlerContext, new IdleStateHandler$AllIdleTimeoutTask(this, channelHandlerContext), this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
    }

    long ticksInNanos() {
        return System.nanoTime();
    }

    ScheduledFuture<?> schedule(ChannelHandlerContext channelHandlerContext, Runnable runnable, long l2, TimeUnit timeUnit) {
        return channelHandlerContext.executor().schedule(runnable, l2, timeUnit);
    }

    private void destroy() {
        this.state = (byte)2;
        if (this.readerIdleTimeout != null) {
            this.readerIdleTimeout.cancel(false);
            this.readerIdleTimeout = null;
        }
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel(false);
            this.allIdleTimeout = null;
        }
    }

    protected void channelIdle(ChannelHandlerContext channelHandlerContext, IdleStateEvent idleStateEvent) {
        channelHandlerContext.fireUserEventTriggered(idleStateEvent);
    }

    protected IdleStateEvent newIdleStateEvent(IdleState idleState, boolean bl3) {
        switch (idleState) {
            case ALL_IDLE: {
                return bl3 ? IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT : IdleStateEvent.ALL_IDLE_STATE_EVENT;
            }
            case READER_IDLE: {
                return bl3 ? IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT : IdleStateEvent.READER_IDLE_STATE_EVENT;
            }
            case WRITER_IDLE: {
                return bl3 ? IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT : IdleStateEvent.WRITER_IDLE_STATE_EVENT;
            }
        }
        throw new IllegalArgumentException("Unhandled: state=" + (Object)((Object)idleState) + ", first=" + bl3);
    }

    private void initOutputChanged(ChannelHandlerContext channelHandlerContext) {
        Channel channel;
        Channel$Unsafe channel$Unsafe;
        ChannelOutboundBuffer channelOutboundBuffer;
        if (this.observeOutput && (channelOutboundBuffer = (channel$Unsafe = (channel = channelHandlerContext.channel()).unsafe()).outboundBuffer()) != null) {
            this.lastMessageHashCode = System.identityHashCode(channelOutboundBuffer.current());
            this.lastPendingWriteBytes = channelOutboundBuffer.totalPendingWriteBytes();
            this.lastFlushProgress = channelOutboundBuffer.currentProgress();
        }
    }

    private boolean hasOutputChanged(ChannelHandlerContext channelHandlerContext, boolean bl3) {
        if (this.observeOutput) {
            Channel channel;
            Channel$Unsafe channel$Unsafe;
            ChannelOutboundBuffer channelOutboundBuffer;
            if (this.lastChangeCheckTimeStamp != this.lastWriteTime) {
                this.lastChangeCheckTimeStamp = this.lastWriteTime;
                if (!bl3) {
                    return true;
                }
            }
            if ((channelOutboundBuffer = (channel$Unsafe = (channel = channelHandlerContext.channel()).unsafe()).outboundBuffer()) != null) {
                long l2;
                int n4 = System.identityHashCode(channelOutboundBuffer.current());
                long l10 = channelOutboundBuffer.totalPendingWriteBytes();
                if (n4 != this.lastMessageHashCode || l10 != this.lastPendingWriteBytes) {
                    this.lastMessageHashCode = n4;
                    this.lastPendingWriteBytes = l10;
                    if (!bl3) {
                        return true;
                    }
                }
                if ((l2 = channelOutboundBuffer.currentProgress()) != this.lastFlushProgress) {
                    this.lastFlushProgress = l2;
                    if (!bl3) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static /* synthetic */ long access$002(IdleStateHandler idleStateHandler, long l2) {
        idleStateHandler.lastWriteTime = l2;
        return idleStateHandler.lastWriteTime;
    }

    static /* synthetic */ boolean access$102(IdleStateHandler idleStateHandler, boolean bl3) {
        idleStateHandler.firstWriterIdleEvent = bl3;
        return idleStateHandler.firstWriterIdleEvent;
    }

    static /* synthetic */ boolean access$202(IdleStateHandler idleStateHandler, boolean bl3) {
        idleStateHandler.firstAllIdleEvent = bl3;
        return idleStateHandler.firstAllIdleEvent;
    }

    static /* synthetic */ long access$300(IdleStateHandler idleStateHandler) {
        return idleStateHandler.readerIdleTimeNanos;
    }

    static /* synthetic */ boolean access$400(IdleStateHandler idleStateHandler) {
        return idleStateHandler.reading;
    }

    static /* synthetic */ long access$500(IdleStateHandler idleStateHandler) {
        return idleStateHandler.lastReadTime;
    }

    static /* synthetic */ ScheduledFuture access$602(IdleStateHandler idleStateHandler, ScheduledFuture scheduledFuture) {
        idleStateHandler.readerIdleTimeout = scheduledFuture;
        return idleStateHandler.readerIdleTimeout;
    }

    static /* synthetic */ boolean access$700(IdleStateHandler idleStateHandler) {
        return idleStateHandler.firstReaderIdleEvent;
    }

    static /* synthetic */ boolean access$702(IdleStateHandler idleStateHandler, boolean bl3) {
        idleStateHandler.firstReaderIdleEvent = bl3;
        return idleStateHandler.firstReaderIdleEvent;
    }

    static /* synthetic */ long access$000(IdleStateHandler idleStateHandler) {
        return idleStateHandler.lastWriteTime;
    }

    static /* synthetic */ long access$800(IdleStateHandler idleStateHandler) {
        return idleStateHandler.writerIdleTimeNanos;
    }

    static /* synthetic */ ScheduledFuture access$902(IdleStateHandler idleStateHandler, ScheduledFuture scheduledFuture) {
        idleStateHandler.writerIdleTimeout = scheduledFuture;
        return idleStateHandler.writerIdleTimeout;
    }

    static /* synthetic */ boolean access$100(IdleStateHandler idleStateHandler) {
        return idleStateHandler.firstWriterIdleEvent;
    }

    static /* synthetic */ boolean access$1000(IdleStateHandler idleStateHandler, ChannelHandlerContext channelHandlerContext, boolean bl3) {
        return idleStateHandler.hasOutputChanged(channelHandlerContext, bl3);
    }

    static /* synthetic */ long access$1100(IdleStateHandler idleStateHandler) {
        return idleStateHandler.allIdleTimeNanos;
    }

    static /* synthetic */ ScheduledFuture access$1202(IdleStateHandler idleStateHandler, ScheduledFuture scheduledFuture) {
        idleStateHandler.allIdleTimeout = scheduledFuture;
        return idleStateHandler.allIdleTimeout;
    }

    static /* synthetic */ boolean access$200(IdleStateHandler idleStateHandler) {
        return idleStateHandler.firstAllIdleEvent;
    }
}

