/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.stream;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.stream.ChunkedInput;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChunkedNioStream
implements ChunkedInput<ByteBuf> {
    private final ReadableByteChannel in;
    private final int chunkSize;
    private long offset;
    private final ByteBuffer byteBuffer;

    public ChunkedNioStream(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, 8192);
    }

    public ChunkedNioStream(ReadableByteChannel readableByteChannel, int n4) {
        if (readableByteChannel == null) {
            throw new NullPointerException("in");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n4 + " (expected: a positive integer)");
        }
        this.in = readableByteChannel;
        this.offset = 0L;
        this.chunkSize = n4;
        this.byteBuffer = ByteBuffer.allocate(n4);
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        if (this.byteBuffer.position() > 0) {
            return false;
        }
        if (this.in.isOpen()) {
            int n4 = this.in.read(this.byteBuffer);
            if (n4 < 0) {
                return true;
            }
            this.offset += (long)n4;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) {
        int n4;
        if (this.isEndOfInput()) {
            return null;
        }
        int n7 = this.byteBuffer.position();
        while ((n4 = this.in.read(this.byteBuffer)) >= 0) {
            this.offset += (long)n4;
            if ((n7 += n4) != this.chunkSize) continue;
            break;
        }
        this.byteBuffer.flip();
        n4 = 1;
        ByteBuf byteBuf = byteBufAllocator.buffer(this.byteBuffer.remaining());
        try {
            byteBuf.writeBytes(this.byteBuffer);
            this.byteBuffer.clear();
            n4 = 0;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (n4 != 0) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

