/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.stream;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.FileInputStream;
import java.nio.channels.FileChannel;

public class ChunkedNioFile
implements ChunkedInput<ByteBuf> {
    private final FileChannel in;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedNioFile(File file) {
        this(new FileInputStream(file).getChannel());
    }

    public ChunkedNioFile(File file, int n4) {
        this(new FileInputStream(file).getChannel(), n4);
    }

    public ChunkedNioFile(FileChannel fileChannel) {
        this(fileChannel, 8192);
    }

    public ChunkedNioFile(FileChannel fileChannel, int n4) {
        this(fileChannel, 0L, fileChannel.size(), n4);
    }

    public ChunkedNioFile(FileChannel fileChannel, long l2, long l10, int n4) {
        if (fileChannel == null) {
            throw new NullPointerException("in");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("offset: " + l2 + " (expected: 0 or greater)");
        }
        if (l10 < 0L) {
            throw new IllegalArgumentException("length: " + l10 + " (expected: 0 or greater)");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n4 + " (expected: a positive integer)");
        }
        if (l2 != 0L) {
            fileChannel.position(l2);
        }
        this.in = fileChannel;
        this.chunkSize = n4;
        this.offset = this.startOffset = l2;
        this.endOffset = l2 + l10;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        return this.offset >= this.endOffset || !this.in.isOpen();
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) {
        long l2 = this.offset;
        if (l2 >= this.endOffset) {
            return null;
        }
        int n4 = (int)Math.min((long)this.chunkSize, this.endOffset - l2);
        ByteBuf byteBuf = byteBufAllocator.buffer(n4);
        boolean bl3 = true;
        try {
            int n7;
            int n8 = 0;
            while ((n7 = byteBuf.writeBytes(this.in, n4 - n8)) >= 0 && (n8 += n7) != n4) {
            }
            this.offset += (long)n8;
            bl3 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl3) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

