/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.stream;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.RandomAccessFile;

public class ChunkedFile
implements ChunkedInput<ByteBuf> {
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedFile(File file) {
        this(file, 8192);
    }

    public ChunkedFile(File file, int n4) {
        this(new RandomAccessFile(file, "r"), n4);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, 8192);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile, int n4) {
        this(randomAccessFile, 0L, randomAccessFile.length(), n4);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile, long l2, long l10, int n4) {
        if (randomAccessFile == null) {
            throw new NullPointerException("file");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("offset: " + l2 + " (expected: 0 or greater)");
        }
        if (l10 < 0L) {
            throw new IllegalArgumentException("length: " + l10 + " (expected: 0 or greater)");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n4 + " (expected: a positive integer)");
        }
        this.file = randomAccessFile;
        this.offset = this.startOffset = l2;
        this.endOffset = l2 + l10;
        this.chunkSize = n4;
        randomAccessFile.seek(l2);
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        return this.offset >= this.endOffset || !this.file.getChannel().isOpen();
    }

    @Override
    public void close() {
        this.file.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) {
        long l2 = this.offset;
        if (l2 >= this.endOffset) {
            return null;
        }
        int n4 = (int)Math.min((long)this.chunkSize, this.endOffset - l2);
        ByteBuf byteBuf = byteBufAllocator.heapBuffer(n4);
        boolean bl3 = true;
        try {
            this.file.readFully(byteBuf.array(), byteBuf.arrayOffset(), n4);
            byteBuf.writerIndex(n4);
            this.offset = l2 + (long)n4;
            bl3 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl3) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

