/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl.util;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.BouncyCastleSelfSignedCertGenerator;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.OpenJdkSelfSignedCertGenerator;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.ThreadLocalInsecureRandom;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;

public final class SelfSignedCertificate {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelfSignedCertificate.class);
    private static final Date DEFAULT_NOT_BEFORE = new Date(SystemPropertyUtil.getLong("io.grpc.netty.shaded.io.netty.selfSignedCertificate.defaultNotBefore", System.currentTimeMillis() - 31536000000L));
    private static final Date DEFAULT_NOT_AFTER = new Date(SystemPropertyUtil.getLong("io.grpc.netty.shaded.io.netty.selfSignedCertificate.defaultNotAfter", 253402300799000L));
    private static final int DEFAULT_KEY_LENGTH_BITS = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.handler.ssl.util.selfSignedKeyStrength", 2048);
    private final File certificate;
    private final File privateKey;
    private final X509Certificate cert;
    private final PrivateKey key;

    public SelfSignedCertificate() {
        this(DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER);
    }

    public SelfSignedCertificate(Date date, Date date2) {
        this("example.com", date, date2);
    }

    public SelfSignedCertificate(String string) {
        this(string, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER);
    }

    public SelfSignedCertificate(String string, Date date, Date date2) {
        this(string, ThreadLocalInsecureRandom.current(), DEFAULT_KEY_LENGTH_BITS, date, date2);
    }

    public SelfSignedCertificate(String string, SecureRandom secureRandom, int n4) {
        this(string, secureRandom, n4, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER);
    }

    public SelfSignedCertificate(String string, SecureRandom secureRandom, int n4, Date date, Date date2) {
        KeyPair keyPair;
        String[] stringArray;
        try {
            stringArray = KeyPairGenerator.getInstance("RSA");
            stringArray.initialize(n4, secureRandom);
            keyPair = stringArray.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        try {
            stringArray = OpenJdkSelfSignedCertGenerator.generate(string, keyPair, secureRandom, date, date2);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to generate a self-signed X.509 certificate using sun.security.x509:", throwable);
            try {
                stringArray = BouncyCastleSelfSignedCertGenerator.generate(string, keyPair, secureRandom, date, date2);
            }
            catch (Throwable throwable2) {
                logger.debug("Failed to generate a self-signed X.509 certificate using Bouncy Castle:", throwable2);
                throw new CertificateException("No provider succeeded to generate a self-signed certificate. See debug log for the root cause.", throwable2);
            }
        }
        this.certificate = new File(stringArray[0]);
        this.privateKey = new File(stringArray[1]);
        this.key = keyPair.getPrivate();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.certificate);
            this.cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(fileInputStream);
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception);
        }
        finally {
            block17: {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!logger.isWarnEnabled()) break block17;
                        logger.warn("Failed to close a file: " + this.certificate, iOException);
                    }
                }
            }
        }
    }

    public File certificate() {
        return this.certificate;
    }

    public File privateKey() {
        return this.privateKey;
    }

    public X509Certificate cert() {
        return this.cert;
    }

    public PrivateKey key() {
        return this.key;
    }

    public void delete() {
        SelfSignedCertificate.safeDelete(this.certificate);
        SelfSignedCertificate.safeDelete(this.privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] newSelfSignedCertificate(String string, PrivateKey privateKey, X509Certificate x509Certificate) {
        String string2;
        String string3;
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = Unpooled.wrappedBuffer(privateKey.getEncoded());
        try {
            byteBuf = Base64.encode(byteBuf2, true);
            try {
                string3 = "-----BEGIN PRIVATE KEY-----\n" + byteBuf.toString(CharsetUtil.US_ASCII) + "\n-----END PRIVATE KEY-----\n";
            }
            finally {
                byteBuf.release();
            }
        }
        finally {
            byteBuf2.release();
        }
        File file = File.createTempFile("keyutil_" + string + '_', ".key");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ((OutputStream)fileOutputStream).write(string3.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        finally {
            if (fileOutputStream != null) {
                SelfSignedCertificate.safeClose(file, fileOutputStream);
                SelfSignedCertificate.safeDelete(file);
            }
        }
        byteBuf2 = Unpooled.wrappedBuffer(x509Certificate.getEncoded());
        try {
            byteBuf = Base64.encode(byteBuf2, true);
            try {
                string2 = "-----BEGIN CERTIFICATE-----\n" + byteBuf.toString(CharsetUtil.US_ASCII) + "\n-----END CERTIFICATE-----\n";
            }
            finally {
                byteBuf.release();
            }
        }
        finally {
            byteBuf2.release();
        }
        File file2 = File.createTempFile("keyutil_" + string + '_', ".crt");
        file2.deleteOnExit();
        FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
        try {
            ((OutputStream)fileOutputStream2).write(string2.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)fileOutputStream2).close();
            fileOutputStream2 = null;
        }
        finally {
            if (fileOutputStream2 != null) {
                SelfSignedCertificate.safeClose(file2, fileOutputStream2);
                SelfSignedCertificate.safeDelete(file2);
                SelfSignedCertificate.safeDelete(file);
            }
        }
        return new String[]{file2.getPath(), file.getPath()};
    }

    private static void safeDelete(File file) {
        if (!file.delete() && logger.isWarnEnabled()) {
            logger.warn("Failed to delete a file: " + file);
        }
    }

    private static void safeClose(File file, OutputStream outputStream) {
        block2: {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a file: " + file, iOException);
            }
        }
    }
}

