/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64;
import io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64Dialect;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.grpc.netty.shaded.io.netty.util.NetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;

final class SslUtils {
    static final Set<String> TLSV13_CIPHERS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_128_CCM_8_SHA256", "TLS_AES_128_CCM_SHA256")));
    static final String PROTOCOL_SSL_V2_HELLO = "SSLv2Hello";
    static final String PROTOCOL_SSL_V2 = "SSLv2";
    static final String PROTOCOL_SSL_V3 = "SSLv3";
    static final String PROTOCOL_TLS_V1 = "TLSv1";
    static final String PROTOCOL_TLS_V1_1 = "TLSv1.1";
    static final String PROTOCOL_TLS_V1_2 = "TLSv1.2";
    static final String PROTOCOL_TLS_V1_3 = "TLSv1.3";
    static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    static final int SSL_CONTENT_TYPE_CHANGE_CIPHER_SPEC = 20;
    static final int SSL_CONTENT_TYPE_ALERT = 21;
    static final int SSL_CONTENT_TYPE_HANDSHAKE = 22;
    static final int SSL_CONTENT_TYPE_APPLICATION_DATA = 23;
    static final int SSL_CONTENT_TYPE_EXTENSION_HEARTBEAT = 24;
    static final int SSL_RECORD_HEADER_LENGTH = 5;
    static final int NOT_ENOUGH_DATA = -1;
    static final int NOT_ENCRYPTED = -2;
    static final String[] DEFAULT_CIPHER_SUITES;
    static final String[] DEFAULT_TLSV13_CIPHER_SUITES;
    static final String[] TLSV13_CIPHER_SUITES;

    static void addIfSupported(Set<String> set, List<String> list, String ... stringArray) {
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            list.add(string);
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, Iterable<String> iterable) {
        if (list.isEmpty()) {
            for (String string : iterable) {
                if (string.startsWith("SSL_") || string.contains("_RC4_")) continue;
                list.add(string);
            }
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, String ... stringArray) {
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(list, Arrays.asList(stringArray));
    }

    static SSLHandshakeException toSSLHandshakeException(Throwable throwable) {
        if (throwable instanceof SSLHandshakeException) {
            return (SSLHandshakeException)throwable;
        }
        return (SSLHandshakeException)new SSLHandshakeException(throwable.getMessage()).initCause(throwable);
    }

    static int getEncryptedPacketLength(ByteBuf byteBuf, int n4) {
        int n7;
        boolean bl3;
        int n8 = 0;
        switch (byteBuf.getUnsignedByte(n4)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl3 = true;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        if (bl3) {
            n7 = byteBuf.getUnsignedByte(n4 + 1);
            if (n7 == 3) {
                n8 = SslUtils.unsignedShortBE(byteBuf, n4 + 3) + 5;
                if (n8 <= 5) {
                    bl3 = false;
                }
            } else {
                bl3 = false;
            }
        }
        if (!bl3) {
            n7 = (byteBuf.getUnsignedByte(n4) & 0x80) != 0 ? 2 : 3;
            short s11 = byteBuf.getUnsignedByte(n4 + n7 + 1);
            if (s11 == 2 || s11 == 3) {
                int n10 = n8 = n7 == 2 ? (SslUtils.shortBE(byteBuf, n4) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuf, n4) & 0x3FFF) + 3;
                if (n8 <= n7) {
                    return -1;
                }
            } else {
                return -2;
            }
        }
        return n8;
    }

    private static int unsignedShortBE(ByteBuf byteBuf, int n4) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.getUnsignedShort(n4) : byteBuf.getUnsignedShortLE(n4);
    }

    private static short shortBE(ByteBuf byteBuf, int n4) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.getShort(n4) : byteBuf.getShortLE(n4);
    }

    private static short unsignedByte(byte by2) {
        return (short)(by2 & 0xFF);
    }

    private static int unsignedShortBE(ByteBuffer byteBuffer, int n4) {
        return SslUtils.shortBE(byteBuffer, n4) & 0xFFFF;
    }

    private static short shortBE(ByteBuffer byteBuffer, int n4) {
        return byteBuffer.order() == ByteOrder.BIG_ENDIAN ? byteBuffer.getShort(n4) : ByteBufUtil.swapShort(byteBuffer.getShort(n4));
    }

    static int getEncryptedPacketLength(ByteBuffer[] byteBufferArray, int n4) {
        ByteBuffer byteBuffer = byteBufferArray[n4];
        if (byteBuffer.remaining() >= 5) {
            return SslUtils.getEncryptedPacketLength(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(5);
        do {
            if ((byteBuffer = byteBufferArray[n4++].duplicate()).remaining() > byteBuffer2.remaining()) {
                byteBuffer.limit(byteBuffer.position() + byteBuffer2.remaining());
            }
            byteBuffer2.put(byteBuffer);
        } while (byteBuffer2.hasRemaining());
        byteBuffer2.flip();
        return SslUtils.getEncryptedPacketLength(byteBuffer2);
    }

    private static int getEncryptedPacketLength(ByteBuffer byteBuffer) {
        int n4;
        boolean bl3;
        int n7 = 0;
        int n8 = byteBuffer.position();
        switch (SslUtils.unsignedByte(byteBuffer.get(n8))) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl3 = true;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        if (bl3) {
            n4 = SslUtils.unsignedByte(byteBuffer.get(n8 + 1));
            if (n4 == 3) {
                n7 = SslUtils.unsignedShortBE(byteBuffer, n8 + 3) + 5;
                if (n7 <= 5) {
                    bl3 = false;
                }
            } else {
                bl3 = false;
            }
        }
        if (!bl3) {
            n4 = (SslUtils.unsignedByte(byteBuffer.get(n8)) & 0x80) != 0 ? 2 : 3;
            short s11 = SslUtils.unsignedByte(byteBuffer.get(n8 + n4 + 1));
            if (s11 == 2 || s11 == 3) {
                int n10 = n7 = n4 == 2 ? (SslUtils.shortBE(byteBuffer, n8) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuffer, n8) & 0x3FFF) + 3;
                if (n7 <= n4) {
                    return -1;
                }
            } else {
                return -2;
            }
        }
        return n7;
    }

    static void handleHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl3) {
        channelHandlerContext.flush();
        if (bl3) {
            channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
        }
        channelHandlerContext.close();
    }

    static void zeroout(ByteBuf byteBuf) {
        if (!byteBuf.isReadOnly()) {
            byteBuf.setZero(0, byteBuf.capacity());
        }
    }

    static void zerooutAndRelease(ByteBuf byteBuf) {
        SslUtils.zeroout(byteBuf);
        byteBuf.release();
    }

    static ByteBuf toBase64(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), true, Base64Dialect.STANDARD, byteBufAllocator);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    static boolean isValidHostNameForSNI(String string) {
        return string != null && string.indexOf(46) > 0 && !string.endsWith(".") && !NetUtil.isValidIpV4Address(string) && !NetUtil.isValidIpV6Address(string);
    }

    static boolean isTLSv13Cipher(String string) {
        return TLSV13_CIPHERS.contains(string);
    }

    private SslUtils() {
    }

    static {
        TLSV13_CIPHER_SUITES = new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"};
        DEFAULT_TLSV13_CIPHER_SUITES = PlatformDependent.javaVersion() >= 11 ? TLSV13_CIPHER_SUITES : EmptyArrays.EMPTY_STRINGS;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        Collections.addAll(arrayList, DEFAULT_TLSV13_CIPHER_SUITES);
        DEFAULT_CIPHER_SUITES = arrayList.toArray(new String[0]);
    }
}

