/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslMasterKeyHandler$WiresharkSslMasterKeyHandler;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import io.grpc.netty.shaded.io.netty.util.internal.ReflectionUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public abstract class SslMasterKeyHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslMasterKeyHandler.class);
    private static final Class<?> SSL_SESSIONIMPL_CLASS;
    private static final Field SSL_SESSIONIMPL_MASTER_SECRET_FIELD;
    public static final String SYSTEM_PROP_KEY = "io.grpc.netty.shaded.io.netty.ssl.masterKeyHandler";
    private static final Throwable UNAVAILABILITY_CAUSE;

    protected SslMasterKeyHandler() {
    }

    public static void ensureSunSslEngineAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw new IllegalStateException("Failed to find SSLSessionImpl on classpath", UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable sunSslEngineUnavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static boolean isSunSslEngineAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    protected abstract void accept(SecretKey var1, SSLSession var2);

    @Override
    public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        boolean bl3;
        if (object == SslHandshakeCompletionEvent.SUCCESS && (bl3 = SystemPropertyUtil.getBoolean(SYSTEM_PROP_KEY, false))) {
            SslHandler sslHandler = channelHandlerContext.pipeline().get(SslHandler.class);
            SSLEngine sSLEngine = sslHandler.engine();
            SSLSession sSLSession = sSLEngine.getSession();
            if (SslMasterKeyHandler.isSunSslEngineAvailable() && sSLSession.getClass().equals(SSL_SESSIONIMPL_CLASS)) {
                SecretKey secretKey;
                try {
                    secretKey = (SecretKey)SSL_SESSIONIMPL_MASTER_SECRET_FIELD.get(sSLSession);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Failed to access the field 'masterSecret' via reflection.", illegalAccessException);
                }
                this.accept(secretKey, sSLSession);
            } else if (OpenSsl.isAvailable() && sSLEngine instanceof ReferenceCountedOpenSslEngine) {
                SecretKeySpec secretKeySpec = new SecretKeySpec(SSL.getMasterKey(((ReferenceCountedOpenSslEngine)sSLEngine).sslPointer()), "AES");
                this.accept(secretKeySpec, sSLSession);
            }
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    public static SslMasterKeyHandler newWireSharkSslMasterKeyHandler() {
        return new SslMasterKeyHandler$WiresharkSslMasterKeyHandler(null);
    }

    static {
        Throwable throwable = null;
        Class<?> clazz = null;
        Field field = null;
        try {
            clazz = Class.forName("sun.security.ssl.SSLSessionImpl");
            field = clazz.getDeclaredField("masterSecret");
            throwable = ReflectionUtil.trySetAccessible(field, true);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            logger.debug("sun.security.ssl.SSLSessionImpl is unavailable.", throwable2);
        }
        UNAVAILABILITY_CAUSE = throwable;
        SSL_SESSIONIMPL_CLASS = clazz;
        SSL_SESSIONIMPL_MASTER_SECRET_FIELD = field;
    }
}

