/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromiseNotifier;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.UnsupportedMessageTypeException;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.grpc.netty.shaded.io.netty.handler.ssl.NotSslRecordException;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslCloseCompletionEvent;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$1;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$2;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$3;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$4;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$5;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$6;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$7;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$8;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$LazyChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$SslEngineType;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$SslHandlerCoalescingBufferQueue;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler$SslTasksRunner;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.grpc.netty.shaded.io.netty.util.concurrent.ImmediateExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import io.grpc.netty.shaded.io.netty.util.concurrent.PromiseNotifier;
import io.grpc.netty.shaded.io.netty.util.concurrent.ScheduledFuture;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslHandler$SslEngineType engineType;
    private final Executor delegatedTaskExecutor;
    private final boolean jdkCompatibilityMode;
    private final ByteBuffer[] singleBuffer = new ByteBuffer[1];
    private final boolean startTls;
    private boolean sentFirstMessage;
    private boolean flushedBeforeHandshake;
    private boolean readDuringHandshake;
    private boolean handshakeStarted;
    private SslHandler$SslHandlerCoalescingBufferQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new SslHandler$LazyChannelPromise(this, null);
    private final SslHandler$LazyChannelPromise sslClosePromise = new SslHandler$LazyChannelPromise(this, null);
    private boolean needsFlush;
    private boolean outboundClosed;
    private boolean closeNotify;
    private boolean processTask;
    private int packetLength;
    private boolean firedChannelRead;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyFlushTimeoutMillis = 3000L;
    private volatile long closeNotifyReadTimeoutMillis;
    volatile int wrapDataSize = 16384;

    public SslHandler(SSLEngine sSLEngine) {
        this(sSLEngine, false);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl3) {
        this(sSLEngine, bl3, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine sSLEngine, Executor executor) {
        this(sSLEngine, false, executor);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl3, Executor executor) {
        if (sSLEngine == null) {
            throw new NullPointerException("engine");
        }
        if (executor == null) {
            throw new NullPointerException("delegatedTaskExecutor");
        }
        this.engine = sSLEngine;
        this.engineType = SslHandler$SslEngineType.forEngine(sSLEngine);
        this.delegatedTaskExecutor = executor;
        this.startTls = bl3;
        this.jdkCompatibilityMode = this.engineType.jdkCompatibilityMode(sSLEngine);
        this.setCumulator(this.engineType.cumulator);
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long l2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.setHandshakeTimeoutMillis(timeUnit.toMillis(l2));
    }

    public void setHandshakeTimeoutMillis(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("handshakeTimeoutMillis: " + l2 + " (expected: >= 0)");
        }
        this.handshakeTimeoutMillis = l2;
    }

    public final void setWrapDataSize(int n4) {
        this.wrapDataSize = n4;
    }

    @Deprecated
    public long getCloseNotifyTimeoutMillis() {
        return this.getCloseNotifyFlushTimeoutMillis();
    }

    @Deprecated
    public void setCloseNotifyTimeout(long l2, TimeUnit timeUnit) {
        this.setCloseNotifyFlushTimeout(l2, timeUnit);
    }

    @Deprecated
    public void setCloseNotifyTimeoutMillis(long l2) {
        this.setCloseNotifyFlushTimeoutMillis(l2);
    }

    public final long getCloseNotifyFlushTimeoutMillis() {
        return this.closeNotifyFlushTimeoutMillis;
    }

    public final void setCloseNotifyFlushTimeout(long l2, TimeUnit timeUnit) {
        this.setCloseNotifyFlushTimeoutMillis(timeUnit.toMillis(l2));
    }

    public final void setCloseNotifyFlushTimeoutMillis(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("closeNotifyFlushTimeoutMillis: " + l2 + " (expected: >= 0)");
        }
        this.closeNotifyFlushTimeoutMillis = l2;
    }

    public final long getCloseNotifyReadTimeoutMillis() {
        return this.closeNotifyReadTimeoutMillis;
    }

    public final void setCloseNotifyReadTimeout(long l2, TimeUnit timeUnit) {
        this.setCloseNotifyReadTimeoutMillis(timeUnit.toMillis(l2));
    }

    public final void setCloseNotifyReadTimeoutMillis(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("closeNotifyReadTimeoutMillis: " + l2 + " (expected: >= 0)");
        }
        this.closeNotifyReadTimeoutMillis = l2;
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public String applicationProtocol() {
        SSLEngine sSLEngine = this.engine();
        if (!(sSLEngine instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)((Object)sSLEngine)).getNegotiatedApplicationProtocol();
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise;
    }

    @Deprecated
    public ChannelFuture close() {
        return this.closeOutbound();
    }

    @Deprecated
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.closeOutbound(channelPromise);
    }

    public ChannelFuture closeOutbound() {
        return this.closeOutbound(this.ctx.newPromise());
    }

    public ChannelFuture closeOutbound(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext.executor().inEventLoop()) {
            this.closeOutbound0(channelPromise);
        } else {
            channelHandlerContext.executor().execute(new SslHandler$1(this, channelPromise));
        }
        return channelPromise;
    }

    private void closeOutbound0(ChannelPromise channelPromise) {
        block2: {
            this.outboundClosed = true;
            this.engine.closeOutbound();
            try {
                this.flush(this.ctx, channelPromise);
            }
            catch (Exception exception) {
                if (channelPromise.tryFailure(exception)) break block2;
                logger.warn("{} flush() raised a masked exception.", (Object)this.ctx.channel(), (Object)exception);
            }
        }
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslClosePromise;
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        if (!this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.releaseAndFailAll(channelHandlerContext, new ChannelException("Pending write on removal of SslHandler"));
        }
        this.pendingUnencryptedWrites = null;
        if (this.engine instanceof ReferenceCounted) {
            ((ReferenceCounted)((Object)this.engine)).release();
        }
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, true);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, false);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        if (!this.handshakePromise.isDone()) {
            this.readDuringHandshake = true;
        }
        channelHandlerContext.read();
    }

    private static IllegalStateException newPendingWritesNullException() {
        return new IllegalStateException("pendingUnencryptedWrites is null, handlerRemoved0 called?");
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!(object instanceof ByteBuf)) {
            UnsupportedMessageTypeException unsupportedMessageTypeException = new UnsupportedMessageTypeException(object, ByteBuf.class);
            ReferenceCountUtil.safeRelease(object);
            channelPromise.setFailure(unsupportedMessageTypeException);
        } else if (this.pendingUnencryptedWrites == null) {
            ReferenceCountUtil.safeRelease(object);
            channelPromise.setFailure(SslHandler.newPendingWritesNullException());
        } else {
            this.pendingUnencryptedWrites.add((ByteBuf)object, channelPromise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.startTls && !this.sentFirstMessage) {
            this.sentFirstMessage = true;
            this.pendingUnencryptedWrites.writeAndRemoveAll(channelHandlerContext);
            this.forceFlush(channelHandlerContext);
            this.startHandshakeProcessing();
            return;
        }
        if (this.processTask) {
            return;
        }
        try {
            this.wrapAndFlush(channelHandlerContext);
        }
        catch (Throwable throwable) {
            this.setHandshakeFailure(channelHandlerContext, throwable);
            PlatformDependent.throwException(throwable);
        }
    }

    private void wrapAndFlush(ChannelHandlerContext channelHandlerContext) {
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelHandlerContext.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.flushedBeforeHandshake = true;
        }
        try {
            this.wrap(channelHandlerContext, false);
        }
        finally {
            this.forceFlush(channelHandlerContext);
        }
    }

    /*
     * Exception decompiling
     */
    private void wrap(ChannelHandlerContext var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void finishWrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ChannelPromise channelPromise, boolean bl3, boolean bl4) {
        if (byteBuf == null) {
            byteBuf = Unpooled.EMPTY_BUFFER;
        } else if (!byteBuf.isReadable()) {
            byteBuf.release();
            byteBuf = Unpooled.EMPTY_BUFFER;
        }
        if (channelPromise != null) {
            channelHandlerContext.write(byteBuf, channelPromise);
        } else {
            channelHandlerContext.write(byteBuf);
        }
        if (bl3) {
            this.needsFlush = true;
        }
        if (bl4) {
            this.readIfNeeded(channelHandlerContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wrapNonAppData(ChannelHandlerContext channelHandlerContext, boolean bl3) {
        block22: {
            ReferenceCounted referenceCounted = null;
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            try {
                while (!channelHandlerContext.isRemoved()) {
                    SSLEngineResult sSLEngineResult;
                    if (referenceCounted == null) {
                        referenceCounted = this.allocateOutNetBuf(channelHandlerContext, 2048, 1);
                    }
                    if ((sSLEngineResult = this.wrap(byteBufAllocator, this.engine, Unpooled.EMPTY_BUFFER, (ByteBuf)referenceCounted)).bytesProduced() > 0) {
                        channelHandlerContext.write(referenceCounted).addListener(new SslHandler$2(this, channelHandlerContext));
                        if (bl3) {
                            this.needsFlush = true;
                        }
                        referenceCounted = null;
                    }
                    SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    switch (handshakeStatus) {
                        case FINISHED: {
                            this.setHandshakeSuccess();
                            boolean bl4 = false;
                            return bl4;
                        }
                        case NEED_TASK: {
                            if (this.runDelegatedTasks(bl3)) break;
                            break block22;
                        }
                        case NEED_UNWRAP: {
                            if (bl3) {
                                boolean bl5 = false;
                                return bl5;
                            }
                            this.unwrapNonAppData(channelHandlerContext);
                            break;
                        }
                        case NEED_WRAP: {
                            break;
                        }
                        case NOT_HANDSHAKING: {
                            this.setHandshakeSuccessIfStillHandshaking();
                            if (!bl3) {
                                this.unwrapNonAppData(channelHandlerContext);
                            }
                            boolean bl6 = true;
                            return bl6;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()));
                        }
                    }
                    if (sSLEngineResult.bytesProduced() == 0 && handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    } else if (sSLEngineResult.bytesConsumed() != 0 || sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
                    break;
                }
            }
            finally {
                if (referenceCounted != null) {
                    referenceCounted.release();
                }
            }
        }
        return false;
    }

    private SSLEngineResult wrap(ByteBufAllocator byteBufAllocator, SSLEngine sSLEngine, ByteBuf byteBuf, ByteBuf byteBuf2) {
        ReferenceCounted referenceCounted = null;
        try {
            ByteBuffer[] byteBufferArray;
            int n4 = byteBuf.readerIndex();
            int n7 = byteBuf.readableBytes();
            if (byteBuf.isDirect() || !this.engineType.wantsDirectBuffer) {
                if (!(byteBuf instanceof CompositeByteBuf) && byteBuf.nioBufferCount() == 1) {
                    byteBufferArray = this.singleBuffer;
                    byteBufferArray[0] = byteBuf.internalNioBuffer(n4, n7);
                } else {
                    byteBufferArray = byteBuf.nioBuffers();
                }
            } else {
                referenceCounted = byteBufAllocator.directBuffer(n7);
                ((ByteBuf)referenceCounted).writeBytes(byteBuf, n4, n7);
                byteBufferArray = this.singleBuffer;
                byteBufferArray[0] = ((ByteBuf)referenceCounted).internalNioBuffer(((ByteBuf)referenceCounted).readerIndex(), n7);
            }
            while (true) {
                ByteBuffer byteBuffer = byteBuf2.nioBuffer(byteBuf2.writerIndex(), byteBuf2.writableBytes());
                SSLEngineResult sSLEngineResult = sSLEngine.wrap(byteBufferArray, byteBuffer);
                byteBuf.skipBytes(sSLEngineResult.bytesConsumed());
                byteBuf2.writerIndex(byteBuf2.writerIndex() + sSLEngineResult.bytesProduced());
                switch (sSLEngineResult.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        byteBuf2.ensureWritable(sSLEngine.getSession().getPacketBufferSize());
                        break;
                    }
                    default: {
                        SSLEngineResult sSLEngineResult2 = sSLEngineResult;
                        return sSLEngineResult2;
                    }
                }
            }
        }
        finally {
            this.singleBuffer[0] = null;
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        ClosedChannelException closedChannelException = new ClosedChannelException();
        this.setHandshakeFailure(channelHandlerContext, closedChannelException, !this.outboundClosed, this.handshakeStarted, false);
        this.notifyClosePromise(closedChannelException);
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.ignoreException(throwable)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)channelHandlerContext.channel(), (Object)throwable);
            }
            if (channelHandlerContext.channel().isActive()) {
                channelHandlerContext.close();
            }
        } else {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private boolean ignoreException(Throwable throwable) {
        if (!(throwable instanceof SSLException) && throwable instanceof IOException && this.sslClosePromise.isDone()) {
            StackTraceElement[] stackTraceElementArray;
            String string = throwable.getMessage();
            if (string != null && IGNORABLE_ERROR_MESSAGE.matcher(string).matches()) {
                return true;
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                String string2 = stackTraceElement.getClassName();
                String string3 = stackTraceElement.getMethodName();
                if (string2.startsWith("io.grpc.netty.shaded.io.netty.") || !"read".equals(string3)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(string2).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = PlatformDependent.getClassLoader(this.getClass()).loadClass(string2);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                }
                catch (Throwable throwable2) {
                    logger.debug("Unexpected exception while loading class {} classname {}", this.getClass(), string2, throwable2);
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        return SslUtils.getEncryptedPacketLength(byteBuf, byteBuf.readerIndex()) != -2;
    }

    private void decodeJdkCompatible(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n4;
        int n7 = this.packetLength;
        if (n7 > 0) {
            if (byteBuf.readableBytes() < n7) {
                return;
            }
        } else {
            n4 = byteBuf.readableBytes();
            if (n4 < 5) {
                return;
            }
            n7 = SslUtils.getEncryptedPacketLength(byteBuf, byteBuf.readerIndex());
            if (n7 == -2) {
                NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(byteBuf));
                byteBuf.skipBytes(byteBuf.readableBytes());
                this.setHandshakeFailure(channelHandlerContext, notSslRecordException);
                throw notSslRecordException;
            }
            assert (n7 > 0);
            if (n7 > n4) {
                this.packetLength = n7;
                return;
            }
        }
        this.packetLength = 0;
        try {
            n4 = this.unwrap(channelHandlerContext, byteBuf, byteBuf.readerIndex(), n7);
            assert (n4 == n7 || this.engine.isInboundDone()) : "we feed the SSLEngine a packets worth of data: " + n7 + " but it only consumed: " + n4;
            byteBuf.skipBytes(n4);
        }
        catch (Throwable throwable) {
            this.handleUnwrapThrowable(channelHandlerContext, throwable);
        }
    }

    private void decodeNonJdkCompatible(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        try {
            byteBuf.skipBytes(this.unwrap(channelHandlerContext, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes()));
        }
        catch (Throwable throwable) {
            this.handleUnwrapThrowable(channelHandlerContext, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnwrapThrowable(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        try {
            if (this.handshakePromise.tryFailure(throwable)) {
                channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
            }
            this.wrapAndFlush(channelHandlerContext);
        }
        catch (SSLException sSLException) {
            logger.debug("SSLException during trying to call SSLEngine.wrap(...) because of an previous SSLException, ignoring...", sSLException);
        }
        finally {
            this.setHandshakeFailure(channelHandlerContext, throwable, true, false, true);
        }
        PlatformDependent.throwException(throwable);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.processTask) {
            return;
        }
        if (this.jdkCompatibilityMode) {
            this.decodeJdkCompatible(channelHandlerContext, byteBuf);
        } else {
            this.decodeNonJdkCompatible(channelHandlerContext, byteBuf);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.channelReadComplete0(channelHandlerContext);
    }

    private void channelReadComplete0(ChannelHandlerContext channelHandlerContext) {
        this.discardSomeReadBytes();
        this.flushIfNeeded(channelHandlerContext);
        this.readIfNeeded(channelHandlerContext);
        this.firedChannelRead = false;
        channelHandlerContext.fireChannelReadComplete();
    }

    private void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!(channelHandlerContext.channel().config().isAutoRead() || this.firedChannelRead && this.handshakePromise.isDone())) {
            channelHandlerContext.read();
        }
    }

    private void flushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (this.needsFlush) {
            this.forceFlush(channelHandlerContext);
        }
    }

    private void unwrapNonAppData(ChannelHandlerContext channelHandlerContext) {
        this.unwrap(channelHandlerContext, Unpooled.EMPTY_BUFFER, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unwrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n4, int n7) {
        int n8 = n7;
        boolean bl3 = false;
        boolean bl4 = false;
        int n10 = -1;
        ByteBuf byteBuf2 = this.allocate(channelHandlerContext, n7);
        try {
            block14: while (!channelHandlerContext.isRemoved()) {
                SSLEngineResult sSLEngineResult = this.engineType.unwrap(this, byteBuf, n4, n7, byteBuf2);
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                int n11 = sSLEngineResult.bytesProduced();
                int n12 = sSLEngineResult.bytesConsumed();
                n4 += n12;
                n7 -= n12;
                switch (status) {
                    case BUFFER_OVERFLOW: {
                        int n13 = byteBuf2.readableBytes();
                        int n14 = n10;
                        n10 = n13;
                        int n15 = this.engine.getSession().getApplicationBufferSize() - n13;
                        if (n13 > 0) {
                            this.firedChannelRead = true;
                            channelHandlerContext.fireChannelRead(byteBuf2);
                            byteBuf2 = null;
                            if (n15 <= 0) {
                                n15 = this.engine.getSession().getApplicationBufferSize();
                            }
                        } else {
                            byteBuf2.release();
                            byteBuf2 = null;
                        }
                        if (n13 == 0 && n14 == 0) {
                            throw new IllegalStateException("Two consecutive overflows but no content was consumed. " + SSLSession.class.getSimpleName() + " getApplicationBufferSize: " + this.engine.getSession().getApplicationBufferSize() + " maybe too small.");
                        }
                        byteBuf2 = this.allocate(channelHandlerContext, this.engineType.calculatePendingData(this, n15));
                        continue block14;
                    }
                    case CLOSED: {
                        bl4 = true;
                        n10 = -1;
                        break;
                    }
                    default: {
                        n10 = -1;
                    }
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        break;
                    }
                    case NEED_WRAP: {
                        if (!this.wrapNonAppData(channelHandlerContext, true) || n7 != 0) break;
                        break block14;
                    }
                    case NEED_TASK: {
                        if (this.runDelegatedTasks(true)) break;
                        bl3 = false;
                        break block14;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        bl3 = true;
                        break;
                    }
                    case NOT_HANDSHAKING: {
                        if (this.setHandshakeSuccessIfStillHandshaking()) {
                            bl3 = true;
                            continue block14;
                        }
                        if (n7 != 0) break;
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException("unknown handshake status: " + (Object)((Object)handshakeStatus));
                    }
                }
                if (status != SSLEngineResult.Status.BUFFER_UNDERFLOW && (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || n12 != 0 || n11 != 0)) continue;
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                this.readIfNeeded(channelHandlerContext);
                break;
            }
            if (this.flushedBeforeHandshake && this.handshakePromise.isDone()) {
                this.flushedBeforeHandshake = false;
                bl3 = true;
            }
            if (bl3) {
                this.wrap(channelHandlerContext, true);
            }
            if (bl4) {
                this.notifyClosePromise(null);
            }
        }
        finally {
            if (byteBuf2 != null) {
                if (byteBuf2.isReadable()) {
                    this.firedChannelRead = true;
                    channelHandlerContext.fireChannelRead(byteBuf2);
                } else {
                    byteBuf2.release();
                }
            }
        }
        return n8 - n7;
    }

    private static ByteBuffer toByteBuffer(ByteBuf byteBuf, int n4, int n7) {
        return byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(n4, n7) : byteBuf.nioBuffer(n4, n7);
    }

    private static boolean inEventLoop(Executor executor) {
        return executor instanceof EventExecutor && ((EventExecutor)executor).inEventLoop();
    }

    private static void runAllDelegatedTasks(SSLEngine sSLEngine) {
        Runnable runnable;
        while ((runnable = sSLEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return;
    }

    private boolean runDelegatedTasks(boolean bl3) {
        if (this.delegatedTaskExecutor == ImmediateExecutor.INSTANCE || SslHandler.inEventLoop(this.delegatedTaskExecutor)) {
            SslHandler.runAllDelegatedTasks(this.engine);
            return true;
        }
        this.executeDelegatedTasks(bl3);
        return false;
    }

    private void executeDelegatedTasks(boolean bl3) {
        this.processTask = true;
        try {
            this.delegatedTaskExecutor.execute(new SslHandler$SslTasksRunner(this, bl3));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.processTask = false;
            throw rejectedExecutionException;
        }
    }

    private boolean setHandshakeSuccessIfStillHandshaking() {
        if (!this.handshakePromise.isDone()) {
            this.setHandshakeSuccess();
            return true;
        }
        return false;
    }

    private void setHandshakeSuccess() {
        this.handshakePromise.trySuccess(this.ctx.channel());
        if (logger.isDebugEnabled()) {
            logger.debug("{} HANDSHAKEN: {}", (Object)this.ctx.channel(), (Object)this.engine.getSession().getCipherSuite());
        }
        this.ctx.fireUserEventTriggered(SslHandshakeCompletionEvent.SUCCESS);
        if (this.readDuringHandshake && !this.ctx.channel().config().isAutoRead()) {
            this.readDuringHandshake = false;
            this.ctx.read();
        }
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.setHandshakeFailure(channelHandlerContext, throwable, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl3, boolean bl4, boolean bl5) {
        try {
            block7: {
                this.outboundClosed = true;
                this.engine.closeOutbound();
                if (bl3) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException sSLException) {
                        String string;
                        if (!logger.isDebugEnabled() || (string = sSLException.getMessage()) != null && (string.contains("possible truncation attack") || string.contains("closing inbound before receiving peer's close_notify"))) break block7;
                        logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)channelHandlerContext.channel(), (Object)sSLException);
                    }
                }
            }
            if (this.handshakePromise.tryFailure(throwable) || bl5) {
                SslUtils.handleHandshakeFailure(channelHandlerContext, throwable, bl4);
            }
        }
        finally {
            this.releaseAndFailAll(channelHandlerContext, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailureTransportFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        try {
            SSLException sSLException = new SSLException("failure when writing TLS control frames", throwable);
            this.releaseAndFailAll(channelHandlerContext, sSLException);
            if (this.handshakePromise.tryFailure(sSLException)) {
                channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(sSLException));
            }
        }
        finally {
            channelHandlerContext.close();
        }
    }

    private void releaseAndFailAll(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.releaseAndFailAll(channelHandlerContext, throwable);
        }
    }

    private void notifyClosePromise(Throwable throwable) {
        if (throwable == null) {
            if (this.sslClosePromise.trySuccess(this.ctx.channel())) {
                this.ctx.fireUserEventTriggered(SslCloseCompletionEvent.SUCCESS);
            }
        } else if (this.sslClosePromise.tryFailure(throwable)) {
            this.ctx.fireUserEventTriggered(new SslCloseCompletionEvent(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundAndChannel(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, boolean bl3) {
        block8: {
            block7: {
                this.outboundClosed = true;
                this.engine.closeOutbound();
                if (!channelHandlerContext.channel().isActive()) {
                    if (bl3) {
                        channelHandlerContext.disconnect(channelPromise);
                    } else {
                        channelHandlerContext.close(channelPromise);
                    }
                    return;
                }
                ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
                try {
                    this.flush(channelHandlerContext, channelPromise2);
                    if (this.closeNotify) break block7;
                    this.closeNotify = true;
                }
                catch (Throwable throwable) {
                    if (!this.closeNotify) {
                        this.closeNotify = true;
                        this.safeClose(channelHandlerContext, channelPromise2, channelHandlerContext.newPromise().addListener(new ChannelPromiseNotifier(false, channelPromise)));
                    } else {
                        this.sslClosePromise.addListener((GenericFutureListener)new SslHandler$3(this, channelPromise));
                    }
                    throw throwable;
                }
                this.safeClose(channelHandlerContext, channelPromise2, channelHandlerContext.newPromise().addListener(new ChannelPromiseNotifier(false, channelPromise)));
                break block8;
            }
            this.sslClosePromise.addListener((GenericFutureListener)new SslHandler$3(this, channelPromise));
        }
    }

    private void flush(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelPromise);
        } else {
            channelPromise.setFailure(SslHandler.newPendingWritesNullException());
        }
        this.flush(channelHandlerContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.pendingUnencryptedWrites = new SslHandler$SslHandlerCoalescingBufferQueue(this, channelHandlerContext.channel(), 16);
        if (channelHandlerContext.channel().isActive()) {
            this.startHandshakeProcessing();
        }
    }

    private void startHandshakeProcessing() {
        if (!this.handshakeStarted) {
            this.handshakeStarted = true;
            if (this.engine.getUseClientMode()) {
                this.handshake();
            }
            this.applyHandshakeTimeout();
        }
    }

    public Future<Channel> renegotiate() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        return this.renegotiate(channelHandlerContext.executor().newPromise());
    }

    public Future<Channel> renegotiate(Promise<Channel> promise) {
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (!eventExecutor.inEventLoop()) {
            eventExecutor.execute(new SslHandler$4(this, promise));
            return promise;
        }
        this.renegotiateOnEventLoop(promise);
        return promise;
    }

    private void renegotiateOnEventLoop(Promise<Channel> promise) {
        Promise<Channel> promise2 = this.handshakePromise;
        if (!promise2.isDone()) {
            promise2.addListener(new PromiseNotifier(promise));
        } else {
            this.handshakePromise = promise;
            this.handshake();
            this.applyHandshakeTimeout();
        }
    }

    private void handshake() {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return;
        }
        if (this.handshakePromise.isDone()) {
            return;
        }
        ChannelHandlerContext channelHandlerContext = this.ctx;
        try {
            this.engine.beginHandshake();
            this.wrapNonAppData(channelHandlerContext, false);
        }
        catch (Throwable throwable) {
            this.setHandshakeFailure(channelHandlerContext, throwable);
        }
        finally {
            this.forceFlush(channelHandlerContext);
        }
    }

    private void applyHandshakeTimeout() {
        Promise<Channel> promise = this.handshakePromise;
        long l2 = this.handshakeTimeoutMillis;
        if (l2 <= 0L || promise.isDone()) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = this.ctx.executor().schedule(new SslHandler$5(this, promise), l2, TimeUnit.MILLISECONDS);
        promise.addListener(new SslHandler$6(this, scheduledFuture));
    }

    private void forceFlush(ChannelHandlerContext channelHandlerContext) {
        this.needsFlush = false;
        channelHandlerContext.flush();
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (!this.startTls) {
            this.startHandshakeProcessing();
        }
        channelHandlerContext.fireChannelActive();
    }

    private void safeClose(ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        long l2;
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ScheduledFuture<?> scheduledFuture = !channelFuture.isDone() ? ((l2 = this.closeNotifyFlushTimeoutMillis) > 0L ? channelHandlerContext.executor().schedule(new SslHandler$7(this, channelFuture, channelHandlerContext, channelPromise), l2, TimeUnit.MILLISECONDS) : null) : null;
        channelFuture.addListener(new SslHandler$8(this, scheduledFuture, channelHandlerContext, channelPromise));
    }

    private static void addCloseListener(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        channelFuture.addListener(new ChannelPromiseNotifier(false, channelPromise));
    }

    private ByteBuf allocate(ChannelHandlerContext channelHandlerContext, int n4) {
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        if (this.engineType.wantsDirectBuffer) {
            return byteBufAllocator.directBuffer(n4);
        }
        return byteBufAllocator.buffer(n4);
    }

    private ByteBuf allocateOutNetBuf(ChannelHandlerContext channelHandlerContext, int n4, int n7) {
        return this.allocate(channelHandlerContext, this.engineType.calculateWrapBufferCapacity(this, n4, n7));
    }

    private static boolean attemptCopyToCumulation(ByteBuf byteBuf, ByteBuf byteBuf2, int n4) {
        int n7 = byteBuf2.readableBytes();
        int n8 = byteBuf.capacity();
        if (n4 - byteBuf.readableBytes() >= n7 && (byteBuf.isWritable(n7) && n8 >= n4 || n8 < n4 && ByteBufUtil.ensureWritableSuccess(byteBuf.ensureWritable(n7, false)))) {
            byteBuf.writeBytes(byteBuf2);
            byteBuf2.release();
            return true;
        }
        return false;
    }

    static /* synthetic */ SSLEngine access$100(SslHandler sslHandler) {
        return sslHandler.engine;
    }

    static /* synthetic */ ByteBuffer[] access$200(SslHandler sslHandler) {
        return sslHandler.singleBuffer;
    }

    static /* synthetic */ ByteBuffer access$300(ByteBuf byteBuf, int n4, int n7) {
        return SslHandler.toByteBuffer(byteBuf, n4, n7);
    }

    static /* synthetic */ void access$500(SslHandler sslHandler, ChannelPromise channelPromise) {
        sslHandler.closeOutbound0(channelPromise);
    }

    static /* synthetic */ void access$600(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        sslHandler.setHandshakeFailureTransportFailure(channelHandlerContext, throwable);
    }

    static /* synthetic */ ChannelHandlerContext access$700(SslHandler sslHandler) {
        return sslHandler.ctx;
    }

    static /* synthetic */ void access$800(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        sslHandler.handleUnwrapThrowable(channelHandlerContext, throwable);
    }

    static /* synthetic */ void access$900(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        sslHandler.setHandshakeFailure(channelHandlerContext, throwable);
    }

    static /* synthetic */ void access$1000(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext) {
        sslHandler.forceFlush(channelHandlerContext);
    }

    static /* synthetic */ void access$1100(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext) {
        sslHandler.channelReadComplete0(channelHandlerContext);
    }

    static /* synthetic */ boolean access$1202(SslHandler sslHandler, boolean bl3) {
        sslHandler.processTask = bl3;
        return sslHandler.processTask;
    }

    static /* synthetic */ void access$1300(SslHandler sslHandler, boolean bl3) {
        sslHandler.executeDelegatedTasks(bl3);
    }

    static /* synthetic */ void access$1400(SslHandler sslHandler) {
        sslHandler.setHandshakeSuccess();
    }

    static /* synthetic */ boolean access$1500(SslHandler sslHandler) {
        return sslHandler.setHandshakeSuccessIfStillHandshaking();
    }

    static /* synthetic */ void access$1600(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext, boolean bl3) {
        sslHandler.wrap(channelHandlerContext, bl3);
    }

    static /* synthetic */ void access$1700(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext) {
        sslHandler.unwrapNonAppData(channelHandlerContext);
    }

    static /* synthetic */ boolean access$1800(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext, boolean bl3) {
        return sslHandler.wrapNonAppData(channelHandlerContext, bl3);
    }

    static /* synthetic */ void access$1900(SSLEngine sSLEngine) {
        SslHandler.runAllDelegatedTasks(sSLEngine);
    }

    static /* synthetic */ void access$2200(SslHandler sslHandler, Promise promise) {
        sslHandler.renegotiateOnEventLoop(promise);
    }

    static /* synthetic */ void access$2300(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        sslHandler.releaseAndFailAll(channelHandlerContext, throwable);
    }

    static /* synthetic */ InternalLogger access$2400() {
        return logger;
    }

    static /* synthetic */ void access$2500(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        SslHandler.addCloseListener(channelFuture, channelPromise);
    }

    static /* synthetic */ long access$2600(SslHandler sslHandler) {
        return sslHandler.closeNotifyReadTimeoutMillis;
    }

    static /* synthetic */ SslHandler$LazyChannelPromise access$2700(SslHandler sslHandler) {
        return sslHandler.sslClosePromise;
    }

    static /* synthetic */ boolean access$2800(ByteBuf byteBuf, ByteBuf byteBuf2, int n4) {
        return SslHandler.attemptCopyToCumulation(byteBuf, byteBuf2, n4);
    }
}

