/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslEngineMap;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslServerSessionContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext$ExtendedTrustManagerVerifyCallback;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext$OpenSslServerCertificateCallback;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext$OpenSslSniHostnameMatcher;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext$TrustManagerVerifyCallback;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSLContext;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class ReferenceCountedOpenSslServerContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslServerContext.class);
    private static final byte[] ID = new byte[]{110, 101, 116, 116, 121};
    private final OpenSslServerSessionContext sessionContext;

    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l10, ClientAuth clientAuth, String[] stringArray, boolean bl3, boolean bl4, String string2) {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, ReferenceCountedOpenSslServerContext.toNegotiator(applicationProtocolConfig), l2, l10, clientAuth, stringArray, bl3, bl4, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l10, ClientAuth clientAuth, String[] stringArray, boolean bl3, boolean bl4, String string2) {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l2, l10, 1, (Certificate[])x509CertificateArray2, clientAuth, stringArray, bl3, bl4, true);
        boolean bl5 = false;
        try {
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2);
            bl5 = true;
        }
        finally {
            if (!bl5) {
                this.release();
            }
        }
    }

    @Override
    public OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OpenSslServerSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2) {
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object;
            Object object2;
            try {
                SSLContext.setVerify(l2, 0, 10);
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    ObjectUtil.checkNotNull(x509CertificateArray2, "keyCertChain");
                    ReferenceCountedOpenSslServerContext.setKeyMaterial(l2, x509CertificateArray2, privateKey, string);
                } else {
                    if (keyManagerFactory == null) {
                        object2 = ReferenceCountedOpenSslServerContext.keyStorePassword(string);
                        object = ReferenceCountedOpenSslServerContext.buildKeyStore(x509CertificateArray2, privateKey, object2, string2);
                        keyManagerFactory = object.aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init((KeyStore)object, (char[])object2);
                    }
                    openSslKeyMaterialProvider = ReferenceCountedOpenSslServerContext.providerFor(keyManagerFactory, string);
                    SSLContext.setCertificateCallback(l2, new ReferenceCountedOpenSslServerContext$OpenSslServerCertificateCallback(openSslEngineMap, new OpenSslKeyMaterialManager(openSslKeyMaterialProvider)));
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslServerContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object2 = ReferenceCountedOpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                if (ReferenceCountedOpenSslServerContext.useExtendedTrustManager((X509TrustManager)object2)) {
                    SSLContext.setCertVerifyCallback(l2, new ReferenceCountedOpenSslServerContext$ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)object2));
                } else {
                    SSLContext.setCertVerifyCallback(l2, new ReferenceCountedOpenSslServerContext$TrustManagerVerifyCallback(openSslEngineMap, (X509TrustManager)object2));
                }
                object = object2.getAcceptedIssuers();
                if (object != null && ((X509Certificate[])object).length > 0) {
                    long l10 = 0L;
                    try {
                        l10 = ReferenceCountedOpenSslServerContext.toBIO(ByteBufAllocator.DEFAULT, object);
                        if (!SSLContext.setCACertificateBio(l2, l10)) {
                            throw new SSLException("unable to setup accepted issuers for trustmanager " + object2);
                        }
                    }
                    finally {
                        ReferenceCountedOpenSslServerContext.freeBio(l10);
                    }
                }
                if (PlatformDependent.javaVersion() >= 8) {
                    SSLContext.setSniHostnameMatcher(l2, new ReferenceCountedOpenSslServerContext$OpenSslSniHostnameMatcher(openSslEngineMap));
                }
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("unable to setup trustmanager", exception);
            }
            object2 = new OpenSslServerSessionContext(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
            object2.setSessionIdContext(ID);
            openSslKeyMaterialProvider = null;
            object = object2;
            return object;
        }
        finally {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
        }
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }
}

