/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteConverter;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.Java7SslParametersUtils;
import io.grpc.netty.shaded.io.netty.handler.ssl.Java8SslUtils;
import io.grpc.netty.shaded.io.netty.handler.ssl.NotSslRecordException;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslEngineMap;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterial;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSession;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$1;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$2;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$3;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$DefaultOpenSslSession;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$HandshakeState;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;
import io.grpc.netty.shaded.io.netty.internal.tcnative.Buffer;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import io.grpc.netty.shaded.io.netty.util.AbstractReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetector;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetectorFactory;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakTracker;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

public class ReferenceCountedOpenSslEngine
extends SSLEngine
implements ApplicationProtocolAccessor,
ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslEngine.class);
    private static final ResourceLeakDetector<ReferenceCountedOpenSslEngine> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslEngine.class);
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV2 = 0;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV3 = 1;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1 = 2;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_1 = 3;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_2 = 4;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_3 = 5;
    private static final int[] OPENSSL_OP_NO_PROTOCOLS = new int[]{SSL.SSL_OP_NO_SSLv2, SSL.SSL_OP_NO_SSLv3, SSL.SSL_OP_NO_TLSv1, SSL.SSL_OP_NO_TLSv1_1, SSL.SSL_OP_NO_TLSv1_2, SSL.SSL_OP_NO_TLSv1_3};
    static final int MAX_PLAINTEXT_LENGTH = SSL.SSL_MAX_PLAINTEXT_LENGTH;
    private static final int MAX_RECORD_SIZE = SSL.SSL_MAX_RECORD_LENGTH;
    private static final AtomicIntegerFieldUpdater<ReferenceCountedOpenSslEngine> DESTROYED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ReferenceCountedOpenSslEngine.class, "destroyed");
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private long ssl;
    private long networkBIO;
    private ReferenceCountedOpenSslEngine$HandshakeState handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile int destroyed;
    private volatile String applicationProtocol;
    private volatile boolean needTask;
    private final ResourceLeakTracker<ReferenceCountedOpenSslEngine> leak;
    private final AbstractReferenceCounted refCnt = new ReferenceCountedOpenSslEngine$1(this);
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private volatile Certificate[] localCertificateChain;
    private volatile long lastAccessed = -1L;
    private String endPointIdentificationAlgorithm;
    private Object algorithmConstraints;
    private List<String> sniHostNames;
    private volatile Collection<?> matchers;
    private boolean isInboundDone;
    private boolean outboundClosed;
    final boolean jdkCompatibilityMode;
    private final boolean clientMode;
    final ByteBufAllocator alloc;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final OpenSslSession session;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final boolean enableOcsp;
    private int maxWrapOverhead;
    private int maxWrapBufferSize;
    private Throwable handshakeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslEngine(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, ByteBufAllocator byteBufAllocator, String string, int n4, boolean bl3, boolean bl4) {
        super(string, n4);
        long l2;
        OpenSsl.ensureAvailability();
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)referenceCountedOpenSslContext.applicationProtocolNegotiator();
        this.clientMode = referenceCountedOpenSslContext.isClient();
        this.session = PlatformDependent.javaVersion() >= 7 ? new ReferenceCountedOpenSslEngine$2(this, new ReferenceCountedOpenSslEngine$DefaultOpenSslSession(this, referenceCountedOpenSslContext.sessionContext())) : new ReferenceCountedOpenSslEngine$DefaultOpenSslSession(this, referenceCountedOpenSslContext.sessionContext());
        this.engineMap = referenceCountedOpenSslContext.engineMap;
        this.enableOcsp = referenceCountedOpenSslContext.enableOcsp;
        this.localCertificateChain = referenceCountedOpenSslContext.keyCertChain;
        this.jdkCompatibilityMode = bl3;
        Lock lock = referenceCountedOpenSslContext.ctxLock.readLock();
        lock.lock();
        try {
            l2 = SSL.newSSL(referenceCountedOpenSslContext.ctx, !referenceCountedOpenSslContext.isClient());
        }
        finally {
            lock.unlock();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            this.ssl = l2;
            try {
                this.networkBIO = SSL.bioNewByteBuffer(this.ssl, referenceCountedOpenSslContext.getBioNonApplicationBufferSize());
                this.setClientAuth(this.clientMode ? ClientAuth.NONE : referenceCountedOpenSslContext.clientAuth);
                if (referenceCountedOpenSslContext.protocols != null) {
                    this.setEnabledProtocols(referenceCountedOpenSslContext.protocols);
                }
                if (this.clientMode && SslUtils.isValidHostNameForSNI(string)) {
                    SSL.setTlsExtHostName(this.ssl, string);
                    this.sniHostNames = Collections.singletonList(string);
                }
                if (this.enableOcsp) {
                    SSL.enableOcsp(this.ssl);
                }
                if (!bl3) {
                    SSL.setMode(this.ssl, SSL.getMode(this.ssl) | SSL.SSL_MODE_ENABLE_PARTIAL_WRITE);
                }
                this.calculateMaxWrapOverhead();
            }
            catch (Throwable throwable) {
                this.shutdown();
                PlatformDependent.throwException(throwable);
            }
        }
        this.leak = bl4 ? leakDetector.track(this) : null;
    }

    final void setKeyMaterial(OpenSslKeyMaterial openSslKeyMaterial) {
        SSL.setKeyMaterial(this.ssl, openSslKeyMaterial.certificateChainAddress(), openSslKeyMaterial.privateKeyAddress());
        this.localCertificateChain = openSslKeyMaterial.certificateChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOcspResponse(byte[] byArray) {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (this.clientMode) {
            throw new IllegalStateException("Not a server SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            SSL.setOcspResponse(this.ssl, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getOcspResponse() {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (!this.clientMode) {
            throw new IllegalStateException("Not a client SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            return SSL.getOcspResponse(this.ssl);
        }
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted retain(int n4) {
        this.refCnt.retain(n4);
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public final boolean release(int n4) {
        return this.refCnt.release(n4);
    }

    @Override
    public final synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public final synchronized long sslPointer() {
        return this.ssl;
    }

    public final synchronized void shutdown() {
        if (DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            this.engineMap.remove(this.ssl);
            SSL.freeSSL(this.ssl);
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.outboundClosed = true;
            this.isInboundDone = true;
        }
        SSL.clearError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer byteBuffer, int n4) {
        int n7;
        int n8 = byteBuffer.position();
        int n10 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n7 = SSL.writeToSSL(this.ssl, ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n8, n4);
            if (n7 > 0) {
                byteBuffer.position(n8 + n7);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n4);
            try {
                byteBuffer.limit(n8 + n4);
                byteBuf.setBytes(0, byteBuffer);
                byteBuffer.limit(n10);
                n7 = SSL.writeToSSL(this.ssl, OpenSsl.memoryAddress(byteBuf), n4);
                if (n7 > 0) {
                    byteBuffer.position(n8 + n7);
                } else {
                    byteBuffer.position(n8);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n7;
    }

    private ByteBuf writeEncryptedData(ByteBuffer byteBuffer, int n4) {
        int n7 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            SSL.bioSetByteBuffer(this.networkBIO, ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n7, n4, false);
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n4);
            try {
                int n8 = byteBuffer.limit();
                byteBuffer.limit(n7 + n4);
                byteBuf.writeBytes(byteBuffer);
                byteBuffer.position(n7);
                byteBuffer.limit(n8);
                SSL.bioSetByteBuffer(this.networkBIO, OpenSsl.memoryAddress(byteBuf), n4, false);
                return byteBuf;
            }
            catch (Throwable throwable) {
                byteBuf.release();
                PlatformDependent.throwException(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer byteBuffer) {
        int n4;
        int n7 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            n4 = SSL.readFromSSL(this.ssl, ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n7, byteBuffer.limit() - n7);
            if (n4 > 0) {
                byteBuffer.position(n7 + n4);
            }
        } else {
            int n8 = byteBuffer.limit();
            int n10 = Math.min(this.maxEncryptedPacketLength0(), n8 - n7);
            ByteBuf byteBuf = this.alloc.directBuffer(n10);
            try {
                n4 = SSL.readFromSSL(this.ssl, OpenSsl.memoryAddress(byteBuf), n10);
                if (n4 > 0) {
                    byteBuffer.limit(n7 + n4);
                    byteBuf.getBytes(byteBuf.readerIndex(), byteBuffer);
                    byteBuffer.limit(n8);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n4;
    }

    final synchronized int maxWrapOverhead() {
        return this.maxWrapOverhead;
    }

    final synchronized int maxEncryptedPacketLength() {
        return this.maxEncryptedPacketLength0();
    }

    final int maxEncryptedPacketLength0() {
        return this.maxWrapOverhead + MAX_PLAINTEXT_LENGTH;
    }

    final int calculateMaxLengthForWrap(int n4, int n7) {
        return (int)Math.min((long)this.maxWrapBufferSize, (long)n4 + (long)this.maxWrapOverhead * (long)n7);
    }

    final synchronized int sslPending() {
        return this.sslPending0();
    }

    private void calculateMaxWrapOverhead() {
        this.maxWrapOverhead = SSL.getMaxWrapOverhead(this.ssl);
        this.maxWrapBufferSize = this.jdkCompatibilityMode ? this.maxEncryptedPacketLength0() : this.maxEncryptedPacketLength0() << 4;
    }

    private int sslPending0() {
        return this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED ? 0 : SSL.sslPending(this.ssl);
    }

    private boolean isBytesAvailableEnoughForWrap(int n4, int n7, int n8) {
        return (long)n4 - (long)this.maxWrapOverhead * (long)n8 >= (long)n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n4, int n7, ByteBuffer byteBuffer) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("srcs is null");
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (n4 >= byteBufferArray.length || n4 + n7 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n4 + ", length: " + n7 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isOutboundDone()) {
                return this.isInboundDone() || this.isDestroyed() ? CLOSED_NOT_HANDSHAKING : NEED_UNWRAP_CLOSED;
            }
            int n8 = 0;
            ByteBuf byteBuf = null;
            try {
                int n10;
                if (byteBuffer.isDirect()) {
                    SSL.bioSetByteBuffer(this.networkBIO, ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)byteBuffer.position(), byteBuffer.remaining(), true);
                } else {
                    byteBuf = this.alloc.directBuffer(byteBuffer.remaining());
                    SSL.bioSetByteBuffer(this.networkBIO, OpenSsl.memoryAddress(byteBuf), byteBuf.writableBytes(), true);
                }
                int n11 = SSL.bioLengthByteBuffer(this.networkBIO);
                if (this.outboundClosed) {
                    if (!this.isBytesAvailableEnoughForWrap(byteBuffer.remaining(), 2, 1)) {
                        SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
                        return sSLEngineResult;
                    }
                    n8 = SSL.bioFlushByteBuffer(this.networkBIO);
                    if (n8 <= 0) {
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
                        return sSLEngineResult;
                    }
                    if (!this.doSSLShutdown()) {
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, n8);
                        return sSLEngineResult;
                    }
                    n8 = n11 - SSL.bioLengthByteBuffer(this.networkBIO);
                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, n8);
                    return sSLEngineResult;
                }
                SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                    if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY) {
                        this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_IMPLICITLY;
                    }
                    n8 = SSL.bioFlushByteBuffer(this.networkBIO);
                    if (this.handshakeException != null) {
                        SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, n8);
                        return sSLEngineResult;
                    }
                    handshakeStatus = this.handshake();
                    n8 = n11 - SSL.bioLengthByteBuffer(this.networkBIO);
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        SSLEngineResult sSLEngineResult = this.newResult(handshakeStatus, 0, n8);
                        return sSLEngineResult;
                    }
                    if (n8 > 0) {
                        SSLEngineResult sSLEngineResult = this.newResult(this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? (n8 == n11 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : this.getHandshakeStatus(SSL.bioLengthNonApplication(this.networkBIO))) : SSLEngineResult.HandshakeStatus.FINISHED), 0, n8);
                        return sSLEngineResult;
                    }
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        SSLEngineResult sSLEngineResult = this.isOutboundDone() ? NEED_UNWRAP_CLOSED : NEED_UNWRAP_OK;
                        return sSLEngineResult;
                    }
                    if (this.outboundClosed) {
                        n8 = SSL.bioFlushByteBuffer(this.networkBIO);
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, 0, n8);
                        return sSLEngineResult;
                    }
                }
                int n12 = n4 + n7;
                if (this.jdkCompatibilityMode) {
                    n10 = 0;
                    for (int i3 = n4; i3 < n12; ++i3) {
                        ByteBuffer byteBuffer2 = byteBufferArray[i3];
                        if (byteBuffer2 == null) {
                            throw new IllegalArgumentException("srcs[" + i3 + "] is null");
                        }
                        if (n10 == MAX_PLAINTEXT_LENGTH || (n10 += byteBuffer2.remaining()) <= MAX_PLAINTEXT_LENGTH && n10 >= 0) continue;
                        n10 = MAX_PLAINTEXT_LENGTH;
                    }
                    if (!this.isBytesAvailableEnoughForWrap(byteBuffer.remaining(), n10, 1)) {
                        SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
                        return sSLEngineResult;
                    }
                }
                n10 = 0;
                n8 = SSL.bioFlushByteBuffer(this.networkBIO);
                while (n4 < n12) {
                    ByteBuffer byteBuffer3 = byteBufferArray[n4];
                    int n13 = byteBuffer3.remaining();
                    if (n13 != 0) {
                        int n14;
                        int n15;
                        if (this.jdkCompatibilityMode) {
                            n15 = this.writePlaintextData(byteBuffer3, Math.min(n13, MAX_PLAINTEXT_LENGTH - n10));
                        } else {
                            n14 = byteBuffer.remaining() - n8 - this.maxWrapOverhead;
                            if (n14 <= 0) {
                                SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), n10, n8);
                                return sSLEngineResult;
                            }
                            n15 = this.writePlaintextData(byteBuffer3, Math.min(n13, n14));
                        }
                        if (n15 > 0) {
                            n10 += n15;
                            n14 = SSL.bioLengthByteBuffer(this.networkBIO);
                            n11 = n14;
                            if (this.jdkCompatibilityMode || (n8 += n11 - n14) == byteBuffer.remaining()) {
                                SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n10, n8);
                                return sSLEngineResult;
                            }
                        } else {
                            n14 = SSL.getError(this.ssl, n15);
                            if (n14 == SSL.SSL_ERROR_ZERO_RETURN) {
                                if (!this.receivedShutdown) {
                                    this.closeAll();
                                    SSLEngineResult.HandshakeStatus handshakeStatus2 = this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? ((n8 += n11 - SSL.bioLengthByteBuffer(this.networkBIO)) == byteBuffer.remaining() ? SSLEngineResult.HandshakeStatus.NEED_WRAP : this.getHandshakeStatus(SSL.bioLengthNonApplication(this.networkBIO))) : SSLEngineResult.HandshakeStatus.FINISHED);
                                    SSLEngineResult sSLEngineResult = this.newResult(handshakeStatus2, n10, n8);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, n10, n8);
                                return sSLEngineResult;
                            }
                            if (n14 == SSL.SSL_ERROR_WANT_READ) {
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_UNWRAP, n10, n8);
                                return sSLEngineResult;
                            }
                            if (n14 == SSL.SSL_ERROR_WANT_WRITE) {
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, n10, n8);
                                return sSLEngineResult;
                            }
                            if (n14 != SSL.SSL_ERROR_WANT_X509_LOOKUP && n14 != SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY && n14 != SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                                throw this.shutdownWithError("SSL_write", n14);
                            }
                            SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_TASK, n10, n8);
                            return sSLEngineResult;
                        }
                    }
                    ++n4;
                }
                SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n10, n8);
                return sSLEngineResult;
            }
            finally {
                SSL.bioClearByteBuffer(this.networkBIO);
                if (byteBuf == null) {
                    byteBuffer.position(byteBuffer.position() + n8);
                } else {
                    assert (byteBuf.readableBytes() <= byteBuffer.remaining()) : "The destination buffer " + byteBuffer + " didn't have enough remaining space to hold the encrypted content in " + byteBuf;
                    byteBuffer.put(byteBuf.internalNioBuffer(byteBuf.readerIndex(), n8));
                    byteBuf.release();
                }
            }
        }
    }

    private SSLEngineResult newResult(SSLEngineResult.HandshakeStatus handshakeStatus, int n4, int n7) {
        return this.newResult(SSLEngineResult.Status.OK, handshakeStatus, n4, n7);
    }

    private SSLEngineResult newResult(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n4, int n7) {
        if (this.isOutboundDone()) {
            if (this.isInboundDone()) {
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                this.shutdown();
            }
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, handshakeStatus, n4, n7);
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.needTask = true;
        }
        return new SSLEngineResult(status, handshakeStatus, n4, n7);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n4, int n7) {
        return this.newResult(this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED), n4, n7);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n4, int n7) {
        return this.newResult(status, this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED), n4, n7);
    }

    private SSLException shutdownWithError(String string, int n4) {
        return this.shutdownWithError(string, n4, SSL.getLastErrorNumber());
    }

    private SSLException shutdownWithError(String string, int n4, int n7) {
        String string2 = SSL.getErrorString(n7);
        if (logger.isDebugEnabled()) {
            logger.debug("{} failed with {}: OpenSSL error: {} {}", string, n4, n7, string2);
        }
        this.shutdown();
        if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return new SSLException(string2);
        }
        SSLHandshakeException sSLHandshakeException = new SSLHandshakeException(string2);
        if (this.handshakeException != null) {
            sSLHandshakeException.initCause(this.handshakeException);
            this.handshakeException = null;
        }
        return sSLHandshakeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, int n4, int n7, ByteBuffer[] byteBufferArray2, int n8, int n10) {
        Object object;
        int n11;
        ByteBuffer byteBuffer;
        if (byteBufferArray == null) {
            throw new NullPointerException("srcs");
        }
        if (n4 >= byteBufferArray.length || n4 + n7 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n4 + ", length: " + n7 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBufferArray2 == null) {
            throw new IllegalArgumentException("dsts is null");
        }
        if (n8 >= byteBufferArray2.length || n8 + n10 > byteBufferArray2.length) {
            throw new IndexOutOfBoundsException("offset: " + n8 + ", length: " + n10 + " (expected: offset <= offset + length <= dsts.length (" + byteBufferArray2.length + "))");
        }
        long l2 = 0L;
        int n12 = n8 + n10;
        for (n11 = n8; n11 < n12; l2 += (long)byteBuffer.remaining(), ++n11) {
            byteBuffer = byteBufferArray2[n11];
            if (byteBuffer == null) {
                throw new IllegalArgumentException("dsts[" + n11 + "] is null");
            }
            if (!byteBuffer.isReadOnly()) continue;
            throw new ReadOnlyBufferException();
        }
        n11 = n4 + n7;
        long l10 = 0L;
        for (int i3 = n4; i3 < n11; l10 += (long)object.remaining(), ++i3) {
            object = byteBufferArray[i3];
            if (object != null) continue;
            throw new IllegalArgumentException("srcs[" + i3 + "] is null");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            int n13;
            int n14;
            block54: {
                int n15;
                if (this.isInboundDone()) {
                    return this.isOutboundDone() || this.isDestroyed() ? CLOSED_NOT_HANDSHAKING : NEED_WRAP_CLOSED;
                }
                object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                    if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY) {
                        this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_IMPLICITLY;
                    }
                    if ((object = this.handshake()) == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        return this.newResult((SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (object == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        return NEED_WRAP_OK;
                    }
                    if (this.isInboundDone) {
                        return NEED_WRAP_CLOSED;
                    }
                }
                int n16 = this.sslPending0();
                if (this.jdkCompatibilityMode) {
                    if (l10 < 5L) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    n15 = SslUtils.getEncryptedPacketLength(byteBufferArray, n4);
                    if (n15 == -2) {
                        throw new NotSslRecordException("not an SSL/TLS record");
                    }
                    n14 = n15 - 5;
                    if ((long)n14 > l2) {
                        if (n14 > MAX_RECORD_SIZE) {
                            throw new SSLException("Illegal packet length: " + n14 + " > " + this.session.getApplicationBufferSize());
                        }
                        this.session.tryExpandApplicationBufferSize(n14);
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (l10 < (long)n15) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                } else {
                    if (l10 == 0L && n16 <= 0) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (l2 == 0L) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    n15 = (int)Math.min(Integer.MAX_VALUE, l10);
                }
                assert (n4 < n11);
                assert (l2 > 0L);
                n14 = 0;
                n13 = 0;
                try {
                    while (true) {
                        int n17;
                        ByteBuf byteBuf;
                        ByteBuffer byteBuffer2;
                        int n18;
                        if ((n18 = (byteBuffer2 = byteBufferArray[n4]).remaining()) == 0) {
                            if (n16 <= 0) {
                                if (++n4 < n11) continue;
                                break;
                            }
                            byteBuf = null;
                            n17 = SSL.bioLengthByteBuffer(this.networkBIO);
                        } else {
                            n17 = Math.min(n15, n18);
                            byteBuf = this.writeEncryptedData(byteBuffer2, n17);
                        }
                        try {
                            int n19;
                            block55: {
                                while (true) {
                                    ByteBuffer byteBuffer3;
                                    if (!(byteBuffer3 = byteBufferArray2[n8]).hasRemaining()) {
                                        if (++n8 < n12) continue;
                                        break block54;
                                    }
                                    n19 = this.readPlaintextData(byteBuffer3);
                                    int n20 = n17 - SSL.bioLengthByteBuffer(this.networkBIO);
                                    n13 += n20;
                                    n15 -= n20;
                                    n17 -= n20;
                                    byteBuffer2.position(byteBuffer2.position() + n20);
                                    if (n19 <= 0) break block55;
                                    n14 += n19;
                                    if (!byteBuffer3.hasRemaining()) {
                                        n16 = this.sslPending0();
                                        if (++n8 < n12) continue;
                                        SSLEngineResult sSLEngineResult = n16 > 0 ? this.newResult(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), n13, n14) : this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n13, n14);
                                        return sSLEngineResult;
                                    }
                                    if (n15 == 0 || this.jdkCompatibilityMode) break;
                                }
                                break;
                            }
                            int n21 = SSL.getError(this.ssl, n19);
                            if (n21 != SSL.SSL_ERROR_WANT_READ && n21 != SSL.SSL_ERROR_WANT_WRITE) {
                                if (n21 == SSL.SSL_ERROR_ZERO_RETURN) {
                                    if (!this.receivedShutdown) {
                                        this.closeAll();
                                    }
                                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n13, n14);
                                    return sSLEngineResult;
                                }
                                if (n21 == SSL.SSL_ERROR_WANT_X509_LOOKUP || n21 == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || n21 == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                                    SSLEngineResult sSLEngineResult = this.newResult(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_TASK, n13, n14);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.sslReadErrorResult(n21, SSL.getLastErrorNumber(), n13, n14);
                                return sSLEngineResult;
                            }
                            if (++n4 < n11) continue;
                        }
                        finally {
                            if (byteBuf == null) continue;
                            byteBuf.release();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    SSL.bioClearByteBuffer(this.networkBIO);
                    this.rejectRemoteInitiatedRenegotiation();
                }
            }
            if (!this.receivedShutdown && (SSL.getShutdown(this.ssl) & SSL.SSL_RECEIVED_SHUTDOWN) == SSL.SSL_RECEIVED_SHUTDOWN) {
                this.closeAll();
            }
            return this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n13, n14);
        }
    }

    private SSLEngineResult sslReadErrorResult(int n4, int n7, int n8, int n10) {
        if (SSL.bioLengthNonApplication(this.networkBIO) > 0) {
            if (this.handshakeException == null && this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                this.handshakeException = new SSLHandshakeException(SSL.getErrorString(n7));
            }
            SSL.clearError();
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n8, n10);
        }
        throw this.shutdownWithError("SSL_read", n4, n7);
    }

    private void closeAll() {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegotiation() {
        if (!this.isDestroyed() && SSL.getHandshakeCount(this.ssl) > 1 && !"TLSv1.3".equals(this.session.getProtocol()) && this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotiation not allowed");
        }
    }

    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
        return this.unwrap(byteBufferArray, 0, byteBufferArray.length, byteBufferArray2, 0, byteBufferArray2.length);
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer byteBuffer) {
        this.singleSrcBuffer[0] = byteBuffer;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer byteBuffer) {
        this.singleDstBuffer[0] = byteBuffer;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n4, int n7) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), 0, 1, byteBufferArray, n4, n7);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            SSLEngineResult sSLEngineResult = this.wrap(this.singleSrcBuffer(byteBuffer), byteBuffer2);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), this.singleDstBuffer(byteBuffer2));
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), byteBufferArray);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    @Override
    public final synchronized Runnable getDelegatedTask() {
        if (this.isDestroyed()) {
            return null;
        }
        Runnable runnable = SSL.getTask(this.ssl);
        if (runnable == null) {
            return null;
        }
        return new ReferenceCountedOpenSslEngine$3(this, runnable);
    }

    @Override
    public final synchronized void closeInbound() {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        if (this.isOutboundDone()) {
            this.shutdown();
        }
        if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public final synchronized boolean isInboundDone() {
        return this.isInboundDone;
    }

    @Override
    public final synchronized void closeOutbound() {
        if (this.outboundClosed) {
            return;
        }
        this.outboundClosed = true;
        if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.isDestroyed()) {
            int n4 = SSL.getShutdown(this.ssl);
            if ((n4 & SSL.SSL_SENT_SHUTDOWN) != SSL.SSL_SENT_SHUTDOWN) {
                this.doSSLShutdown();
            }
        } else {
            this.shutdown();
        }
    }

    private boolean doSSLShutdown() {
        if (SSL.isInInit(this.ssl) != 0) {
            return false;
        }
        int n4 = SSL.shutdownSSL(this.ssl);
        if (n4 < 0) {
            int n7 = SSL.getError(this.ssl, n4);
            if (n7 == SSL.SSL_ERROR_SYSCALL || n7 == SSL.SSL_ERROR_SSL) {
                if (logger.isDebugEnabled()) {
                    int n8 = SSL.getLastErrorNumber();
                    logger.debug("SSL_shutdown failed: OpenSSL error: {} {}", (Object)n8, (Object)SSL.getErrorString(n8));
                }
                this.shutdown();
                return false;
            }
            SSL.clearError();
        }
        return true;
    }

    @Override
    public final synchronized boolean isOutboundDone() {
        return this.outboundClosed && (this.networkBIO == 0L || SSL.bioLengthNonApplication(this.networkBIO) == 0);
    }

    @Override
    public final String[] getSupportedCipherSuites() {
        return OpenSsl.AVAILABLE_CIPHER_SUITES.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getEnabledCipherSuites() {
        String[] stringArray;
        Object object = this;
        synchronized (object) {
            if (this.isDestroyed()) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            stringArray = SSL.getCiphers(this.ssl);
        }
        if (stringArray == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        object = new ArrayList();
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                String string;
                String string2 = this.toJavaCipherSuite(stringArray[i3]);
                String string3 = string = string2 == null ? stringArray[i3] : string2;
                if (!OpenSsl.isTlsv13Supported() && SslUtils.isTLSv13Cipher(string)) continue;
                object.add(string);
            }
        }
        return object.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void setEnabledCipherSuites(String[] stringArray) {
        ObjectUtil.checkNotNull(stringArray, "cipherSuites");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        CipherSuiteConverter.convertToCipherStrings(Arrays.asList(stringArray), stringBuilder, stringBuilder2, OpenSsl.isBoringSSL());
        String string = stringBuilder.toString();
        String string2 = stringBuilder2.toString();
        if (!OpenSsl.isTlsv13Supported() && !string2.isEmpty()) {
            throw new IllegalArgumentException("TLSv1.3 is not supported by this java version.");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) throw new IllegalStateException("failed to enable cipher suites: " + string);
            try {
                SSL.setCipherSuites(this.ssl, string, false);
                if (!OpenSsl.isTlsv13Supported()) return;
                SSL.setCipherSuites(this.ssl, string2, true);
            }
            catch (Exception exception) {
                throw new IllegalStateException("failed to enable cipher suites: " + string, exception);
            }
            return;
        }
    }

    @Override
    public final String[] getSupportedProtocols() {
        return OpenSsl.SUPPORTED_PROTOCOLS_SET.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getEnabledProtocols() {
        int n4;
        ArrayList<String> arrayList = new ArrayList<String>(6);
        arrayList.add("SSLv2Hello");
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return arrayList.toArray(new String[0]);
            }
            n4 = SSL.getOptions(this.ssl);
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n4, SSL.SSL_OP_NO_TLSv1, "TLSv1")) {
            arrayList.add("TLSv1");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n4, SSL.SSL_OP_NO_TLSv1_1, "TLSv1.1")) {
            arrayList.add("TLSv1.1");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n4, SSL.SSL_OP_NO_TLSv1_2, "TLSv1.2")) {
            arrayList.add("TLSv1.2");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n4, SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
            arrayList.add("TLSv1.3");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n4, SSL.SSL_OP_NO_SSLv2, "SSLv2")) {
            arrayList.add("SSLv2");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n4, SSL.SSL_OP_NO_SSLv3, "SSLv3")) {
            arrayList.add("SSLv3");
        }
        return arrayList.toArray(new String[0]);
    }

    private static boolean isProtocolEnabled(int n4, int n7, String string) {
        return (n4 & n7) == 0 && OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        int n4 = OPENSSL_OP_NO_PROTOCOLS.length;
        int n7 = 0;
        for (String string : stringArray) {
            if (!OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string)) {
                throw new IllegalArgumentException("Protocol " + string + " is not supported.");
            }
            if (string.equals("SSLv2")) {
                if (n4 > 0) {
                    n4 = 0;
                }
                if (n7 >= 0) continue;
                n7 = 0;
                continue;
            }
            if (string.equals("SSLv3")) {
                if (n4 > 1) {
                    n4 = 1;
                }
                if (n7 >= 1) continue;
                n7 = 1;
                continue;
            }
            if (string.equals("TLSv1")) {
                if (n4 > 2) {
                    n4 = 2;
                }
                if (n7 >= 2) continue;
                n7 = 2;
                continue;
            }
            if (string.equals("TLSv1.1")) {
                if (n4 > 3) {
                    n4 = 3;
                }
                if (n7 >= 3) continue;
                n7 = 3;
                continue;
            }
            if (string.equals("TLSv1.2")) {
                if (n4 > 4) {
                    n4 = 4;
                }
                if (n7 >= 4) continue;
                n7 = 4;
                continue;
            }
            if (!string.equals("TLSv1.3")) continue;
            if (n4 > 5) {
                n4 = 5;
            }
            if (n7 >= 5) continue;
            n7 = 5;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            int n8;
            if (!this.isDestroyed()) {
                int n10;
                SSL.clearOptions(this.ssl, SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2 | SSL.SSL_OP_NO_TLSv1_3);
                n8 = 0;
                for (n10 = 0; n10 < n4; ++n10) {
                    n8 |= OPENSSL_OP_NO_PROTOCOLS[n10];
                }
                assert (n7 != Integer.MAX_VALUE);
                for (n10 = n7 + 1; n10 < OPENSSL_OP_NO_PROTOCOLS.length; ++n10) {
                    n8 |= OPENSSL_OP_NO_PROTOCOLS[n10];
                }
            } else {
                throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(stringArray));
            }
            SSL.setOptions(this.ssl, n8);
        }
    }

    @Override
    public final SSLSession getSession() {
        return this.session;
    }

    @Override
    public final synchronized void beginHandshake() {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed();
                this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY;
                this.calculateMaxWrapOverhead();
                break;
            }
            case STARTED_EXPLICITLY: {
                break;
            }
            case FINISHED: {
                throw new SSLException("renegotiation unsupported");
            }
            case NOT_STARTED: {
                this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY;
                if (this.handshake() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.needTask = true;
                }
                this.calculateMaxWrapOverhead();
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void checkEngineClosed() {
        if (this.isDestroyed()) {
            throw new SSLException("engine closed");
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int n4) {
        return n4 > 0 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    private SSLEngineResult.HandshakeStatus handshakeException() {
        if (SSL.bioLengthNonApplication(this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        Throwable throwable = this.handshakeException;
        assert (throwable != null);
        this.handshakeException = null;
        this.shutdown();
        if (throwable instanceof SSLHandshakeException) {
            throw (SSLHandshakeException)throwable;
        }
        SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
        sSLHandshakeException.initCause(throwable);
        throw sSLHandshakeException;
    }

    final void initHandshakeException(Throwable throwable) {
        assert (this.handshakeException == null);
        this.handshakeException = throwable;
    }

    private SSLEngineResult.HandshakeStatus handshake() {
        int n4;
        if (this.needTask) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed();
        if (this.handshakeException != null) {
            return this.handshakeException();
        }
        this.engineMap.add(this);
        if (this.lastAccessed == -1L) {
            this.lastAccessed = System.currentTimeMillis();
        }
        if ((n4 = SSL.doHandshake(this.ssl)) <= 0) {
            int n7 = SSL.getError(this.ssl, n4);
            if (n7 == SSL.SSL_ERROR_WANT_READ || n7 == SSL.SSL_ERROR_WANT_WRITE) {
                return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication(this.networkBIO));
            }
            if (n7 == SSL.SSL_ERROR_WANT_X509_LOOKUP || n7 == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || n7 == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            if (this.handshakeException != null) {
                return this.handshakeException();
            }
            throw this.shutdownWithError("SSL_do_handshake", n7);
        }
        if (SSL.bioLengthNonApplication(this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        this.session.handshakeFinished();
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return this.handshake();
        }
        return handshakeStatus;
    }

    @Override
    public final synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication(this.networkBIO));
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int n4) {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(n4);
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.isDestroyed() && (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED || this.isInboundDone() || this.isOutboundDone());
    }

    private String toJavaCipherSuite(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SSL.getVersion(this.ssl);
        String string3 = ReferenceCountedOpenSslEngine.toJavaCipherSuitePrefix(string2);
        return CipherSuiteConverter.toJava(string, string3);
    }

    private static String toJavaCipherSuitePrefix(String string) {
        int n4 = string == null || string.isEmpty() ? 0 : (int)string.charAt(0);
        switch (n4) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public final void setUseClientMode(boolean bl3) {
        if (bl3 != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public final void setNeedClientAuth(boolean bl3) {
        this.setClientAuth(bl3 ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    @Override
    public final boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    @Override
    public final void setWantClientAuth(boolean bl3) {
        this.setClientAuth(bl3 ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    @Override
    public final boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    public final synchronized void setVerify(int n4, int n7) {
        SSL.setVerify(this.ssl, n4, n7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuth clientAuth) {
        if (this.clientMode) {
            return;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.clientAuth == clientAuth) {
                return;
            }
            switch (clientAuth) {
                case NONE: {
                    SSL.setVerify(this.ssl, 0, 10);
                    break;
                }
                case REQUIRE: {
                    SSL.setVerify(this.ssl, 2, 10);
                    break;
                }
                case OPTIONAL: {
                    SSL.setVerify(this.ssl, 1, 10);
                    break;
                }
                default: {
                    throw new Error(clientAuth.toString());
                }
            }
            this.clientAuth = clientAuth;
        }
    }

    @Override
    public final void setEnableSessionCreation(boolean bl3) {
        if (bl3) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    public final synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        int n4 = PlatformDependent.javaVersion();
        if (n4 >= 7) {
            sSLParameters.setEndpointIdentificationAlgorithm(this.endPointIdentificationAlgorithm);
            Java7SslParametersUtils.setAlgorithmConstraints(sSLParameters, this.algorithmConstraints);
            if (n4 >= 8) {
                if (this.sniHostNames != null) {
                    Java8SslUtils.setSniHostNames(sSLParameters, this.sniHostNames);
                }
                if (!this.isDestroyed()) {
                    Java8SslUtils.setUseCipherSuitesOrder(sSLParameters, (SSL.getOptions(this.ssl) & SSL.SSL_OP_CIPHER_SERVER_PREFERENCE) != 0);
                }
                Java8SslUtils.setSNIMatchers(sSLParameters, this.matchers);
            }
        }
        return sSLParameters;
    }

    @Override
    public final synchronized void setSSLParameters(SSLParameters sSLParameters) {
        int n4 = PlatformDependent.javaVersion();
        if (n4 >= 7) {
            Object object;
            if (sSLParameters.getAlgorithmConstraints() != null) {
                throw new IllegalArgumentException("AlgorithmConstraints are not supported.");
            }
            if (n4 >= 8) {
                if (!this.isDestroyed()) {
                    if (this.clientMode) {
                        object = Java8SslUtils.getSniHostNames(sSLParameters);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            SSL.setTlsExtHostName(this.ssl, string);
                        }
                        this.sniHostNames = object;
                    }
                    if (Java8SslUtils.getUseCipherSuitesOrder(sSLParameters)) {
                        SSL.setOptions(this.ssl, SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    } else {
                        SSL.clearOptions(this.ssl, SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    }
                }
                this.matchers = sSLParameters.getSNIMatchers();
            }
            object = sSLParameters.getEndpointIdentificationAlgorithm();
            boolean bl3 = ReferenceCountedOpenSslEngine.isEndPointVerificationEnabled((String)object);
            if (this.clientMode && bl3) {
                SSL.setVerify(this.ssl, 2, -1);
            }
            this.endPointIdentificationAlgorithm = object;
            this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
        }
        super.setSSLParameters(sSLParameters);
    }

    private static boolean isEndPointVerificationEnabled(String string) {
        return string != null && !string.isEmpty();
    }

    private boolean isDestroyed() {
        return this.destroyed != 0;
    }

    final boolean checkSniHostnameMatch(byte[] byArray) {
        return Java8SslUtils.checkSniHostnameMatch(this.matchers, byArray);
    }

    @Override
    public String getNegotiatedApplicationProtocol() {
        return this.applicationProtocol;
    }

    private static long bufferAddress(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.directBufferAddress(byteBuffer);
        }
        return Buffer.address(byteBuffer);
    }

    static /* synthetic */ ResourceLeakTracker access$000(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.leak;
    }

    static /* synthetic */ boolean access$100(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.clientMode;
    }

    static /* synthetic */ List access$200(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.sniHostNames;
    }

    static /* synthetic */ boolean access$300(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.isDestroyed();
    }

    static /* synthetic */ long access$400(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.ssl;
    }

    static /* synthetic */ boolean access$500(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.enableOcsp;
    }

    static /* synthetic */ boolean access$602(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, boolean bl3) {
        referenceCountedOpenSslEngine.needTask = bl3;
        return referenceCountedOpenSslEngine.needTask;
    }

    static /* synthetic */ OpenSslSession access$700(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.session;
    }

    static /* synthetic */ long access$800(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.lastAccessed;
    }

    static /* synthetic */ String access$900(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        return referenceCountedOpenSslEngine.toJavaCipherSuite(string);
    }

    static /* synthetic */ void access$1000(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        referenceCountedOpenSslEngine.calculateMaxWrapOverhead();
    }

    static /* synthetic */ ReferenceCountedOpenSslEngine$HandshakeState access$1102(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, ReferenceCountedOpenSslEngine$HandshakeState referenceCountedOpenSslEngine$HandshakeState) {
        referenceCountedOpenSslEngine.handshakeState = referenceCountedOpenSslEngine$HandshakeState;
        return referenceCountedOpenSslEngine.handshakeState;
    }

    static /* synthetic */ boolean access$1200(Object[] objectArray) {
        return ReferenceCountedOpenSslEngine.isEmpty(objectArray);
    }

    static /* synthetic */ boolean access$1300(byte[] byArray) {
        return ReferenceCountedOpenSslEngine.isEmpty(byArray);
    }

    static /* synthetic */ OpenSslApplicationProtocolNegotiator access$1400(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.apn;
    }

    static /* synthetic */ String access$1502(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        referenceCountedOpenSslEngine.applicationProtocol = string;
        return referenceCountedOpenSslEngine.applicationProtocol;
    }

    static /* synthetic */ Certificate[] access$1600(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.localCertificateChain;
    }

    static /* synthetic */ int access$1700() {
        return MAX_RECORD_SIZE;
    }
}

