/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig$SelectedListenerFailureBehavior;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslJavaxX509Certificate;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSession;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslX509Certificate;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$HandshakeState;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

final class ReferenceCountedOpenSslEngine$DefaultOpenSslSession
implements OpenSslSession {
    private final OpenSslSessionContext sessionContext;
    private X509Certificate[] x509PeerCerts;
    private Certificate[] peerCerts;
    private String protocol;
    private String cipher;
    private byte[] id;
    private long creationTime;
    private volatile int applicationBufferSize = ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH;
    private Map<String, Object> values;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ ReferenceCountedOpenSslEngine this$0;

    ReferenceCountedOpenSslEngine$DefaultOpenSslSession(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, OpenSslSessionContext openSslSessionContext) {
        this.this$0 = referenceCountedOpenSslEngine;
        this.sessionContext = openSslSessionContext;
    }

    private SSLSessionBindingEvent newSSLSessionBindingEvent(String string) {
        return new SSLSessionBindingEvent(ReferenceCountedOpenSslEngine.access$700(this.this$0), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getId() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.id == null) {
                return EmptyArrays.EMPTY_BYTES;
            }
            return (byte[])this.id.clone();
        }
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCreationTime() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.creationTime == 0L && !ReferenceCountedOpenSslEngine.access$300(this.this$0)) {
                this.creationTime = SSL.getTime(ReferenceCountedOpenSslEngine.access$400(this.this$0)) * 1000L;
            }
        }
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        long l2 = ReferenceCountedOpenSslEngine.access$800(this.this$0);
        return l2 == -1L ? this.getCreationTime() : l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (!ReferenceCountedOpenSslEngine.access$300(this.this$0)) {
                SSL.setTimeout(ReferenceCountedOpenSslEngine.access$400(this.this$0), 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (!ReferenceCountedOpenSslEngine.access$300(this.this$0)) {
                return System.currentTimeMillis() - SSL.getTimeout(ReferenceCountedOpenSslEngine.access$400(this.this$0)) * 1000L < SSL.getTime(ReferenceCountedOpenSslEngine.access$400(this.this$0)) * 1000L;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putValue(String string, Object object) {
        Object object2;
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (object == null) {
            throw new NullPointerException("value");
        }
        ReferenceCountedOpenSslEngine$DefaultOpenSslSession referenceCountedOpenSslEngine$DefaultOpenSslSession = this;
        synchronized (referenceCountedOpenSslEngine$DefaultOpenSslSession) {
            Map<String, Object> map = this.values;
            if (map == null) {
                map = this.values = new HashMap<String, Object>(2);
            }
            object2 = map.put(string, object);
        }
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueBound(this.newSSLSessionBindingEvent(string));
        }
        this.notifyUnbound(object2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        ReferenceCountedOpenSslEngine$DefaultOpenSslSession referenceCountedOpenSslEngine$DefaultOpenSslSession = this;
        synchronized (referenceCountedOpenSslEngine$DefaultOpenSslSession) {
            if (this.values == null) {
                return null;
            }
            return this.values.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValue(String string) {
        Object object;
        if (string == null) {
            throw new NullPointerException("name");
        }
        ReferenceCountedOpenSslEngine$DefaultOpenSslSession referenceCountedOpenSslEngine$DefaultOpenSslSession = this;
        synchronized (referenceCountedOpenSslEngine$DefaultOpenSslSession) {
            Map<String, Object> map = this.values;
            if (map == null) {
                return;
            }
            object = map.remove(string);
        }
        this.notifyUnbound(object, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getValueNames() {
        ReferenceCountedOpenSslEngine$DefaultOpenSslSession referenceCountedOpenSslEngine$DefaultOpenSslSession = this;
        synchronized (referenceCountedOpenSslEngine$DefaultOpenSslSession) {
            Map<String, Object> map = this.values;
            if (map == null || map.isEmpty()) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            return map.keySet().toArray(new String[0]);
        }
    }

    private void notifyUnbound(Object object, String string) {
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueUnbound(this.newSSLSessionBindingEvent(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeFinished() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (ReferenceCountedOpenSslEngine.access$300(this.this$0)) {
                throw new SSLException("Already closed");
            }
            this.id = SSL.getSessionId(ReferenceCountedOpenSslEngine.access$400(this.this$0));
            this.cipher = ReferenceCountedOpenSslEngine.access$900(this.this$0, SSL.getCipherForSSL(ReferenceCountedOpenSslEngine.access$400(this.this$0)));
            this.protocol = SSL.getVersion(ReferenceCountedOpenSslEngine.access$400(this.this$0));
            this.initPeerCerts();
            this.selectApplicationProtocol();
            ReferenceCountedOpenSslEngine.access$1000(this.this$0);
            ReferenceCountedOpenSslEngine.access$1102(this.this$0, ReferenceCountedOpenSslEngine$HandshakeState.FINISHED);
        }
    }

    private void initPeerCerts() {
        byte[][] byArray = SSL.getPeerCertChain(ReferenceCountedOpenSslEngine.access$400(this.this$0));
        if (ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
            if (ReferenceCountedOpenSslEngine.access$1200((Object[])byArray)) {
                this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
            } else {
                this.peerCerts = new Certificate[byArray.length];
                this.x509PeerCerts = new X509Certificate[byArray.length];
                this.initCerts(byArray, 0);
            }
        } else {
            byte[] byArray2 = SSL.getPeerCertificate(ReferenceCountedOpenSslEngine.access$400(this.this$0));
            if (ReferenceCountedOpenSslEngine.access$1300(byArray2)) {
                this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
            } else if (ReferenceCountedOpenSslEngine.access$1200((Object[])byArray)) {
                this.peerCerts = new Certificate[]{new OpenSslX509Certificate(byArray2)};
                this.x509PeerCerts = new X509Certificate[]{new OpenSslJavaxX509Certificate(byArray2)};
            } else {
                this.peerCerts = new Certificate[byArray.length + 1];
                this.x509PeerCerts = new X509Certificate[byArray.length + 1];
                this.peerCerts[0] = new OpenSslX509Certificate(byArray2);
                this.x509PeerCerts[0] = new OpenSslJavaxX509Certificate(byArray2);
                this.initCerts(byArray, 1);
            }
        }
    }

    private void initCerts(byte[][] byArray, int n4) {
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            int n7 = n4 + i3;
            this.peerCerts[n7] = new OpenSslX509Certificate(byArray[i3]);
            this.x509PeerCerts[n7] = new OpenSslJavaxX509Certificate(byArray[i3]);
        }
    }

    private void selectApplicationProtocol() {
        ApplicationProtocolConfig$SelectedListenerFailureBehavior applicationProtocolConfig$SelectedListenerFailureBehavior = ReferenceCountedOpenSslEngine.access$1400(this.this$0).selectedListenerFailureBehavior();
        List<String> list = ReferenceCountedOpenSslEngine.access$1400(this.this$0).protocols();
        switch (ReferenceCountedOpenSslEngine.access$1400(this.this$0).protocol()) {
            case NONE: {
                break;
            }
            case ALPN: {
                String string = SSL.getAlpnSelected(ReferenceCountedOpenSslEngine.access$400(this.this$0));
                if (string == null) break;
                ReferenceCountedOpenSslEngine.access$1502(this.this$0, this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string));
                break;
            }
            case NPN: {
                String string = SSL.getNextProtoNegotiated(ReferenceCountedOpenSslEngine.access$400(this.this$0));
                if (string == null) break;
                ReferenceCountedOpenSslEngine.access$1502(this.this$0, this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string));
                break;
            }
            case NPN_AND_ALPN: {
                String string = SSL.getAlpnSelected(ReferenceCountedOpenSslEngine.access$400(this.this$0));
                if (string == null) {
                    string = SSL.getNextProtoNegotiated(ReferenceCountedOpenSslEngine.access$400(this.this$0));
                }
                if (string == null) break;
                ReferenceCountedOpenSslEngine.access$1502(this.this$0, this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string));
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private String selectApplicationProtocol(List<String> list, ApplicationProtocolConfig$SelectedListenerFailureBehavior applicationProtocolConfig$SelectedListenerFailureBehavior, String string) {
        if (applicationProtocolConfig$SelectedListenerFailureBehavior == ApplicationProtocolConfig$SelectedListenerFailureBehavior.ACCEPT) {
            return string;
        }
        int n4 = list.size();
        if (!$assertionsDisabled && n4 <= 0) {
            throw new AssertionError();
        }
        if (list.contains(string)) {
            return string;
        }
        if (applicationProtocolConfig$SelectedListenerFailureBehavior == ApplicationProtocolConfig$SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
            return list.get(n4 - 1);
        }
        throw new SSLException("unknown protocol " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Certificate[] getPeerCertificates() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (ReferenceCountedOpenSslEngine.access$1200(this.peerCerts)) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            return (Certificate[])this.peerCerts.clone();
        }
    }

    @Override
    public Certificate[] getLocalCertificates() {
        Certificate[] certificateArray = ReferenceCountedOpenSslEngine.access$1600(this.this$0);
        if (certificateArray == null) {
            return null;
        }
        return (Certificate[])certificateArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate[] getPeerCertificateChain() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (ReferenceCountedOpenSslEngine.access$1200(this.x509PeerCerts)) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            return (X509Certificate[])this.x509PeerCerts.clone();
        }
    }

    @Override
    public Principal getPeerPrincipal() {
        Certificate[] certificateArray = this.getPeerCertificates();
        return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        Certificate[] certificateArray = ReferenceCountedOpenSslEngine.access$1600(this.this$0);
        if (certificateArray == null || certificateArray.length == 0) {
            return null;
        }
        return ((java.security.cert.X509Certificate)certificateArray[0]).getIssuerX500Principal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCipherSuite() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.cipher == null) {
                return "SSL_NULL_WITH_NULL_NULL";
            }
            return this.cipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProtocol() {
        String string = this.protocol;
        if (string == null) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
            synchronized (referenceCountedOpenSslEngine) {
                string = !ReferenceCountedOpenSslEngine.access$300(this.this$0) ? SSL.getVersion(ReferenceCountedOpenSslEngine.access$400(this.this$0)) : "";
            }
        }
        return string;
    }

    @Override
    public String getPeerHost() {
        return this.this$0.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.this$0.getPeerPort();
    }

    @Override
    public int getPacketBufferSize() {
        return this.this$0.maxEncryptedPacketLength();
    }

    @Override
    public int getApplicationBufferSize() {
        return this.applicationBufferSize;
    }

    @Override
    public void tryExpandApplicationBufferSize(int n4) {
        if (n4 > ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH && this.applicationBufferSize != ReferenceCountedOpenSslEngine.access$1700()) {
            this.applicationBufferSize = ReferenceCountedOpenSslEngine.access$1700();
        }
    }

    static {
        $assertionsDisabled = !ReferenceCountedOpenSslEngine.class.desiredAssertionStatus();
    }
}

