/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig$SelectorFailureBehavior;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteConverter;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslCachingKeyMaterialProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslEngineMap;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslPrivateKeyMethod;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionStats;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslX509Certificate;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslX509TrustManagerWrapper;
import io.grpc.netty.shaded.io.netty.handler.ssl.PemEncoded;
import io.grpc.netty.shaded.io.netty.handler.ssl.PemPrivateKey;
import io.grpc.netty.shaded.io.netty.handler.ssl.PemX509Certificate;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext$1;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext$2;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext$3;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext$4;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext$DefaultOpenSslEngineMap;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext$PrivateKeyMethod;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSLContext;
import io.grpc.netty.shaded.io.netty.util.AbstractReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetector;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetectorFactory;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakTracker;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
    private static final int DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE = AccessController.doPrivileged(new ReferenceCountedOpenSslContext$1());
    static final boolean USE_TASKS = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.handler.ssl.openssl.useTasks", false);
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    protected static final int VERIFY_DEPTH = 10;
    protected long ctx;
    private final List<String> unmodifiableCiphers;
    private final long sessionCacheSize;
    private final long sessionTimeout;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeakTracker<ReferenceCountedOpenSslContext> leak;
    private final AbstractReferenceCounted refCnt = new ReferenceCountedOpenSslContext$2(this);
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final String[] protocols;
    final boolean enableOcsp;
    final OpenSslEngineMap engineMap = new ReferenceCountedOpenSslContext$DefaultOpenSslEngineMap(null);
    final ReadWriteLock ctxLock = new ReentrantReadWriteLock();
    private volatile int bioNonApplicationBufferSize = DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;

    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l10, int n4, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl3, boolean bl4, boolean bl5) {
        this(iterable, cipherSuiteFilter, ReferenceCountedOpenSslContext.toNegotiator(applicationProtocolConfig), l2, l10, n4, certificateArray, clientAuth, stringArray, bl3, bl4, bl5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l10, int n4, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl3, boolean bl4, boolean bl5) {
        super(bl3);
        OpenSsl.ensureAvailability();
        if (bl4 && !OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported.");
        }
        if (n4 != 1 && n4 != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        this.leak = bl5 ? leakDetector.track(this) : null;
        this.mode = n4;
        this.clientAuth = this.isServer() ? ObjectUtil.checkNotNull(clientAuth, "clientAuth") : ClientAuth.NONE;
        this.protocols = stringArray;
        this.enableOcsp = bl4;
        this.keyCertChain = certificateArray == null ? null : (Certificate[])certificateArray.clone();
        this.unmodifiableCiphers = Arrays.asList(ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(iterable, OpenSsl.DEFAULT_CIPHERS, OpenSsl.availableJavaCipherSuites()));
        this.apn = ObjectUtil.checkNotNull(openSslApplicationProtocolNegotiator, "apn");
        boolean bl6 = false;
        try {
            List<String> list;
            int n7;
            try {
                n7 = 30;
                if (OpenSsl.isTlsv13Supported()) {
                    n7 |= 0x20;
                }
                this.ctx = SSLContext.make(n7, n4);
            }
            catch (Exception exception) {
                throw new SSLException("failed to create an SSL_CTX", exception);
            }
            n7 = OpenSsl.isTlsv13Supported() ? 1 : 0;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            try {
                if (this.unmodifiableCiphers.isEmpty()) {
                    SSLContext.setCipherSuite(this.ctx, "", false);
                    if (n7 != 0) {
                        SSLContext.setCipherSuite(this.ctx, "", true);
                    }
                } else {
                    CipherSuiteConverter.convertToCipherStrings(this.unmodifiableCiphers, stringBuilder, stringBuilder2, OpenSsl.isBoringSSL());
                    SSLContext.setCipherSuite(this.ctx, stringBuilder.toString(), false);
                    if (n7 != 0) {
                        SSLContext.setCipherSuite(this.ctx, stringBuilder2.toString(), true);
                    }
                }
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception);
            }
            int n8 = SSLContext.getOptions(this.ctx) | SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1_3 | SSL.SSL_OP_CIPHER_SERVER_PREFERENCE | SSL.SSL_OP_NO_COMPRESSION | SSL.SSL_OP_NO_TICKET;
            if (stringBuilder.length() == 0) {
                n8 |= SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2;
            }
            SSLContext.setOptions(this.ctx, n8);
            SSLContext.setMode(this.ctx, SSLContext.getMode(this.ctx) | SSL.SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER);
            if (DH_KEY_LENGTH != null) {
                SSLContext.setTmpDHLength(this.ctx, DH_KEY_LENGTH);
            }
            if (!(list = openSslApplicationProtocolNegotiator.protocols()).isEmpty()) {
                String[] stringArray2 = list.toArray(new String[0]);
                int n10 = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                switch (openSslApplicationProtocolNegotiator.protocol()) {
                    case NPN: {
                        SSLContext.setNpnProtos(this.ctx, stringArray2, n10);
                        break;
                    }
                    case ALPN: {
                        SSLContext.setAlpnProtos(this.ctx, stringArray2, n10);
                        break;
                    }
                    case NPN_AND_ALPN: {
                        SSLContext.setNpnProtos(this.ctx, stringArray2, n10);
                        SSLContext.setAlpnProtos(this.ctx, stringArray2, n10);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (l2 <= 0L) {
                l2 = SSLContext.setSessionCacheSize(this.ctx, 20480L);
            }
            this.sessionCacheSize = l2;
            SSLContext.setSessionCacheSize(this.ctx, l2);
            if (l10 <= 0L) {
                l10 = SSLContext.setSessionCacheTimeout(this.ctx, 300L);
            }
            this.sessionTimeout = l10;
            SSLContext.setSessionCacheTimeout(this.ctx, l10);
            if (bl4) {
                SSLContext.enableOcsp(this.ctx, this.isClient());
            }
            SSLContext.setUseTasks(this.ctx, USE_TASKS);
            bl6 = true;
        }
        finally {
            if (!bl6) {
                this.release();
            }
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig$SelectorFailureBehavior applicationProtocolConfig$SelectorFailureBehavior) {
        switch (applicationProtocolConfig$SelectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public final long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public final long sessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n4) {
        return this.newEngine0(byteBufAllocator, string, n4, true);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl3) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl3);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n4, boolean bl3) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n4, false), bl3);
    }

    @Override
    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl3, Executor executor) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl3, executor);
    }

    @Override
    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n4, boolean bl3, Executor executor) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n4, false), executor);
    }

    SSLEngine newEngine0(ByteBufAllocator byteBufAllocator, String string, int n4, boolean bl3) {
        return new ReferenceCountedOpenSslEngine(this, byteBufAllocator, string, n4, bl3, true);
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.newEngine(byteBufAllocator, null, -1);
    }

    @Deprecated
    public final long context() {
        return this.sslCtxPointer();
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    @Deprecated
    public void setRejectRemoteInitiatedRenegotiation(boolean bl3) {
        if (!bl3) {
            throw new UnsupportedOperationException("Renegotiation is not supported");
        }
    }

    @Deprecated
    public boolean getRejectRemoteInitiatedRenegotiation() {
        return true;
    }

    public void setBioNonApplicationBufferSize(int n4) {
        this.bioNonApplicationBufferSize = ObjectUtil.checkPositiveOrZero(n4, "bioNonApplicationBufferSize");
    }

    public int getBioNonApplicationBufferSize() {
        return this.bioNonApplicationBufferSize;
    }

    @Deprecated
    public final void setTicketKeys(byte[] byArray) {
        this.sessionContext().setTicketKeys(byArray);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final long sslCtxPointer() {
        Lock lock = this.ctxLock.readLock();
        lock.lock();
        try {
            long l2 = SSLContext.getSslCtx(this.ctx);
            return l2;
        }
        finally {
            lock.unlock();
        }
    }

    public final void setPrivateKeyMethod(OpenSslPrivateKeyMethod openSslPrivateKeyMethod) {
        ObjectUtil.checkNotNull(openSslPrivateKeyMethod, "method");
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setPrivateKeyMethod(this.ctx, new ReferenceCountedOpenSslContext$PrivateKeyMethod(this.engineMap, openSslPrivateKeyMethod));
        }
        finally {
            lock.unlock();
        }
    }

    private void destroy() {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            if (this.ctx != 0L) {
                if (this.enableOcsp) {
                    SSLContext.disableOcsp(this.ctx);
                }
                SSLContext.free(this.ctx);
                this.ctx = 0L;
                OpenSslSessionContext openSslSessionContext = this.sessionContext();
                if (openSslSessionContext != null) {
                    openSslSessionContext.destroy();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i3 = 0; i3 < x509CertificateArray.length; ++i3) {
            x509CertificateArray[i3] = new OpenSslX509Certificate(byArray[i3]);
        }
        return x509CertificateArray;
    }

    protected static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            if (PlatformDependent.javaVersion() >= 7) {
                return OpenSslX509TrustManagerWrapper.wrapIfNeeded((X509TrustManager)trustManager);
            }
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted retain(int n4) {
        this.refCnt.retain(n4);
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public final boolean release(int n4) {
        return this.refCnt.release(n4);
    }

    static void setKeyMaterial(long l2, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) {
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l11 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            l12 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            if (privateKey != null) {
                l10 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, privateKey);
            }
            SSLContext.setCertificateBio(l2, l11, l10, string == null ? "" : string);
            SSLContext.setCertificateChainBio(l2, l12, true);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("failed to set certificate and key", exception);
        }
        finally {
            ReferenceCountedOpenSslContext.freeBio(l10);
            ReferenceCountedOpenSslContext.freeBio(l11);
            ReferenceCountedOpenSslContext.freeBio(l12);
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    static void freeBio(long l2) {
        if (l2 != 0L) {
            SSL.freeBIO(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PrivateKey privateKey) {
        if (privateKey == null) {
            return 0L;
        }
        PemEncoded pemEncoded = PemPrivateKey.toPEM(byteBufAllocator, true, privateKey);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, X509Certificate ... x509CertificateArray) {
        if (x509CertificateArray == null) {
            return 0L;
        }
        if (x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("certChain can't be empty");
        }
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PemEncoded pemEncoded) {
        try {
            long l2;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l10 = ReferenceCountedOpenSslContext.newBIO(byteBuf.retainedSlice());
                return l10;
            }
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
            try {
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                l2 = ReferenceCountedOpenSslContext.newBIO(byteBuf2.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout(byteBuf2);
                    }
                }
                finally {
                    byteBuf2.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout(byteBuf2);
                }
            }
            finally {
                byteBuf2.release();
            }
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newBIO(ByteBuf byteBuf) {
        try {
            long l2 = SSL.newMemBIO();
            int n4 = byteBuf.readableBytes();
            if (SSL.bioWrite(l2, OpenSsl.memoryAddress(byteBuf) + (long)byteBuf.readerIndex(), n4) != n4) {
                SSL.freeBIO(l2);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            long l10 = l2;
            return l10;
        }
        finally {
            byteBuf.release();
        }
    }

    static OpenSslKeyMaterialProvider providerFor(KeyManagerFactory keyManagerFactory, String string) {
        if (keyManagerFactory instanceof OpenSslX509KeyManagerFactory) {
            return ((OpenSslX509KeyManagerFactory)keyManagerFactory).newProvider();
        }
        X509KeyManager x509KeyManager = ReferenceCountedOpenSslContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers());
        if (keyManagerFactory instanceof OpenSslCachingX509KeyManagerFactory) {
            return new OpenSslCachingKeyMaterialProvider(x509KeyManager, string);
        }
        return new OpenSslKeyMaterialProvider(x509KeyManager, string);
    }

    static /* synthetic */ ResourceLeakTracker access$000(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        return referenceCountedOpenSslContext.leak;
    }

    static /* synthetic */ void access$100(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        referenceCountedOpenSslContext.destroy();
    }

    static /* synthetic */ InternalLogger access$300() {
        return logger;
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        NONE_PROTOCOL_NEGOTIATOR = new ReferenceCountedOpenSslContext$3();
        Integer n4 = null;
        try {
            String string = AccessController.doPrivileged(new ReferenceCountedOpenSslContext$4());
            if (string != null) {
                try {
                    n4 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DH_KEY_LENGTH = n4;
    }
}

