/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslEngineMap;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslPrivateKeyMethod;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSLPrivateKeyMethod;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.security.SignatureException;
import javax.net.ssl.SSLException;

final class ReferenceCountedOpenSslContext$PrivateKeyMethod
implements SSLPrivateKeyMethod {
    private final OpenSslEngineMap engineMap;
    private final OpenSslPrivateKeyMethod keyMethod;

    ReferenceCountedOpenSslContext$PrivateKeyMethod(OpenSslEngineMap openSslEngineMap, OpenSslPrivateKeyMethod openSslPrivateKeyMethod) {
        this.engineMap = openSslEngineMap;
        this.keyMethod = openSslPrivateKeyMethod;
    }

    private ReferenceCountedOpenSslEngine retrieveEngine(long l2) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l2);
        if (referenceCountedOpenSslEngine == null) {
            throw new SSLException("Could not find a " + StringUtil.simpleClassName(ReferenceCountedOpenSslEngine.class) + " for sslPointer " + l2);
        }
        return referenceCountedOpenSslEngine;
    }

    @Override
    public byte[] sign(long l2, int n4, byte[] byArray) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.retrieveEngine(l2);
        try {
            return ReferenceCountedOpenSslContext$PrivateKeyMethod.verifyResult(this.keyMethod.sign(referenceCountedOpenSslEngine, n4, byArray));
        }
        catch (Exception exception) {
            referenceCountedOpenSslEngine.initHandshakeException(exception);
            throw exception;
        }
    }

    @Override
    public byte[] decrypt(long l2, byte[] byArray) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.retrieveEngine(l2);
        try {
            return ReferenceCountedOpenSslContext$PrivateKeyMethod.verifyResult(this.keyMethod.decrypt(referenceCountedOpenSslEngine, byArray));
        }
        catch (Exception exception) {
            referenceCountedOpenSslEngine.initHandshakeException(exception);
            throw exception;
        }
    }

    private static byte[] verifyResult(byte[] byArray) {
        if (byArray == null) {
            throw new SignatureException();
        }
        return byArray;
    }
}

