/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslEngineMap;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.grpc.netty.shaded.io.netty.internal.tcnative.CertificateCallback;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class ReferenceCountedOpenSslClientContext$OpenSslClientCertificateCallback
implements CertificateCallback {
    private final OpenSslEngineMap engineMap;
    private final OpenSslKeyMaterialManager keyManagerHolder;

    ReferenceCountedOpenSslClientContext$OpenSslClientCertificateCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
        this.engineMap = openSslEngineMap;
        this.keyManagerHolder = openSslKeyMaterialManager;
    }

    @Override
    public void handle(long l2, byte[] byArray, byte[][] byArray2) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l2);
        try {
            X500Principal[] x500PrincipalArray;
            Set<String> set = ReferenceCountedOpenSslClientContext$OpenSslClientCertificateCallback.supportedClientKeyTypes(byArray);
            String[] stringArray = set.toArray(new String[0]);
            if (byArray2 == null) {
                x500PrincipalArray = null;
            } else {
                x500PrincipalArray = new X500Principal[byArray2.length];
                for (int i3 = 0; i3 < byArray2.length; ++i3) {
                    x500PrincipalArray[i3] = new X500Principal(byArray2[i3]);
                }
            }
            this.keyManagerHolder.setKeyMaterialClientSide(referenceCountedOpenSslEngine, stringArray, x500PrincipalArray);
        }
        catch (Throwable throwable) {
            ReferenceCountedOpenSslClientContext.access$000().debug("request of key failed", throwable);
            referenceCountedOpenSslEngine.initHandshakeException(throwable);
        }
    }

    private static Set<String> supportedClientKeyTypes(byte[] byArray) {
        if (byArray == null) {
            return ReferenceCountedOpenSslClientContext.access$100();
        }
        HashSet<String> hashSet = new HashSet<String>(byArray.length);
        for (byte by2 : byArray) {
            String string = ReferenceCountedOpenSslClientContext$OpenSslClientCertificateCallback.clientKeyType(by2);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static String clientKeyType(byte by2) {
        switch (by2) {
            case 1: {
                return "RSA";
            }
            case 3: {
                return "DH_RSA";
            }
            case 64: {
                return "EC";
            }
            case 65: {
                return "EC_RSA";
            }
            case 66: {
                return "EC_EC";
            }
        }
        return null;
    }
}

