/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.ssl.PemEncoded;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;
import io.grpc.netty.shaded.io.netty.util.AbstractReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.IllegalReferenceCountException;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

class PemValue
extends AbstractReferenceCounted
implements PemEncoded {
    private final ByteBuf content;
    private final boolean sensitive;

    PemValue(ByteBuf byteBuf, boolean bl3) {
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.sensitive = bl3;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    @Override
    public ByteBuf content() {
        int n4 = this.refCnt();
        if (n4 <= 0) {
            throw new IllegalReferenceCountException(n4);
        }
        return this.content;
    }

    @Override
    public PemValue copy() {
        return this.replace(this.content.copy());
    }

    @Override
    public PemValue duplicate() {
        return this.replace(this.content.duplicate());
    }

    @Override
    public PemValue retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    @Override
    public PemValue replace(ByteBuf byteBuf) {
        return new PemValue(byteBuf, this.sensitive);
    }

    @Override
    public PemValue touch() {
        return (PemValue)super.touch();
    }

    @Override
    public PemValue touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public PemValue retain() {
        return (PemValue)super.retain();
    }

    @Override
    public PemValue retain(int n4) {
        return (PemValue)super.retain(n4);
    }

    @Override
    public void deallocate() {
        if (this.sensitive) {
            SslUtils.zeroout(this.content);
        }
        this.content.release();
    }
}

