/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslTlsv13X509ExtendedTrustManager$1;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslTlsv13X509ExtendedTrustManager$DummySSLEngine;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedTrustManager;

final class OpenSslTlsv13X509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager tm;

    private OpenSslTlsv13X509ExtendedTrustManager(X509ExtendedTrustManager x509ExtendedTrustManager) {
        this.tm = x509ExtendedTrustManager;
    }

    static X509ExtendedTrustManager wrap(X509ExtendedTrustManager x509ExtendedTrustManager, boolean bl3) {
        if (PlatformDependent.javaVersion() < 11) {
            try {
                X509Certificate[] x509CertificateArray = new X509Certificate[]{OpenSsl.selfSignedCertificate()};
                if (bl3) {
                    x509ExtendedTrustManager.checkServerTrusted(x509CertificateArray, "RSA", new OpenSslTlsv13X509ExtendedTrustManager$DummySSLEngine(true));
                } else {
                    x509ExtendedTrustManager.checkClientTrusted(x509CertificateArray, "RSA", new OpenSslTlsv13X509ExtendedTrustManager$DummySSLEngine(false));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new OpenSslTlsv13X509ExtendedTrustManager(x509ExtendedTrustManager);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return x509ExtendedTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) {
        this.tm.checkClientTrusted(x509CertificateArray, string, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) {
        this.tm.checkServerTrusted(x509CertificateArray, string, socket);
    }

    private static SSLEngine wrapEngine(SSLEngine sSLEngine) {
        SSLSession sSLSession = sSLEngine.getHandshakeSession();
        if (sSLSession != null && "TLSv1.3".equals(sSLSession.getProtocol())) {
            return new OpenSslTlsv13X509ExtendedTrustManager$1(sSLEngine, sSLEngine, sSLSession);
        }
        return sSLEngine;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) {
        this.tm.checkClientTrusted(x509CertificateArray, string, OpenSslTlsv13X509ExtendedTrustManager.wrapEngine(sSLEngine));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) {
        this.tm.checkServerTrusted(x509CertificateArray, string, OpenSslTlsv13X509ExtendedTrustManager.wrapEngine(sSLEngine));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        this.tm.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        this.tm.checkServerTrusted(x509CertificateArray, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }
}

