/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionContext$EmptyEnumeration;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionStats;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSLContext;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SessionTicketKey;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

public abstract class OpenSslSessionContext
implements SSLSessionContext {
    private static final Enumeration<byte[]> EMPTY = new OpenSslSessionContext$EmptyEnumeration(null);
    private final OpenSslSessionStats stats;
    private final OpenSslKeyMaterialProvider provider;
    final ReferenceCountedOpenSslContext context;

    OpenSslSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
        this.context = referenceCountedOpenSslContext;
        this.provider = openSslKeyMaterialProvider;
        this.stats = new OpenSslSessionStats(referenceCountedOpenSslContext);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("bytes");
        }
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setTicketKeys(byte[] byArray) {
        if (byArray.length % 48 != 0) {
            throw new IllegalArgumentException("keys.length % 48 != 0");
        }
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[byArray.length / 48];
        int n4 = 0;
        for (int i3 = 0; i3 < sessionTicketKeyArray.length; ++i3) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n4, 16);
            byte[] byArray3 = Arrays.copyOfRange(byArray, n4 += 16, 16);
            byte[] byArray4 = Arrays.copyOfRange(byArray, n4, 16);
            n4 += 16;
            sessionTicketKeyArray[i3 += 16] = new SessionTicketKey(byArray2, byArray3, byArray4);
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.clearOptions(this.context.ctx, SSL.SSL_OP_NO_TICKET);
            SSLContext.setSessionTicketKeys(this.context.ctx, sessionTicketKeyArray);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicketKeys(OpenSslSessionTicketKey ... openSslSessionTicketKeyArray) {
        ObjectUtil.checkNotNull(openSslSessionTicketKeyArray, "keys");
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[openSslSessionTicketKeyArray.length];
        for (int i3 = 0; i3 < sessionTicketKeyArray.length; ++i3) {
            sessionTicketKeyArray[i3] = openSslSessionTicketKeyArray[i3].key;
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.clearOptions(this.context.ctx, SSL.SSL_OP_NO_TICKET);
            SSLContext.setSessionTicketKeys(this.context.ctx, sessionTicketKeyArray);
        }
        finally {
            lock.unlock();
        }
    }

    public abstract void setSessionCacheEnabled(boolean var1);

    public abstract boolean isSessionCacheEnabled();

    public OpenSslSessionStats stats() {
        return this.stats;
    }

    final void destroy() {
        if (this.provider != null) {
            this.provider.destroy();
        }
    }
}

