/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSLContext;
import java.util.concurrent.locks.Lock;

public final class OpenSslServerSessionContext
extends OpenSslSessionContext {
    OpenSslServerSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
        super(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
    }

    @Override
    public void setSessionTimeout(int n4) {
        if (n4 < 0) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheTimeout(this.context.ctx, n4);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getSessionTimeout() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            int n4 = (int)SSLContext.getSessionCacheTimeout(this.context.ctx);
            return n4;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void setSessionCacheSize(int n4) {
        if (n4 < 0) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheSize(this.context.ctx, n4);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getSessionCacheSize() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            int n4 = (int)SSLContext.getSessionCacheSize(this.context.ctx);
            return n4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionCacheEnabled(boolean bl3) {
        long l2 = bl3 ? SSL.SSL_SESS_CACHE_SERVER : SSL.SSL_SESS_CACHE_OFF;
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheMode(this.context.ctx, l2);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isSessionCacheEnabled() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            boolean bl3 = SSLContext.getSessionCacheMode(this.context.ctx) == SSL.SSL_SESS_CACHE_SERVER;
            return bl3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSessionIdContext(byte[] byArray) {
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            boolean bl3 = SSLContext.setSessionIdContext(this.context.ctx, byArray);
            return bl3;
        }
        finally {
            lock.unlock();
        }
    }
}

