/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterial;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslPrivateKey;
import io.grpc.netty.shaded.io.netty.handler.ssl.PemEncoded;
import io.grpc.netty.shaded.io.netty.handler.ssl.PemX509Certificate;
import io.grpc.netty.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.grpc.netty.shaded.io.netty.internal.tcnative.SSL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager x509KeyManager, String string) {
        this.keyManager = x509KeyManager;
        this.password = string;
    }

    static void validateKeyMaterialSupported(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) {
        OpenSslKeyMaterialProvider.validateSupported(x509CertificateArray);
        OpenSslKeyMaterialProvider.validateSupported(privateKey, string);
    }

    private static void validateSupported(PrivateKey privateKey, String string) {
        if (privateKey == null) {
            return;
        }
        long l2 = 0L;
        long l10 = 0L;
        try {
            l2 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, privateKey);
            l10 = SSL.parsePrivateKey(l2, string);
        }
        catch (Exception exception) {
            throw new SSLException("PrivateKey type not supported " + privateKey.getFormat(), exception);
        }
        finally {
            SSL.freeBIO(l2);
            if (l10 != 0L) {
                SSL.freePrivateKey(l10);
            }
        }
    }

    private static void validateSupported(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return;
        }
        long l2 = 0L;
        long l10 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(UnpooledByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l2 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemEncoded.retain());
            l10 = SSL.parseX509Chain(l2);
        }
        catch (Exception exception) {
            throw new SSLException("Certificate type not supported", exception);
        }
        finally {
            SSL.freeBIO(l2);
            if (l10 != 0L) {
                SSL.freeX509Chain(l10);
            }
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator byteBufAllocator, String string) {
        X509Certificate[] x509CertificateArray = this.keyManager.getCertificateChain(string);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return null;
        }
        PrivateKey privateKey = this.keyManager.getPrivateKey(string);
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        long l2 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        try {
            OpenSslKeyMaterial openSslKeyMaterial;
            l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            l11 = SSL.parseX509Chain(l2);
            if (privateKey instanceof OpenSslPrivateKey) {
                openSslKeyMaterial = ((OpenSslPrivateKey)privateKey).newKeyMaterial(l11, x509CertificateArray);
            } else {
                l10 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, privateKey);
                l12 = privateKey == null ? 0L : SSL.parsePrivateKey(l10, this.password);
                openSslKeyMaterial = new DefaultOpenSslKeyMaterial(l11, l12, x509CertificateArray);
            }
            l11 = 0L;
            l12 = 0L;
            OpenSslKeyMaterial openSslKeyMaterial2 = openSslKeyMaterial;
            return openSslKeyMaterial2;
        }
        finally {
            SSL.freeBIO(l2);
            SSL.freeBIO(l10);
            if (l11 != 0L) {
                SSL.freeX509Chain(l11);
            }
            if (l12 != 0L) {
                SSL.freePrivateKey(l12);
            }
            pemEncoded.release();
        }
    }

    void destroy() {
    }
}

