/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import io.grpc.netty.shaded.io.netty.internal.tcnative.CertificateVerifier;
import java.security.cert.CertificateException;

public final class OpenSslCertificateException
extends CertificateException {
    private static final long serialVersionUID = 5542675253797129798L;
    private final int errorCode;

    public OpenSslCertificateException(int n4) {
        this((String)null, n4);
    }

    public OpenSslCertificateException(String string, int n4) {
        super(string);
        this.errorCode = OpenSslCertificateException.checkErrorCode(n4);
    }

    public OpenSslCertificateException(String string, Throwable throwable, int n4) {
        super(string, throwable);
        this.errorCode = OpenSslCertificateException.checkErrorCode(n4);
    }

    public OpenSslCertificateException(Throwable throwable, int n4) {
        this(null, throwable, n4);
    }

    public int errorCode() {
        return this.errorCode;
    }

    private static int checkErrorCode(int n4) {
        if (OpenSsl.isAvailable() && !CertificateVerifier.isValid(n4)) {
            throw new IllegalArgumentException("errorCode '" + n4 + "' invalid, see https://www.openssl.org/docs/man1.0.2/apps/verify.html.");
        }
        return n4;
    }
}

