/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterial;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.X509KeyManager;

final class OpenSslCachingKeyMaterialProvider
extends OpenSslKeyMaterialProvider {
    private final ConcurrentMap<String, OpenSslKeyMaterial> cache = new ConcurrentHashMap<String, OpenSslKeyMaterial>();

    OpenSslCachingKeyMaterialProvider(X509KeyManager x509KeyManager, String string) {
        super(x509KeyManager, string);
    }

    @Override
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator byteBufAllocator, String string) {
        OpenSslKeyMaterial openSslKeyMaterial = (OpenSslKeyMaterial)this.cache.get(string);
        if (openSslKeyMaterial == null) {
            openSslKeyMaterial = super.chooseKeyMaterial(byteBufAllocator, string);
            if (openSslKeyMaterial == null) {
                return null;
            }
            OpenSslKeyMaterial openSslKeyMaterial2 = this.cache.putIfAbsent(string, openSslKeyMaterial);
            if (openSslKeyMaterial2 != null) {
                openSslKeyMaterial.release();
                openSslKeyMaterial = openSslKeyMaterial2;
            }
        }
        return openSslKeyMaterial.retain();
    }

    @Override
    void destroy() {
        do {
            Iterator iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                ((OpenSslKeyMaterial)iterator.next()).release();
                iterator.remove();
            }
        } while (!this.cache.isEmpty());
    }
}

